/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.launching;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.zip.ZipException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.internal.core.ExternalFoldersManager;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.typespace.efs.TypeSpaceFileSystem;

public class BuildPathUtils {
    public static IPath createPathForGroup(String groupName) {
        IPath p = null;
        URI uri = null;
        uri = BuildPathUtils.getURIFromGroup(groupName);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = root.findFilesForLocationURI(uri, 8);
        if (files.length == 0) {
            VjetPlugin.error((String)("Group name" + groupName + "could not find path from uri " + uri));
            return null;
        }
        p = files[0].getFullPath();
        return p;
    }

    private static URI getURIFromGroup(String groupName) {
        URI uri = null;
        String paramString = "typespace://" + groupName + "/?group=" + groupName;
        try {
            uri = new URI(paramString);
        }
        catch (URISyntaxException e) {
            VjetPlugin.error((String)("Group name" + groupName), (Throwable)e);
        }
        return uri;
    }

    public static void addLinkForGroup(String group) throws CoreException {
        BuildPathUtils.addLinkForGroup(group, group);
    }

    public static void addLinkForGroup(String group, String linkName) throws CoreException {
        URI uri = BuildPathUtils.getURIFromGroup(group);
        ExternalFoldersManager foldersManager = ModelManager.getExternalManager();
        foldersManager.createLinkFolderKeepFolderName(linkName, (IPath)new Path(linkName), uri, true, null);
    }

    public static void initGroupWithTypeList(String groupName, IFile zipfile) {
        try {
            TypeSpaceFileSystem.initialize((URI)BuildPathUtils.getURIFromGroup(groupName), (IFile)zipfile);
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

