/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.launching;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.BuildpathContainerInitializer;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IAccessRule;
import org.eclipse.dltk.mod.core.IBuildpathAttribute;
import org.eclipse.dltk.mod.core.IBuildpathContainer;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.internal.core.BuildpathEntry;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.vjet.eclipse.internal.launching.BuildPathUtils;
import org.eclipse.vjet.eclipse.internal.launching.VJETZipContainer;

public class VJETZipContainerInitializer
extends BuildpathContainerInitializer {
    private static IAccessRule[] EMPTY_RULES = new IAccessRule[0];

    public void initialize(IPath containerPath, IScriptProject project) throws CoreException {
        IFile getZipFile = project.getProject().getFile(containerPath.lastSegment());
        String groupName = getZipFile.getFullPath().lastSegment();
        IFile zipfile = project.getProject().getFile(groupName);
        BuildPathUtils.initGroupWithTypeList(groupName, zipfile);
        BuildPathUtils.addLinkForGroup(groupName, groupName);
        VJETZipContainer container = new VJETZipContainer(groupName, zipfile.getFullPath());
        container.setEntries(this.createEntries(groupName, getZipFile.getFullPath()));
        DLTKCore.setBuildpathContainer((IPath)containerPath, (IScriptProject[])new IScriptProject[]{project}, (IBuildpathContainer[])new IBuildpathContainer[]{container}, null);
    }

    private List createEntries(String groupName, IPath containerPath) {
        ArrayList<BuildpathEntry> entries = new ArrayList<BuildpathEntry>(1);
        IBuildpathAttribute[] attributes = new IBuildpathAttribute[]{};
        ArrayList excluded = new ArrayList();
        entries.add(new BuildpathEntry(3, 1, ScriptProject.canonicalizedPath((IPath)containerPath), false, BuildpathEntry.INCLUDE_ALL, excluded.toArray(new IPath[excluded.size()]), EMPTY_RULES, false, attributes, false));
        entries.add(new BuildpathEntry(3, 1, ScriptProject.canonicalizedPath((IPath)BuildPathUtils.createPathForGroup(groupName)), false, BuildpathEntry.INCLUDE_ALL, excluded.toArray(new IPath[excluded.size()]), EMPTY_RULES, false, attributes, false));
        return entries;
    }
}

