/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.typespace.efs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.zip.ZipException;
import org.apache.tools.ant.filters.StringInputStream;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.vjet.dsf.jsgen.shared.generate.CodeStyle;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.GeneratorCtx;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.VjoGenerator;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.typespace.efs.TypeSpaceFileSystem;
import org.eclipse.vjet.eclipse.typespace.efs.internal.GroupItem;
import org.eclipse.vjet.eclipse.typespace.efs.internal.GroupPkgDirectoryItem;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class TypeSpaceFileStore
extends FileStore {
    private static final long CURRENT_TIME_MILLIS = System.currentTimeMillis();
    private String name;
    private TypeSpaceFileStore parent;
    private URI uri;
    private final GroupItem groupItem;

    static synchronized GroupItem getRoot(URI uri) throws URISyntaxException, ZipException, IOException, CoreException {
        URI type = new URI(uri.getScheme(), uri.getHost(), null, null);
        GroupItem item = TypeSpaceFileSystem.getItem(type);
        return item;
    }

    public TypeSpaceFileStore(String name, TypeSpaceFileStore parent, URI uri) throws ZipException, URISyntaxException, IOException, CoreException {
        this(name, parent, TypeSpaceFileStore.getRoot(uri).getItem((IPath)new Path(uri.getPath()), 0));
        this.uri = uri;
    }

    public TypeSpaceFileStore(String name, TypeSpaceFileStore parent, GroupItem item) {
        this.name = name;
        this.parent = parent;
        this.groupItem = item;
    }

    public TypeSpaceFileStore(String name, TypeSpaceFileStore parent, GroupItem item, URI uri) {
        this.name = name;
        this.parent = parent;
        this.groupItem = item;
        this.uri = uri;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        if (this.isDirectory()) {
            Collection collection = ((GroupPkgDirectoryItem)this.groupItem).getChildren();
            String[] children = new String[collection.size()];
            Iterator iterator = collection.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                GroupItem zipItem = (GroupItem)iterator.next();
                children[i++] = zipItem.getName();
            }
            return children;
        }
        return new String[0];
    }

    private boolean isDirectory() {
        return this.groupItem instanceof GroupPkgDirectoryItem;
    }

    private String getGroupName() {
        return this.toURI().getHost();
    }

    private String getTypeName() {
        if (!this.isDirectory()) {
            String typename = this.getUri().getPath();
            if (typename.indexOf("/") == 0) {
                typename = typename.substring(1, typename.length());
            }
            typename = typename.replace("/", ".");
            typename = typename.replace(".js", "");
            return typename;
        }
        return "";
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) {
        FileInfo fileInfo = new FileInfo(this.getName());
        if (this.isDirectory()) {
            fileInfo.setDirectory(true);
        } else {
            fileInfo.setDirectory(false);
            fileInfo.setLastModified(CURRENT_TIME_MILLIS);
        }
        fileInfo.setExists(true);
        fileInfo.setAttribute(2, true);
        return fileInfo;
    }

    public IFileStore getChild(String name) {
        if (this.isDirectory()) {
            GroupItem child = ((GroupPkgDirectoryItem)this.groupItem).getItem(name);
            if (child == null) {
                VjetPlugin.error((String)("no child for " + name + ", uri:" + this.getUri()));
                return null;
            }
            TypeSpaceFileStore store = new TypeSpaceFileStore(name, this, child);
            URI childURI = store.getUri();
            TypeSpaceFileSystem.cache(childURI, store);
            return store;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public IFileStore getParent() {
        return this.parent;
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        String typeName = this.getTypeName();
        IJstType type = (IJstType)TypeSpaceMgr.getInstance().getTypeSpace().getType(new TypeName(this.getGroupName(), typeName));
        if (CodeassistUtils.isNativeGroup((String)this.getGroupName()) && type != null) {
            VjoGenerator gen = new VjoGenerator(new GeneratorCtx(CodeStyle.PRETTY));
            gen.writeType(type);
            return new StringInputStream(gen.getGeneratedText());
        }
        return new StringInputStream("/* Class : " + this.getTypeName() + "\n" + "see outline for more info \n*/");
    }

    public URI toURI() {
        try {
            URI base = this.getBase();
            return new URI(base.getScheme(), null, base.getHost(), 0, this.getPath().toString(), base.getQuery(), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URI getUri() {
        return this.toURI();
    }

    protected IPath getPath() {
        if (this.parent == null) {
            return new Path("/");
        }
        return this.parent.getPath().append(this.getName());
    }

    protected URI getBase() {
        if (this.parent == null) {
            return this.uri;
        }
        return ((TypeSpaceFileStore)this.getParent()).getBase();
    }
}

