/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.mod.ui.PreferencesAdapter;
import org.eclipse.dltk.mod.ui.preferences.AbstractConfigurationBlockPropertyAndPreferencePage;
import org.eclipse.dltk.mod.ui.preferences.AbstractOptionsBlock;
import org.eclipse.dltk.mod.ui.preferences.PreferenceKey;
import org.eclipse.dltk.mod.ui.util.IStatusChangeListener;
import org.eclipse.dltk.mod.ui.util.SWTFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.vjet.eclipse.codeassist.compliance.PredefinedBrowsersPreferenceKeys;
import org.eclipse.vjet.eclipse.internal.ui.preferences.VjetPreferenceMessages;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;

public class VjetCodeCompliancePage
extends AbstractConfigurationBlockPropertyAndPreferencePage {
    private static String PROPERTY_PAGE_ID = "org.eclipse.vjet.eclipse.propertyPage.codeCompliance";
    private static String PREFERENCE_PAGE_ID = "org.eclipse.vjet.eclipse.preferencePage.codeCompliance";
    private static final List<BrowserCompliancePreferenceKey> PREF_KEYS = new ArrayList<BrowserCompliancePreferenceKey>();

    static {
        VjetCodeCompliancePage.initialize();
    }

    private static void initialize() {
        PredefinedBrowsersPreferenceKeys.IBrowserKey[] predefLKeys = PredefinedBrowsersPreferenceKeys.getPredefinedKeys();
        int iter = 0;
        while (iter < predefLKeys.length) {
            PREF_KEYS.add(new BrowserCompliancePreferenceKey(predefLKeys[iter].getBrowser(), predefLKeys[iter].getVersions(), predefLKeys[iter].isTargetedBrowserPredefKey(), predefLKeys[iter].takeTargetedBrowserVerPredefKey()));
            ++iter;
        }
    }

    private static PreferenceKey[] toPreferenceKeyArray() {
        PreferenceKey[] array = new PreferenceKey[PREF_KEYS.size() * 2];
        int a = 0;
        int iter = 0;
        while (iter < PREF_KEYS.size()) {
            array[a++] = PREF_KEYS.get(iter).isTargetedBrowserPredefKey;
            array[a++] = PREF_KEYS.get(iter).takeTargetedBrowserVerPredefKey;
            ++iter;
        }
        return array;
    }

    protected AbstractOptionsBlock createOptionsBlock(IStatusChangeListener changeListener, IProject project, IWorkbenchPreferenceContainer container) {
        return new AbstractOptionsBlock(changeListener, project, VjetCodeCompliancePage.toPreferenceKeyArray(), container){
            private List<Combo> combos;
            {
                this.combos = new ArrayList<Combo>();
            }

            protected Control createOptionsBlock(Composite parent) {
                Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)768);
                Group allBrowsersGroup = SWTFactory.createGroup((Composite)composite, (String)VjetPreferenceMessages.VjetBrowsersCompliance_group_name, (int)2, (int)1, (int)768);
                this.bindAll((Composite)allBrowsersGroup);
                return composite;
            }

            private void bindAll(Composite parent) {
                for (BrowserCompliancePreferenceKey key : PREF_KEYS) {
                    this.getBooleanValue(key.isTargetedBrowserPredefKey);
                    Button checkBrowser = SWTFactory.createCheckButton((Composite)parent, (String)key.browser);
                    this.bindControl(checkBrowser, key.isTargetedBrowserPredefKey, null);
                    checkBrowser.setEnabled(false);
                    Combo comboVersions = SWTFactory.createCombo((Composite)parent, (int)4, (int)1, (int)1, (String[])key.versions);
                    this.combos.add(comboVersions);
                    this.bindControl(comboVersions, key.takeTargetedBrowserVerPredefKey);
                    comboVersions.setEnabled(this.getBooleanValue(key.isTargetedBrowserPredefKey));
                    checkBrowser.addSelectionListener((SelectionListener)new CheckBrowserListener(key, checkBrowser, comboVersions));
                }
            }

            public void performDefaults() {
                super.performDefaults();
                for (Combo combo : this.combos) {
                    combo.setEnabled(false);
                }
            }

            class CheckBrowserListener
            implements SelectionListener {
                private BrowserCompliancePreferenceKey key;
                private Button checkBrowserBtn;
                private Combo selectVersCombo;

                CheckBrowserListener(BrowserCompliancePreferenceKey key, Button checkBrowserBtn, Combo selectVersCombo) {
                    this.key = key;
                    this.checkBrowserBtn = checkBrowserBtn;
                    this.selectVersCombo = selectVersCombo;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent se) {
                    boolean isSelected = this.checkBrowserBtn.getSelection();
                    this.selectVersCombo.setEnabled(isSelected);
                    if (isSelected && this.getValue(this.key.takeTargetedBrowserVerPredefKey) == null) {
                        this.setValue(this.key.takeTargetedBrowserVerPredefKey, this.selectVersCombo.getItem(0));
                    }
                }
            }
        };
    }

    protected String getHelpId() {
        return null;
    }

    protected String getProjectHelpId() {
        return null;
    }

    protected void setDescription() {
    }

    protected void setPreferenceStore() {
        this.setPreferenceStore((IPreferenceStore)new PreferencesAdapter(VjetUIPlugin.getDefault().getPluginPreferences()));
    }

    protected String getPreferencePageId() {
        return PREFERENCE_PAGE_ID;
    }

    protected String getPropertyPageId() {
        return PROPERTY_PAGE_ID;
    }

    private static class BrowserCompliancePreferenceKey {
        private static Map<String, Integer> map = new HashMap<String, Integer>();
        private static int id = 0;
        private String browser;
        private String[] versions;
        private PreferenceKey isTargetedBrowserPredefKey;
        private PreferenceKey takeTargetedBrowserVerPredefKey;

        BrowserCompliancePreferenceKey(String browser, String[] versions, String isTargetedBrowserPredefKey, String takeTargetedBrowserVerPredefKey) {
            this.browser = browser;
            this.versions = versions;
            this.isTargetedBrowserPredefKey = new PreferenceKey("org.eclipse.vjet.eclipse.ui", isTargetedBrowserPredefKey);
            this.takeTargetedBrowserVerPredefKey = new PreferenceKey("org.eclipse.vjet.eclipse.ui", takeTargetedBrowserVerPredefKey);
        }
    }
}

