/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.scriptdoc;

import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.List;
import org.eclipse.dltk.mod.core.IField;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.internal.core.VjoExternalSourceModule;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.dltk.mod.internal.core.VjoSourceType;
import org.eclipse.dltk.mod.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.vjet.dsf.jst.IJstGlobalFunc;
import org.eclipse.vjet.dsf.jst.IJstGlobalVar;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.util.JstCommentHelper;
import org.eclipse.vjet.dsf.jstojava.translator.JsDocHelper;
import org.eclipse.vjet.eclipse.internal.ui.scriptdoc.JavaDoc2HTMLTextReader;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjetScriptDocProvider
implements IScriptDocumentationProvider {
    IJstNode m_node;

    public Reader getInfo(IMember element, boolean lookIntoParents, boolean lookIntoExternal) {
        IJstGlobalFunc gprop;
        IJstGlobalVar prop;
        IJstType type;
        IModelElement secondLevelParent;
        String groupName = "";
        String typeName = "";
        if (element instanceof VjoSourceType) {
            IJstType t;
            VjoSourceType module = (VjoSourceType)element;
            if (element.getResource() == null) {
                VjoExternalSourceModule external;
                if (module.getParent() instanceof VjoExternalSourceModule && (t = (external = (VjoExternalSourceModule)module.getParent()).getType()) != null && t.getDoc() != null) {
                    return new JavaDoc2HTMLTextReader(new StringReader(t.getDoc().getComment()));
                }
            } else {
                URI resource = element.getResource().getLocationURI();
                System.out.println(resource);
                groupName = resource.getScheme().equals("typespace") ? resource.getHost() : this.determineGroup(module);
                typeName = module.getFullyQualifiedName(".");
                t = TypeSpaceMgr.findType((String)groupName, (String)typeName);
                if (t != null && t.getDoc() != null) {
                    return new JavaDoc2HTMLTextReader(new StringReader(t.getDoc().getComment()));
                }
            }
        }
        String memberName = element.getElementName();
        if (element.getParent() != null && (secondLevelParent = element.getParent().getParent()) instanceof VjoSourceModule) {
            VjoSourceModule module = (VjoSourceModule)secondLevelParent;
            IJstType t = module.getJstType();
            if (element instanceof VjoSourceType) {
                if (t != null && t.getDoc() != null) {
                    return new JavaDoc2HTMLTextReader(new StringReader(t.getDoc().getComment()));
                }
            } else if (element instanceof IField) {
                IJstProperty property = t.getProperty(element.getElementName());
                if (property != null && !property.getCommentLocations().isEmpty()) {
                    List commentsAsString = JstCommentHelper.getCommentsAsString((IJstType)property.getOwnerType(), (List)property.getCommentLocations());
                    if (commentsAsString.size() > 0) {
                        String jsdoc = (String)commentsAsString.get(0);
                        return new JavaDoc2HTMLTextReader(new StringReader(JsDocHelper.cleanJsDocComment((String)jsdoc)));
                    }
                } else if (property != null && property.getDoc() != null) {
                    return new JavaDoc2HTMLTextReader(new StringReader(property.getDoc().getComment()));
                }
            } else if (element instanceof IMethod) {
                IJstMethod method = t.getMethod(element.getElementName());
                if (method != null && !method.getCommentLocations().isEmpty() && this.m_node != method) {
                    this.m_node = method;
                    List commentsAsString = JstCommentHelper.getCommentsAsString((IJstType)method.getOwnerType(), (List)method.getCommentLocations());
                    if (commentsAsString.size() > 0) {
                        String jsdoc = (String)commentsAsString.get(0);
                        return new JavaDoc2HTMLTextReader(new StringReader(JsDocHelper.cleanJsDocComment((String)jsdoc)));
                    }
                } else if (method != null && method.getDoc() != null && this.m_node != method) {
                    this.m_node = method;
                    return new JavaDoc2HTMLTextReader(new StringReader(method.getDoc().getComment()));
                }
            }
        }
        groupName = element.getScriptProject().getElementName();
        if (element instanceof IMethod) {
            type = TypeSpaceMgr.findType((String)groupName, (String)typeName);
            if (type == null) {
                return new StringReader("");
            }
            IJstMethod m = type.getMethod(memberName);
            if (m == null && (prop = type.getGlobalVar(memberName)) != null && (gprop = prop.getFunction()) != null && gprop.getDoc() != null) {
                return new JavaDoc2HTMLTextReader(new StringReader(gprop.getDoc().getComment()));
            }
            if (m != null && m.getDoc() != null && this.m_node == null) {
                this.m_node = m;
                return new JavaDoc2HTMLTextReader(new StringReader(m.getDoc().getComment()));
            }
        } else if (element instanceof IField && typeName != "") {
            type = TypeSpaceMgr.findType((String)groupName, (String)typeName);
            IJstProperty p = type.getProperty(memberName);
            if (p == null && (prop = type.getGlobalVar(memberName)) != null && (gprop = prop.getProperty()) != null && gprop.getDoc() != null) {
                return new JavaDoc2HTMLTextReader(new StringReader(gprop.getDoc().getComment()));
            }
            if (p != null && p.getDoc() != null) {
                return new JavaDoc2HTMLTextReader(new StringReader(p.getDoc().getComment()));
            }
        }
        return new StringReader("");
    }

    private String determineGroup(VjoSourceType module) {
        return module.getScriptProject().getElementName();
    }

    public Reader getInfo(String content) {
        return null;
    }

    public void clear() {
        this.m_node = null;
    }
}

