/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text.completion;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuffer;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.VjoExternalSourceModule;
import org.eclipse.dltk.mod.internal.core.VjoSourceType;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.internal.core.util.Util;

public class ImportRewriter {
    private static final String CLOSE_BRACKET = ")";
    private static final String TYPE = "type";
    private static final String VJO_IMPORT = "\r\n.needs(\"{0}\")";

    public MultiTextEdit rewrite(VjoSourceType type, IJstType ownerType) {
        MultiTextEdit edit = new MultiTextEdit();
        IVjoSourceModule module = (IVjoSourceModule)type.getSourceModule();
        String name = module.getTypeName().typeName();
        boolean isNative = module instanceof VjoExternalSourceModule;
        if (!(isNative || this.existImport(ownerType, name) || this.isOwnerType(ownerType, name))) {
            IType itype = Util.toIType((IJstType)ownerType);
            this.addImport(itype, edit, name);
        }
        return edit;
    }

    private boolean isOwnerType(IJstType ownerType, String name) {
        return ownerType.getName().equals(name);
    }

    private boolean existImport(IJstType ownerType, String name) {
        boolean exist = false;
        List list = ownerType.getImports();
        for (IJstType jstType : list) {
            if (!name.equals(jstType.getName())) continue;
            exist = true;
            break;
        }
        return exist;
    }

    private void addImport(IType type, MultiTextEdit edit, String name) {
        int index = this.getTypeEndOffset(type);
        if (index != -1) {
            String s = MessageFormat.format(VJO_IMPORT, name);
            InsertEdit insertEdit = new InsertEdit(index + CLOSE_BRACKET.length(), s);
            edit.addChild((TextEdit)insertEdit);
        }
    }

    private int getTypeEndOffset(IType type) {
        int index = -1;
        try {
            IBuffer source = type.getSourceModule().getBuffer();
            String s = String.valueOf(source.getCharacters());
            index = s.indexOf(TYPE);
            if (index != -1) {
                index = s.indexOf(CLOSE_BRACKET, index);
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        return index;
    }
}

