/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.ui.actions.nature;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vjet.eclipse.ui.actions.nature.IAddVjoNaturePolicy;

public class DefaultAddVjoNaturePolicy
implements IAddVjoNaturePolicy {
    @Override
    public boolean accept(IProject project) {
        return true;
    }

    @Override
    public void addVjoNature(IProject project) {
        this.buildBuildPathFile(project);
        this.addVjoNatureID(project);
    }

    protected void addVjoNatureID(IProject project) {
        try {
            if (project.getFile(".project").exists()) {
                return;
            }
            IProjectDescription description = project.getDescription();
            String[] natureIds = description.getNatureIds();
            List<String> natureList = Arrays.asList(natureIds);
            HashSet<String> natureSet = new HashSet<String>();
            natureSet.addAll(natureList);
            natureSet.remove("org.eclipse.vjet.core.nature");
            description.setNatureIds(natureSet.toArray(new String[natureSet.size()]));
            project.setDescription(description, null);
            String[] newNatureIds = new String[natureSet.size() + 1];
            System.arraycopy(natureSet.toArray(), 0, newNatureIds, 1, natureSet.size());
            newNatureIds[0] = "org.eclipse.vjet.core.nature";
            description.setNatureIds(newNatureIds);
            project.setDescription(description, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void buildBuildPathFile(IProject project) {
        try {
            if (project.getFile(".buildpath").exists()) {
                return;
            }
            if (project.getFolder("src").exists()) {
                project.getFile(".buildpath").create(DefaultAddVjoNaturePolicy.class.getResourceAsStream("buildpath.snap"), true, null);
            } else {
                project.getFile(".buildpath").create(DefaultAddVjoNaturePolicy.class.getResourceAsStream("buildpathnosrc.snap"), true, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

