/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.control;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.vjet.dsf.dap.api.anno.ADapSvcErrorHandler;
import org.eclipse.vjet.dsf.dap.api.anno.ADapSvcOnAll;
import org.eclipse.vjet.dsf.dap.api.anno.ADapSvcOnFailure;
import org.eclipse.vjet.dsf.dap.api.anno.ADapSvcOnSuccess;
import org.eclipse.vjet.dsf.dap.api.anno.ADapSvcSuccessHandler;
import org.eclipse.vjet.dsf.dap.event.listener.DapEventListenerHelper;
import org.eclipse.vjet.dsf.dap.event.listener.IDapEventListener;
import org.eclipse.vjet.dsf.dap.event.listener.IJsEventListenerProxy;
import org.eclipse.vjet.dsf.dap.svc.IJsSvcCallbackProxy;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.html.js.IJsFunc;
import org.eclipse.vjet.dsf.javatojs.translate.AstBinding;
import org.eclipse.vjet.dsf.javatojs.util.AstBindingHelper;
import org.eclipse.vjet.dsf.jsgen.shared.generate.CodeStyle;
import org.eclipse.vjet.dsf.jsgen.shared.generate.IJsrGenListener;
import org.eclipse.vjet.dsf.jsgen.shared.generate.SourceGenerator;
import org.eclipse.vjet.dsf.jst.IJstAnnotation;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstVisitor;
import org.eclipse.vjet.dsf.jst.traversal.JstDepthFirstTraversal;
import org.eclipse.vjet.dsf.service.ServiceIdHelper;

public class DapJsrGenListener
implements IJsrGenListener {
    private static final Class<?> EVENT_LISTENER_PROXY = IJsEventListenerProxy.class;
    private static final Class<?> SVC_CALLBACK_PROXY = IJsSvcCallbackProxy.class;
    private static final String SVC_CALLBACK_MTD = "public Map<String,IJsFunc> getProxySvcCallbacks(){";
    private static final String SVC_ERROR_HANDLER_MTD = "public Map<String,IJsFunc> getProxySvcErrorHandlers(){";
    private static final String SVC_CALLBACL_FUNC = "map.put({0}, call(\"{1}\").with(JsHandlerObjectEnum.msgRespData));";
    private static final String SVC_ERROR_HANDLER_FUNC = "map.put({0}, call(\"{1}\").with(JsHandlerObjectEnum.msgRespError));";
    private IJstType m_jstType;
    private List<Class<? extends IDapEventListener>> m_dapInterfaces;
    private List<IJstMethod> m_svcCallback;
    private List<IJstMethod> m_svcSuccessHandler;
    private List<IJstMethod> m_svcErrorHandlers;
    private List<IJstType> m_imports;

    public void initialize(IJstType jstType) {
        if (jstType == null || !jstType.isClass()) {
            return;
        }
        this.m_jstType = jstType;
        this.m_dapInterfaces = new ArrayList<Class<? extends IDapEventListener>>();
        this.m_svcCallback = new ArrayList<IJstMethod>();
        this.m_svcSuccessHandler = new ArrayList<IJstMethod>();
        this.m_svcErrorHandlers = new ArrayList<IJstMethod>();
        this.m_imports = new ArrayList<IJstType>();
        this.processEventListenerInterfaces(jstType);
        this.processSvcHandlers(jstType);
    }

    public void preImports(PrintWriter writer, CodeStyle style) {
    }

    public void postImports(Collection<String> importedTypeNames, PrintWriter writer, CodeStyle style) {
        boolean hasSvcCallbacks;
        boolean hasEvtHandlers;
        if (this.m_jstType == null) {
            return;
        }
        for (IJstType type : this.m_imports) {
            String typeName = AstBindingHelper.getSourceName((IJstNode)type);
            if (typeName == null || importedTypeNames.contains(typeName)) continue;
            writer.append("import ").append(typeName).append(";").append(SourceGenerator.NEWLINE);
        }
        boolean bl = hasEvtHandlers = !this.getEventListenerInterfaces().isEmpty();
        if (hasEvtHandlers) {
            writer.append("import ").append(EVENT_LISTENER_PROXY.getName()).append(";").append(SourceGenerator.NEWLINE);
            writer.append("import ").append(EventType.class.getName()).append(";").append(SourceGenerator.NEWLINE);
        }
        boolean bl2 = hasSvcCallbacks = !this.getSvcSuccessHandlers().isEmpty() || !this.getSvcErrorHandlers().isEmpty();
        if (hasSvcCallbacks) {
            writer.append("import ").append(SVC_CALLBACK_PROXY.getName()).append(";").append(SourceGenerator.NEWLINE);
            writer.append("import ").append(ServiceIdHelper.class.getName()).append(";").append(SourceGenerator.NEWLINE);
        }
        if (hasEvtHandlers || hasSvcCallbacks) {
            writer.append("import ").append(IJsFunc.class.getName()).append(";").append(SourceGenerator.NEWLINE);
            writer.append("import ").append(Map.class.getName()).append(";").append(SourceGenerator.NEWLINE);
            writer.append("import ").append(HashMap.class.getName()).append(";").append(SourceGenerator.NEWLINE);
        }
    }

    public void preInterfaces(PrintWriter writer, CodeStyle style) {
    }

    public void postInterfaces(PrintWriter writer, CodeStyle style) {
        boolean hasImplements;
        if (this.m_jstType == null) {
            return;
        }
        boolean bl = hasImplements = !this.m_jstType.getSatisfies().isEmpty();
        if (!this.getEventListenerInterfaces().isEmpty()) {
            if (hasImplements) {
                writer.append(",");
            } else {
                writer.append(" implements ");
                hasImplements = true;
            }
            writer.append(EVENT_LISTENER_PROXY.getSimpleName());
        }
        if (!this.getSvcSuccessHandlers().isEmpty() || !this.getSvcErrorHandlers().isEmpty()) {
            if (hasImplements) {
                writer.append(",");
            } else {
                writer.append(" implements ");
                hasImplements = true;
            }
            writer.append(SVC_CALLBACK_PROXY.getSimpleName());
        }
    }

    public void preConstructors(PrintWriter writer, CodeStyle style) {
    }

    public void postConstructors(PrintWriter writer, CodeStyle style) {
        List<IJstMethod> svcErrorHandlers;
        List<IJstMethod> svcCallbacks;
        List<Class<? extends IDapEventListener>> interfaces = this.getEventListenerInterfaces();
        if (!interfaces.isEmpty()) {
            this.genEventProxyMtd(interfaces, writer);
        }
        if (!(svcCallbacks = this.getSvcSuccessHandlers()).isEmpty()) {
            this.genSvcHandlerProxy(svcCallbacks, SVC_CALLBACK_MTD, SVC_CALLBACL_FUNC, writer);
        }
        if (!(svcErrorHandlers = this.getSvcErrorHandlers()).isEmpty()) {
            this.genSvcHandlerProxy(svcErrorHandlers, SVC_ERROR_HANDLER_MTD, SVC_ERROR_HANDLER_FUNC, writer);
        }
    }

    private List<Class<? extends IDapEventListener>> getEventListenerInterfaces() {
        if (this.m_jstType == null || this.m_dapInterfaces == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_dapInterfaces);
    }

    private List<IJstMethod> getSvcCallbacks() {
        if (this.m_jstType == null || this.m_svcCallback == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_svcCallback);
    }

    private List<IJstMethod> getSvcSuccessHandlers() {
        if (this.m_jstType == null || this.m_svcSuccessHandler == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_svcSuccessHandler);
    }

    private List<IJstMethod> getSvcErrorHandlers() {
        if (this.m_jstType == null || this.m_svcErrorHandlers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_svcErrorHandlers);
    }

    private void processEventListenerInterfaces(IJstType jstType) {
        AstBinding binding = AstBindingHelper.getAstSrcBinding((IJstNode)jstType);
        if (binding == null) {
            return;
        }
        Collection dapListeners = DapEventListenerHelper.getAllEventListeners();
        Map iNames = binding.getInterfaceNames();
        for (Class listener : dapListeners) {
            if (!iNames.containsValue(listener.getName())) continue;
            this.m_dapInterfaces.add(listener);
        }
    }

    private void processSvcHandlers(IJstType jstType) {
        boolean isSvcHandler;
        for (IJstType itf : jstType.getSatisfies()) {
            if (itf.getAnnotation(ADapSvcSuccessHandler.class.getSimpleName()) == null) continue;
            for (IJstMethod mtd : itf.getMethods()) {
                isSvcHandler = false;
                for (IJstAnnotation anno : mtd.getAnnotations()) {
                    if (ADapSvcOnSuccess.class.getSimpleName().equals(anno.getName().getName())) {
                        this.m_svcSuccessHandler.add(mtd);
                        isSvcHandler = true;
                    }
                    if (ADapSvcOnFailure.class.getSimpleName().equals(anno.getName().getName())) {
                        this.m_svcErrorHandlers.add(mtd);
                        isSvcHandler = true;
                    }
                    if (ADapSvcOnAll.class.getSimpleName().equals(anno.getName().getName())) {
                        this.m_svcCallback.add(mtd);
                        isSvcHandler = true;
                    }
                    if (!isSvcHandler) continue;
                    this.addToImport(anno, this.m_imports);
                }
            }
        }
        for (IJstMethod mtd : jstType.getMethods()) {
            isSvcHandler = false;
            for (IJstAnnotation anno : mtd.getAnnotations()) {
                if (ADapSvcSuccessHandler.class.getSimpleName().equals(anno.getName().getName())) {
                    this.m_svcSuccessHandler.add(mtd);
                    isSvcHandler = true;
                }
                if (ADapSvcErrorHandler.class.getSimpleName().equals(anno.getName().getName())) {
                    this.m_svcErrorHandlers.add(mtd);
                    isSvcHandler = true;
                }
                if (!isSvcHandler) continue;
                this.addToImport(anno, this.m_imports);
            }
        }
    }

    private NormalAnnotation getAnnotation(IJstMethod jstMtd) {
        MethodDeclaration astMtd = AstBindingHelper.getAstMethod((IJstMethod)jstMtd);
        for (Object m : astMtd.modifiers()) {
            if (!(m instanceof NormalAnnotation)) continue;
            return (NormalAnnotation)m;
        }
        AbstractTypeDeclaration astType = AstBindingHelper.getAstType((IJstType)jstMtd.getOwnerType());
        for (Object m : astType.modifiers()) {
            if (!(m instanceof NormalAnnotation)) continue;
            return (NormalAnnotation)m;
        }
        return null;
    }

    private void addToImport(IJstAnnotation anno, List<IJstType> imports) {
        TypeVisitor visitor = new TypeVisitor(imports);
        JstDepthFirstTraversal.accept((IJstNode)anno, (IJstVisitor)visitor);
    }

    private void genEventProxyMtd(List<Class<? extends IDapEventListener>> interfaces, PrintWriter writer) {
        writer.append(SourceGenerator.NEWLINE);
        writer.append(SourceGenerator.NEWLINE).append("    ");
        writer.append("public Map<EventType,IJsFunc> getProxyEventHandlers(){");
        writer.append(SourceGenerator.NEWLINE).append("    ").append("    ");
        writer.append("Map<EventType,IJsFunc> map = new HashMap<EventType,IJsFunc>();");
        for (Class<? extends IDapEventListener> evtListener : interfaces) {
            Method[] mtds;
            Method[] methodArray = mtds = evtListener.getDeclaredMethods();
            int n = mtds.length;
            int n2 = 0;
            while (n2 < n) {
                Method mtd = methodArray[n2];
                String mtdName = mtd.getName();
                String evtName = mtdName.substring(2).toUpperCase();
                writer.append(SourceGenerator.NEWLINE).append("    ").append("    ");
                writer.append("map.put(EventType." + evtName + ", " + mtdName + "());");
                ++n2;
            }
        }
        writer.append(SourceGenerator.NEWLINE).append("    ").append("    ");
        writer.append("return map;");
        writer.append(SourceGenerator.NEWLINE).append("    ");
        writer.append("}");
    }

    private void genSvcHandlerProxy(List<IJstMethod> svcHandlers, String mtdSigniture, String jsFuncPattern, PrintWriter writer) {
        writer.append(SourceGenerator.NEWLINE);
        writer.append(SourceGenerator.NEWLINE).append("    ");
        writer.append(mtdSigniture);
        writer.append(SourceGenerator.NEWLINE).append("    ").append("    ");
        writer.append("Map<String,IJsFunc> map = new HashMap<String,IJsFunc>();");
        if (svcHandlers.size() > 1) {
            writer.append(SourceGenerator.NEWLINE).append("    ").append("    ");
            writer.append("String svcId;");
        }
        for (IJstMethod callback : svcHandlers) {
            writer.append(SourceGenerator.NEWLINE).append("    ").append("    ");
            if (svcHandlers.size() == 1) {
                writer.append("String ");
            }
            writer.append("svcId = ").append(this.genSvcId(callback)).append(";");
            writer.append(SourceGenerator.NEWLINE).append("    ").append("    ");
            writer.append(MessageFormat.format(jsFuncPattern, "svcId", callback.getName().getName()));
        }
        writer.append(SourceGenerator.NEWLINE).append("    ").append("    ");
        writer.append("return map;");
        writer.append(SourceGenerator.NEWLINE).append("    ");
        writer.append("}");
    }

    private String genSvcId(IJstMethod jstMtd) {
        NormalAnnotation anno = this.getAnnotation(jstMtd);
        if (anno == null) {
            return null;
        }
        List values = anno.values();
        if (values.size() < 2) {
            return null;
        }
        MemberValuePair svcName = (MemberValuePair)values.get(1);
        if (values.size() < 3) {
            return svcName.getValue().toString();
        }
        MemberValuePair opName = (MemberValuePair)values.get(2);
        return "ServiceIdHelper.createServiceId(" + svcName.getValue().toString() + "," + opName.getValue().toString() + ")";
    }

    private static class TypeVisitor
    implements IJstVisitor {
        private List<IJstType> m_types = new ArrayList<IJstType>();

        private TypeVisitor(List<IJstType> types) {
            this.m_types = types;
        }

        public void preVisit(IJstNode node) {
        }

        public boolean visit(IJstNode node) {
            if (node instanceof JstIdentifier) {
                this.addType(((JstIdentifier)node).getType());
            } else if (node instanceof IExpr) {
                this.addType(((IExpr)node).getResultType());
            }
            return true;
        }

        public void endVisit(IJstNode node) {
        }

        public void postVisit(IJstNode node) {
        }

        private void addType(IJstType type) {
            if (type == null || this.m_types.contains(type) || type instanceof JstRefType || !(type instanceof JstType)) {
                return;
            }
            this.m_types.add(type);
        }
    }
}

