/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElementStyle;
import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.ECssAttr;

public class AHtmlElementRuntimeStyle
extends AHtmlElementStyle {
    private static final long serialVersionUID = 1L;

    AHtmlElementRuntimeStyle(AHtmlElement elem) {
        super(elem);
    }

    @Override
    protected void update(ECssAttr attr, String value, boolean isString) {
        IBrowserBinding browserBinding;
        String name = attr.domName();
        if (isString) {
            value = "'" + value + "'";
        }
        if ((browserBinding = this.getBrowserBinding()) != null) {
            browserBinding.setElementRuntimeStyleValue((BaseHtmlElement)this.m_elem.getDNode(), name, value);
        }
    }

    @Override
    protected String getCssValue(ECssAttr attr) {
        IBrowserBinding browserBinding = this.getBrowserBinding();
        if (browserBinding != null) {
            return browserBinding.getElementRuntimeStyleValue((BaseHtmlElement)this.m_elem.getDNode(), attr.domName());
        }
        return "";
    }

    @Override
    public Object getPropertyValue(String name) {
        ECssAttr attr = ECssAttr.findByCssName((String)name);
        if (attr != null) {
            return this.getCssValue(attr);
        }
        return null;
    }

    private IBrowserBinding getBrowserBinding() {
        AHtmlDocument doc = this.m_elem.getOwnerDocument();
        if (doc == null) {
            return null;
        }
        return doc.getBrowserBinding();
    }
}

