/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.cnr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureData;
import org.eclipse.vjet.dsf.dap.cnr.DomChangeMessageFormater;
import org.eclipse.vjet.dsf.dap.cnr.IDapCapture;
import org.eclipse.vjet.dsf.dap.cnr.IDapCaptureListener;
import org.eclipse.vjet.dsf.dap.cnr.IEventFilter;
import org.eclipse.vjet.dsf.dap.cnr.ITargetFilter;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapHttpRequest;
import org.eclipse.vjet.dsf.dap.rt.DapHttpResponse;
import org.eclipse.vjet.dsf.dap.rt.DapView;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.liveconnect.client.DLCEvent;
import org.w3c.dom.Node;

public class DapCapture
implements IDapCapture {
    private static final long serialVersionUID = 1L;
    private transient DapCaptureData.IEventCapture m_curEventCapture;
    private transient String m_curCaptureName;
    private DapCaptureData m_capturedData = new DapCaptureData();
    private DapCaptureData.ViewCapture m_curViewCapture;
    private long m_prevEventTime = -1L;
    private IDapCapture.CaptureState m_state;
    private List<IEventFilter> m_eventFilters = new ArrayList<IEventFilter>();
    private List<ITargetFilter> m_targetFilters = new ArrayList<ITargetFilter>();
    private List<IDapCaptureListener> m_captureListeners;
    private static int s_captureCount = 0;

    public DapCapture() {
        this.m_capturedData.setVersion("1.0.0");
        this.m_curEventCapture = new DapCaptureData.EventCapture(this.m_capturedData);
        this.m_capturedData.setInitEventCapture((DapCaptureData.EventCapture)this.m_curEventCapture);
        this.m_state = IDapCapture.CaptureState.started;
        this.m_prevEventTime = -1L;
        this.m_curCaptureName = this.getNextCaptureName();
    }

    public void onAppendChild(Node child) {
        if (this.isDomCaptureOn(child)) {
            this.addDomChange(DomChangeMessageFormater.onAppendChild(child));
        }
    }

    public void onAttrChange(BaseHtmlElement elem, EHtmlAttr attr, boolean value) {
        this.onAttrChange(elem, attr, String.valueOf(value));
    }

    public void onAttrChange(BaseHtmlElement elem, EHtmlAttr attr, String value) {
        if (this.isDomCaptureOn((Node)elem)) {
            this.addDomChange(DomChangeMessageFormater.onAttrChange(elem, attr, value));
        }
    }

    public void onAttrChange(BaseHtmlElement elem, EHtmlAttr attr, int value) {
        this.onAttrChange(elem, attr, String.valueOf(value));
    }

    public void onAttrChange(BaseHtmlElement elem, EHtmlAttr attr, double value) {
        this.onAttrChange(elem, attr, String.valueOf(value));
    }

    public void onClassNameChange(BaseHtmlElement elem, String className) {
        if (this.isDomCaptureOn((Node)elem)) {
            this.addDomChange(DomChangeMessageFormater.onClassNameChange(elem, className));
        }
    }

    public void onElementChange(BaseHtmlElement elem) {
        if (this.isDomCaptureOn((Node)elem)) {
            this.addDomChange(DomChangeMessageFormater.onElementChange(elem));
        }
    }

    public void onHeightChange(BaseHtmlElement node, int height) {
        if (this.isDomCaptureOn((Node)node)) {
            this.addDomChange(DomChangeMessageFormater.onHeightChange(node, height));
        }
    }

    public void onInsert(Node newNode, Node refNode, boolean insertBefore) {
        if (this.isDomCaptureOn(newNode)) {
            this.addDomChange(DomChangeMessageFormater.onInsert(newNode, refNode, insertBefore));
        }
    }

    public void onRemove(Node node) {
        if (this.isDomCaptureOn(node)) {
            this.addDomChange(DomChangeMessageFormater.onRemove(node));
        }
    }

    public void onStyleChange(BaseHtmlElement elem, String name, String value) {
        if (this.isDomCaptureOn((Node)elem)) {
            this.addDomChange(DomChangeMessageFormater.onStyleChange(elem, name, value));
        }
    }

    public void onValueChange(BaseHtmlElement elem, String value) {
        if (this.isDomCaptureOn((Node)elem)) {
            this.addDomChange(DomChangeMessageFormater.onValueChange(elem, value));
        }
    }

    public void onWidthChange(BaseHtmlElement node, int width) {
        if (this.isDomCaptureOn((Node)node)) {
            this.addDomChange(DomChangeMessageFormater.onWidthChange(node, width));
        }
    }

    @Override
    public void onHttpRequest(DapHttpRequest req) {
        if (this.isCaptureOn()) {
            this.m_curEventCapture.addHttpReq(req);
        }
    }

    @Override
    public void onHttpResponse(DapHttpRequest req, DapHttpResponse resp) {
        if (this.isCaptureOn()) {
            this.m_curEventCapture.addHttpResp(req, resp);
        }
    }

    @Override
    public void onHttpTimedOut(DapHttpRequest req) {
    }

    public void request(String data) {
        if (this.isCaptureOn()) {
            this.resetCurrentEventCapture();
            this.m_curEventCapture.addDlcRequest(this.filterDynamicData(data));
        }
    }

    public void response(String data) {
        if (this.isCaptureOn()) {
            this.resetCurrentEventCapture();
            this.m_curEventCapture.addDlcResponse(data);
        }
    }

    public void send(String data) {
        if (this.isCaptureOn()) {
            this.resetCurrentEventCapture();
            this.m_curEventCapture.addDlcSend(this.filterDynamicData(data));
        }
    }

    @Override
    public IDapCapture.CaptureState state() {
        return this.m_state;
    }

    @Override
    public String currentCaptureName() {
        return this.m_curCaptureName;
    }

    @Override
    public void receiveEvent(DLCEvent event) {
        if (this.isEventCaptureOn(event)) {
            long currentEventTime = System.currentTimeMillis();
            if (this.m_prevEventTime == -1L) {
                this.m_prevEventTime = currentEventTime;
            }
            DapCaptureData dapCaptureData = this.m_capturedData;
            dapCaptureData.getClass();
            this.m_curEventCapture = new DapCaptureData.EventCapture(dapCaptureData, event, currentEventTime - this.m_prevEventTime);
            this.getViewCapture().addEventCapture(this.m_curCaptureName, this.m_curEventCapture);
            this.m_prevEventTime = currentEventTime;
        }
    }

    @Override
    public void receiveTask(String msg) {
        if (this.isCaptureOn()) {
            DapCaptureData dapCaptureData = this.m_capturedData;
            dapCaptureData.getClass();
            this.m_curEventCapture = new DapCaptureData.TaskCapture(dapCaptureData, msg);
            this.getViewCapture().addEventCapture(this.m_curCaptureName, this.m_curEventCapture);
        }
    }

    private void resetCurrentEventCapture() {
        if (this.m_curViewCapture == null) {
            return;
        }
        List<DapCaptureData.IEventCapture> ecs = this.m_curViewCapture.getAllEventCaptures();
        int index = ecs.size() - 1;
        if (index > 0) {
            this.m_curEventCapture = ecs.get(index);
        }
    }

    @Override
    public void beginView(DapView view) {
        if (!this.isCaptureOn()) {
            return;
        }
        String url = view == null ? null : view.getUrl();
        DapCaptureData dapCaptureData = this.m_capturedData;
        dapCaptureData.getClass();
        this.m_curViewCapture = new DapCaptureData.ViewCapture(dapCaptureData, url);
        this.m_capturedData.addViewCapture(this.m_curViewCapture);
    }

    @Override
    public void endView() {
        this.m_curViewCapture = null;
    }

    @Override
    public void start(String captureName) {
        if (this.isCaptureOn()) {
            this.stop();
        }
        this.m_state = IDapCapture.CaptureState.started;
        this.m_prevEventTime = System.currentTimeMillis();
        this.m_curCaptureName = captureName == null ? this.getNextCaptureName() : captureName;
    }

    @Override
    public void pause() {
        if (!this.isCaptureOn()) {
            return;
        }
        this.m_state = IDapCapture.CaptureState.paused;
    }

    @Override
    public void resume() {
        if (this.m_curCaptureName == null) {
            return;
        }
        this.m_state = IDapCapture.CaptureState.resumed;
        this.m_prevEventTime = System.currentTimeMillis();
    }

    @Override
    public void stop() {
        this.m_state = IDapCapture.CaptureState.stoped;
        this.m_curCaptureName = null;
    }

    public Map<String, List<DapCaptureData.IEventCapture>> getUserEventCaptures() {
        return this.getViewCapture().getEventCaptures();
    }

    public List<DapCaptureData.IEventCapture> getUserEventCapture(String captureName) {
        return this.getViewCapture().getEventCapture(captureName);
    }

    @Override
    public void addEventFilter(IEventFilter filter) {
        if (filter == null) {
            return;
        }
        if (!this.m_eventFilters.contains(filter)) {
            this.m_eventFilters.add(filter);
        }
    }

    @Override
    public void addTargetFilter(ITargetFilter filter) {
        if (filter == null) {
            return;
        }
        if (!this.m_targetFilters.contains(filter)) {
            this.m_targetFilters.add(filter);
        }
    }

    @Override
    public DapCaptureData getCapturedData() {
        return this.m_capturedData;
    }

    private DapCaptureData.ViewCapture getViewCapture() {
        if (this.m_curViewCapture == null) {
            this.beginView(null);
        }
        return this.m_curViewCapture;
    }

    @Deprecated
    private String filterDynamicData(String data) {
        return data.replaceAll("&amp;_vrdm=[0-9]*", "");
    }

    private boolean isCaptureOn() {
        return this.m_state == IDapCapture.CaptureState.started || this.m_state == IDapCapture.CaptureState.resumed;
    }

    private boolean isEventCaptureOn(DLCEvent event) {
        if (!this.isCaptureOn()) {
            return false;
        }
        for (IEventFilter filter : this.m_eventFilters) {
            if (!filter.filter(event)) continue;
            return false;
        }
        return true;
    }

    private boolean isDomCaptureOn(Node target) {
        if (!this.isCaptureOn()) {
            return false;
        }
        for (ITargetFilter filter : this.m_targetFilters) {
            if (!filter.filter(target)) continue;
            return false;
        }
        return true;
    }

    private void addDomChange(DapCaptureData.IDomChange domChange) {
        if (domChange == null) {
            return;
        }
        this.m_curEventCapture.addDomChange(domChange);
        if (this.m_captureListeners == null) {
            this.m_captureListeners = DapCtx.ctx().getDapConfig().getCaptureListeners();
        }
        if (this.m_captureListeners.isEmpty()) {
            return;
        }
        for (IDapCaptureListener listener : this.m_captureListeners) {
            listener.onDomCapture(domChange);
        }
    }

    private String getNextCaptureName() {
        return "Capture" + s_captureCount++;
    }
}

