/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.cnr;

import org.eclipse.vjet.dsf.dap.cnr.DapCaptureData;
import org.eclipse.vjet.dsf.dap.util.DapDomHelper;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.w3c.dom.Node;

public class DomChangeMessageFormater {
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_WIDTH = "width";
    private static final String ATTR_HEIGHT = "height";

    public static DapCaptureData.IDomChange onAppendChild(Node child) {
        BaseHtmlElement parent = (BaseHtmlElement)child.getParentNode();
        String parentRef = DapDomHelper.getPath((Node)parent);
        return new NodeAppend().setParentPath(parentRef).setNodeHtml(DapDomHelper.getHtml(child));
    }

    public static DapCaptureData.IDomChange onInsert(Node newNode, Node refNode, boolean insertBefore) {
        String siblingRef = DapDomHelper.getPath(refNode);
        return new NodeInsert().setRefPath(siblingRef).setNodeHtml(DapDomHelper.getHtml(newNode)).setInsertBefore(insertBefore);
    }

    public static DapCaptureData.IDomChange onRemove(Node node) {
        String path = DapDomHelper.getPath(node);
        if (path == null) {
            return null;
        }
        return new NodeRemove().setPath(path).setNodeHtml(DapDomHelper.getHtml(node));
    }

    public static DapCaptureData.IDomChange onElementChange(BaseHtmlElement elem) {
        String path = DapDomHelper.getPath((Node)elem);
        if (path == null) {
            return null;
        }
        return new NodeUpdate().setPath(path).setNodeHtml(DapDomHelper.getHtml((Node)elem));
    }

    public static DapCaptureData.IDomChange onValueChange(BaseHtmlElement elem, String value) {
        String path = DapDomHelper.getPath((Node)elem);
        if (path == null) {
            return null;
        }
        return new NodeValueUpdate().setPath(path).setValue(value);
    }

    public static DapCaptureData.IDomChange onAttrChange(BaseHtmlElement elem, EHtmlAttr attr, String value) {
        String path = DapDomHelper.getPath((Node)elem);
        if (path == null) {
            return null;
        }
        return new NodeAttrUpdate().setPath(path).setName(attr.name()).setValue(value);
    }

    public static DapCaptureData.IDomChange onClassNameChange(BaseHtmlElement elem, String className) {
        String path = DapDomHelper.getPath((Node)elem);
        if (path == null) {
            return null;
        }
        return new NodeAttrUpdate().setPath(path).setName(ATTR_CLASS).setValue(className);
    }

    public static DapCaptureData.IDomChange onHeightChange(BaseHtmlElement node, int height) {
        String path = DapDomHelper.getPath((Node)node);
        if (path == null) {
            return null;
        }
        return new NodeAttrUpdate().setPath(path).setName(ATTR_HEIGHT).setValue(String.valueOf(height));
    }

    public static DapCaptureData.IDomChange onWidthChange(BaseHtmlElement node, int width) {
        String path = DapDomHelper.getPath((Node)node);
        if (path == null) {
            return null;
        }
        return new NodeAttrUpdate().setPath(path).setName(ATTR_WIDTH).setValue(String.valueOf(width));
    }

    public static DapCaptureData.IDomChange onStyleChange(BaseHtmlElement elem, String name, String value) {
        String path = DapDomHelper.getPath((Node)elem);
        if (path == null) {
            return null;
        }
        return new NodeAttrUpdate().setPath(path).setName(name).setValue(value);
    }

    public static class NodeAppend
    implements DapCaptureData.IDomChange {
        private static final long serialVersionUID = 1L;
        private String m_parentPath;
        private String m_nodeHtml;

        public NodeAppend setParentPath(String parentPath) {
            this.m_parentPath = parentPath;
            return this;
        }

        public NodeAppend setNodeHtml(String nodeHtml) {
            this.m_nodeHtml = nodeHtml;
            return this;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("on");
            sb.append("AppendChild").append(":");
            if (this.m_parentPath != null) {
                sb.append(this.m_parentPath);
            }
            sb.append("[").append(this.m_nodeHtml).append("]");
            return sb.toString();
        }
    }

    public static class NodeAttrUpdate
    implements DapCaptureData.IDomChange {
        private static final long serialVersionUID = 1L;
        private String m_path;
        private String m_name;
        private String m_value;

        public NodeAttrUpdate setPath(String path) {
            this.m_path = path;
            return this;
        }

        public NodeAttrUpdate setName(String name) {
            this.m_name = name;
            return this;
        }

        public NodeAttrUpdate setValue(String value) {
            this.m_value = value;
            return this;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("on");
            sb.append("AttrChange").append(":");
            if (this.m_path != null) {
                sb.append(this.m_path);
            }
            if (this.m_name != null) {
                sb.append("[").append(this.m_name).append("]");
            }
            if (this.m_value != null) {
                sb.append("[").append(this.m_value).append("]");
            }
            return sb.toString();
        }
    }

    public static class NodeInsert
    implements DapCaptureData.IDomChange {
        private static final long serialVersionUID = 1L;
        private String m_refPath;
        private String m_nodeHtml;
        private boolean m_insertBefore;

        public NodeInsert setRefPath(String refPath) {
            this.m_refPath = refPath;
            return this;
        }

        public NodeInsert setNodeHtml(String nodeHtml) {
            this.m_nodeHtml = nodeHtml;
            return this;
        }

        public NodeInsert setInsertBefore(boolean insertBefore) {
            this.m_insertBefore = insertBefore;
            return this;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("on");
            sb.append("Insert").append(":");
            if (this.m_refPath != null) {
                sb.append(this.m_refPath);
            }
            sb.append("[").append(this.m_nodeHtml).append("]").append("[").append(this.m_insertBefore).append("]");
            return sb.toString();
        }
    }

    public static class NodeRemove
    implements DapCaptureData.IDomChange {
        private static final long serialVersionUID = 1L;
        private String m_path;
        private String m_nodeHtml;

        public NodeRemove setPath(String path) {
            this.m_path = path;
            return this;
        }

        public NodeRemove setNodeHtml(String nodeHtml) {
            this.m_nodeHtml = nodeHtml;
            return this;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("on");
            sb.append("Remove").append(":");
            if (this.m_path != null) {
                sb.append(this.m_path);
            }
            sb.append("[").append(this.m_nodeHtml).append("]");
            return sb.toString();
        }
    }

    public static class NodeUpdate
    implements DapCaptureData.IDomChange {
        private static final long serialVersionUID = 1L;
        private String m_path;
        private String m_nodeHtml;

        public NodeUpdate setPath(String path) {
            this.m_path = path;
            return this;
        }

        public NodeUpdate setNodeHtml(String nodeHtml) {
            this.m_nodeHtml = nodeHtml;
            return this;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("on");
            sb.append("ElementChange").append(":");
            if (this.m_path != null) {
                sb.append(this.m_path);
            }
            sb.append("[").append(this.m_nodeHtml).append("]");
            return sb.toString();
        }
    }

    public static class NodeValueUpdate
    implements DapCaptureData.IDomChange {
        private static final long serialVersionUID = 1L;
        private String m_path;
        private String m_value;

        public NodeValueUpdate setPath(String path) {
            this.m_path = path;
            return this;
        }

        public NodeValueUpdate setValue(String value) {
            this.m_value = value;
            return this;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("on");
            sb.append("ValueChange").append(":");
            if (this.m_path != null) {
                sb.append(this.m_path);
            }
            if (this.m_value != null) {
                sb.append("[").append(this.m_value).append("]");
            }
            return sb.toString();
        }
    }
}

