/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.WeakHashMap;
import org.eclipse.vjet.dsf.dap.rt.DapBrowserEmulator;
import org.eclipse.vjet.dsf.liveconnect.DLCDispatcher;
import org.eclipse.vjet.dsf.liveconnect.DLCHttpRequest;
import org.eclipse.vjet.dsf.liveconnect.DLCHttpResponse;
import org.eclipse.vjet.dsf.liveconnect.DLCServer;
import org.eclipse.vjet.dsf.liveconnect.IDLCDispatcherInfoCollector;
import org.eclipse.vjet.dsf.liveconnect.IDLCReceiver;
import org.eclipse.vjet.dsf.liveconnect.client.IDLCJsProvider;

public final class DapBrowserBridge
implements IDLCReceiver {
    private DapBrowserEmulator m_browserEmulator;
    private DLCServer m_dlcServer;
    private WeakHashMap<SocketChannel, DLCDispatcher> m_dispatchers = new WeakHashMap();
    private WeakReference<SocketChannel> m_latestChannel = null;

    DapBrowserBridge(DapBrowserEmulator browserEmulator) throws IOException {
        this.m_browserEmulator = browserEmulator;
        this.m_dlcServer = new DLCServer((IDLCReceiver)this, browserEmulator.getDlcClient(), (IDLCJsProvider)browserEmulator.getJsAggregator(), browserEmulator.getResourceHolder());
    }

    public void connected(SocketChannel channel) {
        this.m_browserEmulator.onConnect(channel);
        DLCDispatcher dispatcher = new DLCDispatcher(this.m_dlcServer);
        dispatcher.addChannel(channel);
        dispatcher.setInfoCollector((IDLCDispatcherInfoCollector)this.m_browserEmulator.getDapConfig().getInfoCollector());
        this.m_dispatchers.put(channel, dispatcher);
        this.m_latestChannel = new WeakReference<SocketChannel>(channel);
    }

    public void received(SocketChannel channel, String data) {
        this.m_browserEmulator.onReceive(channel, data);
    }

    public DLCHttpResponse get(SocketChannel channel, DLCHttpRequest request) {
        return null;
    }

    public void closed(SocketChannel channel) {
        this.m_browserEmulator.onClose(channel);
        this.m_dispatchers.remove(channel);
    }

    public void shoudown() {
        if (this.m_dlcServer != null) {
            this.m_dlcServer.shutdown();
            this.m_dlcServer = null;
        }
    }

    synchronized DLCDispatcher getDLCDispatcher(SocketChannel channel) {
        if (channel == null) {
            if (this.m_latestChannel != null) {
                channel = (SocketChannel)this.m_latestChannel.get();
            } else {
                return null;
            }
        }
        return this.m_dispatchers.get(channel);
    }

    int getPort() {
        return this.m_dlcServer.getPort();
    }

    Collection<SocketChannel> getChannels() {
        return this.m_dispatchers.keySet();
    }

    void send(SocketChannel channel, String script) {
        if (script != null && script.length() > 0) {
            this.getDLCDispatcher(channel).send(script);
        }
    }

    String request(SocketChannel channel, String script) {
        if (script != null && script.length() > 0) {
            return this.getDLCDispatcher(channel).request(script, 0);
        }
        return null;
    }
}

