/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.util;

import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.html.HtmlWriterHelper;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DBody;
import org.eclipse.vjet.dsf.html.dom.DHtml;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DapDomHelper {
    private static final String BODY = "body";

    public static String getId(BaseHtmlElement element) {
        String id = element.getHtmlId();
        if (id == null || id.trim().length() == 0) {
            id = element.getNodeName().equalsIgnoreCase(BODY) ? DapDomHelper.getBodyId() : DsfCtx.ctx().ids().nextHtmlId();
            element.setHtmlId(id);
        }
        return id;
    }

    public static String getBodyId() {
        return BODY;
    }

    public static String getPath(Node node) {
        return DapDomHelper.getPath(node, true);
    }

    public static String getPath(Node node, boolean useId) {
        String parentPath;
        String id;
        if (node == null) {
            return null;
        }
        if (node instanceof BaseHtmlElement && useId && (id = ((BaseHtmlElement)node).getHtmlId()) != null && id.length() > 0) {
            if (!DapDomHelper.isInDoc(node)) {
                return null;
            }
            return "document.getElementById('" + id + "')";
        }
        if (node instanceof DBody) {
            return "document.body";
        }
        if (node instanceof DHtml) {
            return "document.documentElement";
        }
        if (node instanceof DHtmlDocument) {
            return "document";
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return null;
        }
        int index = DapDomHelper.getIndex(parent, node);
        if (index >= 0 && (parentPath = DapDomHelper.getPath(parent)) != null) {
            return String.valueOf(parentPath) + ".childNodes[" + String.valueOf(index) + "]";
        }
        return null;
    }

    public static int getIndex(Node parent, Node node) {
        if (!parent.hasChildNodes()) {
            return -1;
        }
        NodeList list = parent.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i) == node) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String getHtml(Node node) {
        StringWriter writer = new StringWriter(1000);
        HtmlWriterHelper.write((Node)node, (Writer)writer, (IIndenter)IIndenter.COMPACT);
        return writer.toString();
    }

    public static boolean isInDoc(Node node) {
        if (node == null) {
            return false;
        }
        if (node instanceof DBody || node instanceof DHtml) {
            return true;
        }
        return DapDomHelper.isInDoc(node.getParentNode());
    }
}

