/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import org.eclipse.vjet.dsf.active.event.IDomChangeListener;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DInput;
import org.eclipse.vjet.dsf.html.js.JSDebug;
import org.eclipse.vjet.dsf.html.js.JSDocument;
import org.eclipse.vjet.dsf.html.js.JSElement;
import org.eclipse.vjet.dsf.html.js.JSWindow;

public class JSInput
extends JSElement {
    private DInput input = null;
    public String name = null;
    public String formId = null;

    private JSInput() {
    }

    public JSInput(JSWindow window, DInput input) {
        super(window, (BaseHtmlElement)input);
        this.input = input;
        this.name = input.getHtmlName();
        this.formId = input.getAttribute("form-id");
        String[] functions = new String[]{"blur", "focus", "select", "click", "valueOf"};
        this.defineFunctionProperties(functions, JSInput.class, 2);
        this.defineProperty("form", JSInput.class, 2);
        this.defineProperty("value", JSInput.class, 2);
        this.defineProperty("defaultValue", JSInput.class, 2);
        this.defineProperty("defaultChecked", JSInput.class, 2);
        this.defineProperty("accept", JSInput.class, 2);
        this.defineProperty("accessKey", JSInput.class, 2);
        this.defineProperty("align", JSInput.class, 2);
        this.defineProperty("alt", JSInput.class, 2);
        this.defineProperty("checked", JSInput.class, 2);
        this.defineProperty("disabled", JSInput.class, 2);
        this.defineProperty("maxLength", JSInput.class, 2);
        this.defineProperty("name", JSInput.class, 2);
        this.defineProperty("readOnly", JSInput.class, 2);
        this.defineProperty("size", JSInput.class, 2);
        this.defineProperty("src", JSInput.class, 2);
        this.defineProperty("tabIndex", JSInput.class, 2);
        this.defineProperty("type", JSInput.class, 2);
        this.defineProperty("useMap", JSInput.class, 2);
    }

    @Override
    public String getClassName() {
        return "JSInputElement";
    }

    public void blur() {
        JSDebug.println("blur is invoked on " + this.name);
    }

    public void focus() {
        JSDebug.println("focus is invoked on " + this.name);
    }

    public void select() {
        JSDebug.println("select is invoked on " + this.name);
    }

    public void click() {
        JSDebug.println("click is invoked on " + this.name);
    }

    @Override
    public JSWindow getWindow() {
        return this.window;
    }

    @Override
    public JSDocument getDocument() {
        return this.window.getJSDocument();
    }

    public Object getForm() {
        return this.window.findFormElement(this.formId, null);
    }

    public String getValue() {
        String value = null;
        if (this.window.windowState != JSWindow.IN_SERVER) {
            value = this.input.getHtmlValue();
        }
        if (this.window.windowState != JSWindow.IN_LOADING) {
            value = this.window.getJSListener().doAction(9, this.name, value, this.formId);
        }
        return value;
    }

    public void setValue(String value) {
        IDomChangeListener listener = this.getListener();
        if (listener != null) {
            listener.onValueChange((BaseHtmlElement)this.input, value);
        }
        if (this.window.windowState == JSWindow.IN_LOADING) {
            this.input.setHtmlValue(value);
        } else {
            this.window.getJSListener().doAction(10, this.name, value, this.formId);
        }
    }

    public String getDefaultValue() {
        return this.input.getHtmlDefaultValue();
    }

    public void setDefaultValue(String defaultValue) {
        this.input.setHtmlDefaultValue(defaultValue);
    }

    public boolean getDefaultChecked() {
        return this.input.getHtmlDefaultChecked();
    }

    public void setDefaultChecked(boolean defaultChecked) {
        this.input.setHtmlDefaultChecked(defaultChecked);
    }

    public String getAccept() {
        return this.input.getHtmlAccept();
    }

    public void setAccept(String accept) {
        this.input.setHtmlAccept(accept);
    }

    public String getAccessKey() {
        return this.input.getHtmlAccessKey();
    }

    public void setAccessKey(String accessKey) {
        this.input.setHtmlAccessKey(accessKey);
    }

    public String getAlign() {
        return this.input.getHtmlAlign();
    }

    public void setAlign(String align) {
        this.input.setHtmlAlign(align);
    }

    public String getAlt() {
        return this.input.getHtmlAlt();
    }

    public void setAlt(String alt) {
        this.input.setHtmlAlt(alt);
    }

    public boolean getChecked() {
        boolean checked = false;
        if (this.window.windowState != JSWindow.IN_SERVER) {
            checked = this.input.getHtmlChecked();
        }
        if (this.window.windowState != JSWindow.IN_LOADING) {
            checked = Boolean.valueOf(this.window.getJSListener().doAction(11, this.name, String.valueOf(checked), this.formId));
        }
        return checked;
    }

    public void setChecked(boolean checked) {
        if (this.window.windowState == JSWindow.IN_LOADING) {
            this.input.setHtmlChecked(checked);
        } else {
            this.window.getJSListener().doAction(12, this.name, String.valueOf(checked), this.formId);
        }
    }

    public boolean getDisabled() {
        return this.input.getHtmlDisabled();
    }

    public void setDisabled(boolean disabled) {
        this.input.setHtmlDisabled(disabled);
    }

    public int getMaxLength() {
        return this.input.getHtmlMaxLength();
    }

    public void setMaxLength(int maxLength) {
        this.input.setHtmlMaxLength(maxLength);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.input.setHtmlName(name);
        this.name = name;
    }

    public boolean getReadOnly() {
        return this.input.getHtmlReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.input.setHtmlReadOnly(readOnly);
    }

    public String getSize() {
        return this.input.getHtmlSize();
    }

    public void setSize(String size) {
        this.input.setHtmlSize(size);
    }

    public String getSrc() {
        return this.input.getHtmlSrc();
    }

    public void setSrc(String src) {
        this.input.setHtmlSrc(src);
    }

    public int getTabIndex() {
        return this.input.getHtmlTabIndex();
    }

    public void setTabIndex(int tabIndex) {
        this.input.setHtmlTabIndex(tabIndex);
    }

    public String getType() {
        return this.input.getHtmlType();
    }

    public String getUseMap() {
        return this.input.getHtmlUseMap();
    }

    public void setUseMap(String useMap) {
        this.input.setHtmlUseMap(useMap);
    }

    @Override
    public Object valueOf(String type) {
        if (type.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (type.equals("string")) {
            return this.getValue();
        }
        if (type.equals("object")) {
            return this;
        }
        if (type.equals("number")) {
            return "0";
        }
        return null;
    }

    public DInput getDNode() {
        return this.input;
    }
}

