/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsrunner;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapIntercepter;
import org.eclipse.vjet.dsf.dap.rt.IBrowserEmulatorListener;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocumentBuilder;
import org.eclipse.vjet.dsf.html.dom.DScript;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.jsrunner.BrowserLauncher;
import org.eclipse.vjet.dsf.jsrunner.IBrowserLauncher;

public class ActiveWeb {
    public static final String WEB_EXIT_COMMAND = "/exit";
    public static final String DISPLAY_COMMAND = "/display";
    public static final String WEB_HOST = "localhost";
    private int m_port = 8090;
    private Server m_webServer = null;
    private final DHtmlDocument m_doc;
    private final DapIntercepter m_intercepter;
    private boolean m_windowLoaded = false;
    private boolean m_exit = false;
    private Process m_displayProc = null;
    private final IBrowserLauncher m_browserLauncher;
    private final DapCtx.ExeMode m_mode;

    public ActiveWeb(InputStream is, IBrowserLauncher browserLauncher, DapCtx.ExeMode mode) throws IOException {
        this.m_mode = mode;
        this.m_doc = DHtmlDocumentBuilder.getDocument((InputStream)is);
        this.m_intercepter = new DapIntercepter(WEB_HOST, this.m_mode);
        this.m_browserLauncher = browserLauncher != null ? browserLauncher : BrowserLauncher.getInstance();
    }

    public static void main(String[] args) throws Exception {
        ActiveWeb aWeb = new ActiveWeb(new URL("http://localhost/Html5Tests.html").openConnection().getInputStream(), null, DapCtx.ExeMode.TRANSLATE);
        aWeb.startWebServer();
        aWeb.addListener(new IBrowserEmulatorListener(){

            @Override
            public void windowOnload() {
                AWindow window = DapCtx.ctx().getWindow();
                window.alert("hi");
            }
        });
        aWeb.displayUrlInBrowser(BrowserType.IE_7);
        aWeb.waitForWindowLoaded();
        aWeb.exit();
        aWeb.waitForExit();
        aWeb.destroy();
    }

    public void addListener(final IBrowserEmulatorListener listener) {
        this.m_intercepter.getEmulator().addListener(new IBrowserEmulatorListener(){

            @Override
            public void windowOnload() {
                listener.windowOnload();
                ActiveWeb.this.windowLoaded();
            }
        });
    }

    public void startWebServer() throws Exception {
        while (this.m_port <= 65535) {
            try {
                this.m_webServer = new Server(this.m_port);
                this.m_webServer.setHandler((Handler)new WebHandler());
                this.m_webServer.start();
                break;
            }
            catch (IOException iOException) {
                System.out.println("There is already an existing server on port " + this.m_port + ".");
                if (this.m_webServer != null) {
                    this.m_webServer.stop();
                }
                this.m_webServer = null;
                ++this.m_port;
            }
        }
    }

    public void stopWebServer() {
        if (this.m_webServer != null) {
            try {
                this.m_webServer.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.m_webServer.destroy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.m_webServer = null;
        }
    }

    public void destroy() {
        this.stopWebServer();
        if (this.m_mode != DapCtx.ExeMode.WEB) {
            this.m_intercepter.getEmulator().shutdown();
        }
        if (this.m_displayProc != null) {
            this.m_displayProc.destroy();
        }
    }

    public void finalize() {
        this.destroy();
    }

    private synchronized void windowLoaded() {
        this.m_windowLoaded = true;
        this.notifyAll();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void waitForWindowLoaded() {
        if (!this.m_windowLoaded) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException v0) {}
lbl7:
            // 3 sources

            ** while (!this.m_windowLoaded)
        }
lbl8:
        // 1 sources

    }

    public synchronized void exit() {
        this.m_exit = true;
        this.notifyAll();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void waitForExit() {
        if (!this.m_exit) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException v0) {}
lbl7:
            // 3 sources

            ** while (!this.m_exit)
        }
lbl8:
        // 1 sources

    }

    public void displayUrlInBrowser(BrowserType type) {
        this.m_displayProc = this.m_browserLauncher.launch(this.getWebDisplayUrl(), type);
    }

    public int getWebPort() {
        return this.m_port;
    }

    public String getWebDisplayUrl() {
        return "http://localhost:" + this.m_port + DISPLAY_COMMAND;
    }

    public String getWebExitUrl() {
        return "http://localhost:" + this.m_port + WEB_EXIT_COMMAND;
    }

    public boolean isWebMode() {
        return this.m_mode == DapCtx.ExeMode.WEB;
    }

    public void loadJs(URL url) {
        DScript script = new DScript().setHtmlType("text/javascript");
        String urlStr = url.toExternalForm();
        if (urlStr.startsWith("http")) {
            script.setHtmlSrc(urlStr);
        } else {
            script.add(this.getContent(url));
        }
        this.m_doc.getBody().add((DNode)script);
    }

    private String getContent(URL url) {
        try {
            InputStreamReader r = new InputStreamReader(url.openStream());
            StringBuilder sb = new StringBuilder(100);
            char[] buffer = new char[100];
            int i = 0;
            while (i != -1) {
                i = r.read(buffer);
                if (i <= 0) continue;
                sb.append(buffer, 0, i);
            }
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private class WebHandler
    extends AbstractHandler {
        private WebHandler() {
        }

        public void handle(String arg0, Request arg1, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (ActiveWeb.DISPLAY_COMMAND.equalsIgnoreCase(request.getPathInfo())) {
                ActiveWeb.this.m_intercepter.handleRequest(request, null);
                ActiveWeb.this.m_intercepter.handleResponse(request, response, ActiveWeb.this.m_doc, IIndenter.COMPACT);
                if (ActiveWeb.this.m_mode == DapCtx.ExeMode.WEB) {
                    ActiveWeb.this.windowLoaded();
                    ActiveWeb.this.exit();
                }
            } else if (ActiveWeb.WEB_EXIT_COMMAND.equalsIgnoreCase(request.getPathInfo())) {
                String content = "<html><body>exit</body><html>";
                response.setHeader("Cache-Control", "no-cache");
                ServletOutputStream os = response.getOutputStream();
                os.write(content.getBytes("utf-8"));
                os.flush();
                os.close();
                ActiveWeb.this.exit();
            } else {
                response.sendError(400);
            }
        }
    }
}

