/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.liveconnect;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.vjet.dsf.liveconnect.DLCFutureResultMgr;

public class DLCFutureResult
implements Future<String> {
    private String m_result = null;
    private boolean m_cancelled = false;
    private final String m_requestId;
    private final DLCFutureResultMgr m_mgr;

    DLCFutureResult(String requestId, DLCFutureResultMgr mgr) {
        this.m_requestId = requestId;
        this.m_mgr = mgr;
        this.m_mgr.addFuture(this);
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        this.m_cancelled = true;
        this.notifyAll();
        this.m_mgr.removeFuture(this);
        return true;
    }

    @Override
    public String get() {
        return this.get(0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized String get(long timeout, TimeUnit unit) {
        try {
            this.wait(unit.toMillis(timeout));
            String string = this.m_result;
            return string;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.m_mgr.removeFuture(this);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.m_cancelled;
    }

    @Override
    public boolean isDone() {
        return this.m_result != null;
    }

    synchronized void set(String result) {
        this.m_result = result;
        this.notifyAll();
    }

    String getRequestId() {
        return this.m_requestId;
    }
}

