/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.event.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.html.dom.DScript;

public class JsExportHelper {
    public static void setScriptSource(DScript script, URL jsLinkBaseUrl, String relativePath, String jsFileName, String jsContent) {
        try {
            URL jsLink = new URL(jsLinkBaseUrl, jsFileName);
            if (jsLink.getProtocol().startsWith("file")) {
                File jsFile = new File(jsLink.getFile());
                if (!jsFile.exists()) {
                    jsFile.createNewFile();
                }
                FileOutputStream fos = new FileOutputStream(jsFile);
                try {
                    OutputStreamWriter writer = new OutputStreamWriter(fos);
                    try {
                        writer.write(jsContent);
                    }
                    finally {
                        writer.flush();
                        writer.close();
                    }
                }
                finally {
                    fos.close();
                }
            }
            if (relativePath != null) {
                script.setHtmlSrc(String.valueOf(relativePath) + jsFileName);
            } else {
                script.setHtmlSrc(jsLink.toExternalForm());
            }
        }
        catch (Exception e) {
            throw new DsfRuntimeException(String.valueOf(e.getMessage()) + jsFileName, (Throwable)e);
        }
    }
}

