/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.converter;

import java.util.Date;
import java.util.List;
import org.eclipse.vjet.dsf.common.converter.BaseConverter;
import org.eclipse.vjet.dsf.common.converter.ConversionRuntimeException;
import org.eclipse.vjet.dsf.common.converter.IConversionResult;
import org.eclipse.vjet.dsf.common.converter.IConverter;

public class DateConverter
extends BaseConverter<Date> {
    private static final List<Class> VALID_CONVERSION_TYPES;

    static {
        Class[] types = new Class[]{Date.class, Long.class};
        VALID_CONVERSION_TYPES = DateConverter.immutableTypeList(types);
    }

    @Override
    public final Class<Date> getTargetType() {
        return Date.class;
    }

    @Override
    public List<Class> getValidConversionTypes() {
        return VALID_CONVERSION_TYPES;
    }

    @Override
    public IConversionResult<Date> convert(Object preValue) {
        if (preValue == null) {
            return this.setResult(preValue, null);
        }
        Date value = null;
        Class<?> clz = preValue.getClass();
        try {
            if (clz == Date.class) {
                value = (Date)preValue;
                return this.setResult(preValue, value);
            }
            if (clz == Long.class) {
                value = new Date((Long)preValue);
                return this.setResult(preValue, value);
            }
            return this.setResult(preValue, IConverter.IncompatibleTypeConversionError);
        }
        catch (Exception exception) {
            return this.setResult(preValue, IConverter.UnconvertableValueConversionError);
        }
    }

    public long convertToLong(Object value) {
        return this.convert(value).getValue().getTime();
    }

    public long convertToLong(Object value, long defaultValue) {
        try {
            return this.convertToLong(value);
        }
        catch (ConversionRuntimeException conversionRuntimeException) {
            return defaultValue;
        }
    }
}

