/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.vjet.dsf.common.converter.BaseConverter;
import org.eclipse.vjet.dsf.common.converter.IConversionResult;
import org.eclipse.vjet.dsf.common.converter.IConverter;

public class StringToStringArrayConverter
extends BaseConverter<String[]>
implements IConverter<String[]> {
    private static final List<Class> VALID_CONVERSION_TYPES;
    private final String m_delimeter;

    static {
        Class[] types = new Class[]{String[].class, String.class};
        VALID_CONVERSION_TYPES = StringToStringArrayConverter.immutableTypeList(types);
    }

    public StringToStringArrayConverter(String delimeter) {
        if (delimeter == null || delimeter.length() < 1) {
            throw new IllegalArgumentException("The delimeter for StringToStringArrayConverter cannot be empty");
        }
        this.m_delimeter = delimeter;
    }

    @Override
    public Class<String[]> getTargetType() {
        return String[].class;
    }

    @Override
    public List<Class> getValidConversionTypes() {
        return VALID_CONVERSION_TYPES;
    }

    @Override
    public IConversionResult<String[]> convert(Object preValue) {
        if (preValue == null) {
            return this.setResult(preValue, null);
        }
        String[] value = null;
        Class<?> clz = preValue.getClass();
        try {
            if (clz == String[].class) {
                value = (String[])preValue;
                return this.setResult(preValue, value);
            }
            if (clz == String.class) {
                ArrayList<String> users = new ArrayList<String>();
                StringTokenizer tokenizer = new StringTokenizer((String)preValue, this.m_delimeter, false);
                while (tokenizer.hasMoreTokens()) {
                    String next = tokenizer.nextToken();
                    if (users.contains(next)) continue;
                    users.add(next);
                }
                value = new String[users.size()];
                value = users.toArray(value);
                return this.setResult(preValue, value);
            }
            return this.setResult(preValue, IConverter.IncompatibleTypeConversionError);
        }
        catch (Throwable throwable) {
            return this.setResult(preValue, IConverter.UnconvertableValueConversionError);
        }
    }
}

