/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dapunit;

import java.util.Collection;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureData;
import org.eclipse.vjet.dsf.dap.rt.DapHttpClient;
import org.eclipse.vjet.dsf.dap.rt.DapHttpRequest;
import org.eclipse.vjet.dsf.dap.rt.DapHttpResponse;
import org.eclipse.vjet.dsf.dap.rt.IDapHttpClient;

public class MockDapHttpClient
extends DapHttpClient {
    private int m_speedRatio;
    private Collection<DapCaptureData.DapHttpCall> m_callCaptures;

    public MockDapHttpClient(Collection<DapCaptureData.DapHttpCall> ajaxCalls, int speedRatio) {
        this.m_callCaptures = ajaxCalls;
        this.m_speedRatio = speedRatio;
    }

    public DapHttpResponse send(DapHttpRequest request) {
        DapCaptureData.DapHttpCall call = this.findCall4Req(request);
        if (call != null) {
            this.sleep4Call(call);
            return call.getResponse();
        }
        return null;
    }

    public void send(DapHttpRequest request, IDapHttpClient.IDapCallback callback) {
        DapCaptureData.DapHttpCall call = this.findCall4Req(request);
        if (call != null) {
            new AsyncExecutor(call, callback).start();
        }
    }

    private void sleep4Call(DapCaptureData.DapHttpCall call) {
        long latency = call.getResponseTime();
        try {
            Thread.sleep(latency * (long)this.m_speedRatio);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private DapCaptureData.DapHttpCall findCall4Req(DapHttpRequest request) {
        if (this.m_callCaptures != null) {
            for (DapCaptureData.DapHttpCall call : this.m_callCaptures) {
                if (!this.isEqualsDHR(call.getRequest(), request)) continue;
                return call;
            }
        }
        return null;
    }

    private boolean isEqualsDHR(DapHttpRequest req1, DapHttpRequest req2) {
        boolean flg = false;
        if (req1 != null && req2 != null) {
            flg = this.strEquals(req1.getUrl(), req2.getUrl()) && this.strEquals(req1.getMethod(), req2.getMethod()) && req1.isAsync() == req2.isAsync();
        }
        return flg;
    }

    private boolean strEquals(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return str1 == str2;
        }
        return str1.equals(str2);
    }

    private class AsyncExecutor
    extends Thread {
        DapCaptureData.DapHttpCall m_call;
        IDapHttpClient.IDapCallback m_callback;

        public AsyncExecutor(DapCaptureData.DapHttpCall call, IDapHttpClient.IDapCallback callback) {
            this.m_call = call;
            this.m_callback = callback;
        }

        @Override
        public void run() {
            MockDapHttpClient.this.sleep4Call(this.m_call);
            this.m_callback.onComplete(this.m_call.getResponse());
        }
    }
}

