/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.jsruntime.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.binding.IValueBinding;
import org.eclipse.vjet.dsf.common.converter.IConversionResult;
import org.eclipse.vjet.dsf.common.converter.IConverter;
import org.eclipse.vjet.dsf.common.exceptions.DsfException;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.html.js.IHaveJsParams;
import org.eclipse.vjet.dsf.html.js.IJsVariableBinding;
import org.eclipse.vjet.dsf.html.js.IParams;
import org.eclipse.vjet.dsf.json.serializer.BeanSerializer;
import org.eclipse.vjet.dsf.json.serializer.ISerializer;
import org.eclipse.vjet.dsf.service.serializer.JsonSerializer;
import org.eclipse.vjet.vsf.jsruntime.jsconverters.DefaultJava2JsConverter;
import org.eclipse.vjet.vsf.jsruntime.optimizer.IJsOptimizer;
import org.eclipse.vjet.vsf.jsruntime.optimizer.JavaBeanOptimizer;
import org.eclipse.vjet.vsf.jsruntime.optimizer.OptimizerUtil;

public abstract class BaseJsOptimizer<T>
implements IJsOptimizer<T> {
    public static final String FUNCTION_PARAM_PREFIX = "p";
    private static final String NEW_LINE = "\n";
    protected Map<String, Object> m_optimizedParams = new LinkedHashMap<String, Object>();
    protected Map<IHaveJsParams, Map<String, Object>> m_compParamMap = new HashMap<IHaveJsParams, Map<String, Object>>();
    protected Map<String, JavaBeanOptimizer> m_beanMap = new HashMap<String, JavaBeanOptimizer>();
    protected List<String> m_keys = new ArrayList<String>();
    protected Map<String, String> m_shortKeys = new HashMap<String, String>();
    protected String m_funcName;
    protected boolean m_createMethod = false;
    private boolean m_deferIValueBinding = false;

    public BaseJsOptimizer(IHaveJsParams ref) throws DsfException {
        this(ref, false);
    }

    public BaseJsOptimizer(IHaveJsParams ref, boolean deferIValueBinding) throws DsfException {
        if (ref == null) {
            throw new DsfRuntimeException("JsObjRef must not be null.");
        }
        this.m_deferIValueBinding = deferIValueBinding;
        IParams params = ref.getParams();
        Map map = params.getParams();
        HashMap<String, Object> values = new HashMap<String, Object>();
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            Object val;
            IValueBinding paramValue = (IValueBinding)entry.getValue();
            String key = (String)entry.getKey();
            this.m_shortKeys.put(key, FUNCTION_PARAM_PREFIX + i++);
            if (paramValue instanceof IJsVariableBinding) {
                if (this.m_deferIValueBinding) {
                    return;
                }
                val = ((IJsVariableBinding)paramValue).getVariableRef();
                this.m_optimizedParams.put(key, val);
                values.put(key, val);
            } else {
                val = paramValue.getValue();
                IConverter convert = OptimizerUtil.getDefaultConverter(val);
                ISerializer ser = JsonSerializer.getInstance().getSerializer(val);
                if (val != null && convert instanceof DefaultJava2JsConverter && ser instanceof BeanSerializer) {
                    try {
                        JavaBeanOptimizer bean = new JavaBeanOptimizer(val, this.m_shortKeys.get(key));
                        this.m_optimizedParams.put(key, val);
                        this.m_beanMap.put(key, bean);
                        values.put(key, val);
                    }
                    catch (Exception e) {
                        throw new DsfRuntimeException("Failed to optimize bean for instance", (Throwable)e);
                    }
                } else {
                    IConversionResult result = convert.convert(val);
                    this.m_optimizedParams.put(key, result.getValue());
                    values.put(key, result.getValue());
                }
            }
            this.m_keys.add(key);
        }
        this.m_compParamMap.put(ref, values);
    }

    protected void compareInternal(IHaveJsParams ref) throws DsfException {
        if (ref == null) {
            throw new DsfRuntimeException("JS object/function cannot be null");
        }
        this.m_createMethod = true;
        IParams params = ref.getParams();
        if (params.getParams().size() != this.m_keys.size()) {
            return;
        }
        Map map = params.getParams();
        int i = 0;
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry entry : map.entrySet()) {
            Object val;
            IValueBinding paramValue = (IValueBinding)entry.getValue();
            String key = (String)entry.getKey();
            if (paramValue instanceof IJsVariableBinding) {
                if (this.m_deferIValueBinding) {
                    return;
                }
                val = paramValue;
            } else {
                val = paramValue.getValue();
            }
            IConverter convert = OptimizerUtil.getDefaultConverter(val);
            ISerializer ser = JsonSerializer.getInstance().getSerializer(val);
            if (val != null && convert instanceof DefaultJava2JsConverter && ser instanceof BeanSerializer) {
                JavaBeanOptimizer opt = this.m_beanMap.get(key);
                if (opt != null) {
                    try {
                        String optClz = opt.getOptClass().getName();
                        String valClz = val.getClass().getName();
                        if (!optClz.equals(valClz)) {
                            return;
                        }
                        opt.compare(val);
                        values.put(key, val);
                    }
                    catch (Exception e) {
                        throw new DsfRuntimeException("Failed to optimize bean instance", (Throwable)e);
                    }
                } else {
                    this.m_optimizedParams.remove(key);
                    values.put(key, convert.convert(val).getValue());
                }
            } else {
                Object value = this.m_optimizedParams.get(key);
                IConversionResult result = convert.convert(val);
                values.put(key, result.getValue());
                if (!((String)result.getValue()).equals(value)) {
                    this.m_optimizedParams.remove(key);
                }
            }
            if (i > this.m_keys.size()) {
                this.m_keys.add(key);
            }
            ++i;
        }
        this.m_compParamMap.put(ref, values);
    }

    protected String getDefBegin(String funcName) {
        this.m_funcName = funcName;
        StringBuilder buf = new StringBuilder();
        buf.append("function ").append(funcName).append("(");
        boolean addComma = false;
        for (String key : this.m_keys) {
            JavaBeanOptimizer opt = this.m_beanMap.get(key);
            if (!this.m_optimizedParams.containsKey(key)) {
                if (addComma) {
                    buf.append(",").append(this.m_shortKeys.get(key));
                } else {
                    buf.append(this.m_shortKeys.get(key));
                }
                addComma = true;
                continue;
            }
            if (opt == null) continue;
            List<String> fields = opt.getParamNames();
            for (String field : fields) {
                if (addComma) {
                    buf.append(",").append(field);
                } else {
                    buf.append(field);
                }
                addComma = true;
            }
        }
        buf.append("){");
        return buf.toString();
    }

    protected String getDefEnd() {
        return "};";
    }

    protected String getCallParams() {
        boolean addComma = false;
        StringBuilder buf = new StringBuilder();
        for (String key : this.m_keys) {
            Object val = this.m_optimizedParams.get(key);
            JavaBeanOptimizer opt = this.m_beanMap.get(key);
            if (opt != null && val != null) {
                val = opt.toJson();
            }
            if (val == null) {
                val = this.m_shortKeys.get(key);
            }
            if (addComma) {
                buf.append(",").append(val);
            } else {
                buf.append(val);
            }
            addComma = true;
        }
        return buf.toString();
    }

    protected String createFuncCall(IHaveJsParams ref) {
        if (this.m_funcName == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        Map<String, Object> map = this.m_compParamMap.get(ref);
        IParams p = ref.getParams();
        Map actualParams = p.getParams();
        buf.append(this.m_funcName).append("(");
        boolean addComma = false;
        if (map == null) {
            return "function(){/*Invalid call*/}";
        }
        for (String key : this.m_keys) {
            Object val = map.get(key);
            String params = null;
            JavaBeanOptimizer opt = this.m_beanMap.get(key);
            if (opt != null) {
                params = opt.getParams(map.get(key));
                if (this.m_optimizedParams.get(key) != null) {
                    params = opt.getParams(map.get(key));
                    if (params != null && !"".equals(params)) {
                        if (addComma) {
                            buf.append(",").append(params);
                        } else {
                            buf.append(params);
                            addComma = true;
                        }
                    }
                } else {
                    IValueBinding binding = (IValueBinding)actualParams.get(key);
                    if (binding != null) {
                        Object v = binding.getValue();
                        IConverter convert = OptimizerUtil.getDefaultConverter(v);
                        Object aval = convert.convert(v).getValue();
                        if (addComma) {
                            buf.append(",").append(aval);
                        } else {
                            buf.append(aval);
                            addComma = true;
                        }
                    }
                }
                params = null;
                continue;
            }
            if (this.m_optimizedParams.containsKey(key)) continue;
            if (addComma) {
                buf.append(",").append(val);
                continue;
            }
            buf.append(val);
            addComma = true;
        }
        buf.append(")");
        return buf.toString();
    }
}

