/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.jsruntime.optimizer;

import java.util.Map;
import org.eclipse.vjet.dsf.common.exceptions.DsfException;
import org.eclipse.vjet.dsf.html.js.IHaveJsParams;
import org.eclipse.vjet.dsf.html.js.IJsFunc;
import org.eclipse.vjet.vsf.jsruntime.optimizer.BaseJsOptimizer;

public class JsFuncOptimizer
extends BaseJsOptimizer<IJsFunc> {
    private String m_origFuncName;

    public JsFuncOptimizer(IJsFunc func) throws DsfException {
        super((IHaveJsParams)func, true);
        this.m_origFuncName = func.getName();
    }

    @Override
    public void compare(IJsFunc func) throws DsfException {
        super.compareInternal((IHaveJsParams)func);
    }

    @Override
    public String createDef(String functionName) {
        if (this.m_origFuncName == null || !this.m_createMethod) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.getDefBegin(functionName)).append("return function(event){return this.").append(this.m_origFuncName).append("(").append(this.getCallParams()).append(");};").append(this.getDefEnd());
        return buf.toString();
    }

    @Override
    public String createCall(IJsFunc func) {
        if (!this.m_createMethod) {
            return "";
        }
        Map map = (Map)this.m_compParamMap.get(func);
        if (map == null) {
            StringBuilder buf = new StringBuilder();
            buf.append("function(event){").append(func.generate()).append("}");
            return buf.toString();
        }
        return this.createFuncCall((IHaveJsParams)func);
    }
}

