/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.ovs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.ovs.CaptionedValue;
import org.eclipse.vjet.dsf.common.ovs.ICaptionedValue;
import org.eclipse.vjet.dsf.common.ovs.IOptionValues;
import org.eclipse.vjet.dsf.common.ovs.OtherInfo;

public final class OptionValues<T>
implements IOptionValues {
    private static final String CAPTION_VALUE_IS_NULL = "cv is null";
    private static final String CAPTION_VALUES_IS_NULL = "cvs is null";
    private static final String NOT_FOUND = " is not found in the map";
    private Map<CaptionedValue<T>, OtherInfo> m_map = new LinkedHashMap<CaptionedValue<T>, OtherInfo>();

    public List<ICaptionedValue> getGenericCaptionedValues() {
        if (this.getInternalMap().size() > 0) {
            return new ArrayList<ICaptionedValue>(this.getInternalMap().keySet());
        }
        return Collections.emptyList();
    }

    public OtherInfo getOtherInfo(CaptionedValue<T> cv) {
        Map.Entry<CaptionedValue<CaptionedValue<T>>, OtherInfo> entry = this.getEntry((T)cv);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public boolean contains(CaptionedValue<T> cv) {
        if (cv == null) {
            return false;
        }
        return this.getInternalMap().containsKey(cv);
    }

    @Override
    public boolean contains(OtherInfo otherInfo) {
        if (otherInfo == null) {
            return false;
        }
        return this.getInternalMap().containsValue(otherInfo);
    }

    public Map.Entry<CaptionedValue<T>, OtherInfo> getEntry(CaptionedValue<T> cv) {
        if (cv == null) {
            return null;
        }
        for (Map.Entry<CaptionedValue<T>, OtherInfo> entry : this.getInternalMap().entrySet()) {
            ICaptionedValue key = entry.getKey();
            if (!key.equals(cv)) continue;
            return entry;
        }
        return null;
    }

    public Map.Entry<CaptionedValue<T>, OtherInfo> removeEntry(CaptionedValue<T> cv) {
        if (cv == null) {
            return null;
        }
        Map.Entry<CaptionedValue<T>, OtherInfo> entry = this.getEntry((T)cv);
        if (entry == null) {
            return null;
        }
        OtherInfo value = this.getInternalMap().remove(entry.getKey());
        return value == null ? null : entry;
    }

    public boolean addCaptionedValue(CaptionedValue<T> cv) {
        if (cv == null) {
            DsfExceptionHelper.chuck((String)CAPTION_VALUE_IS_NULL);
        }
        if (this.contains((T)cv)) {
            return false;
        }
        this.m_map.put(cv, null);
        return true;
    }

    public void add(CaptionedValue<T> cv, OtherInfo otherInfo) {
        if (cv == null) {
            DsfExceptionHelper.chuck((String)CAPTION_VALUE_IS_NULL);
        }
        if (this.contains((T)cv)) {
            this.setOtherInfo(cv, otherInfo);
        } else {
            this.m_map.put(cv, otherInfo);
        }
    }

    public void setOtherInfo(CaptionedValue<T> cv, OtherInfo otherInfo) {
        if (cv == null) {
            DsfExceptionHelper.chuck((String)CAPTION_VALUE_IS_NULL);
        }
        if (!this.contains((T)cv)) {
            DsfExceptionHelper.chuck((String)(cv + NOT_FOUND));
        } else {
            this.getEntry((T)cv).setValue(otherInfo);
        }
    }

    public void setCaptionedValues(List<CaptionedValue<T>> cvs) {
        if (cvs == null) {
            DsfExceptionHelper.chuck((String)CAPTION_VALUES_IS_NULL);
        }
        LinkedHashMap<CaptionedValue<T>, OtherInfo> map = new LinkedHashMap<CaptionedValue<T>, OtherInfo>(cvs.size());
        for (CaptionedValue<T> obj : cvs) {
            if (obj == null) continue;
            map.put(obj, null);
        }
        this.setInternalMap(map);
    }

    public List<CaptionedValue<T>> getCaptionedValues() {
        if (this.getInternalMap().size() > 0) {
            return new ArrayList<CaptionedValue<T>>(this.getInternalMap().keySet());
        }
        return Collections.emptyList();
    }

    public boolean contains(T value) {
        return this.getEntry(value) != null;
    }

    public Map.Entry<CaptionedValue<T>, OtherInfo> getEntry(T value) {
        for (Map.Entry<CaptionedValue<T>, OtherInfo> entry : this.m_map.entrySet()) {
            CaptionedValue<T> cv = entry.getKey();
            if (!cv.getValue().equals(value)) continue;
            return entry;
        }
        return null;
    }

    public int removeEntry(T value) {
        int counter = 0;
        Map.Entry<CaptionedValue<T>, OtherInfo> entry = this.getEntry(value);
        while (entry != null) {
            if (this.m_map.remove(entry.getKey()) != null) {
                ++counter;
            }
            entry = this.getEntry(value);
        }
        return counter;
    }

    @Override
    public int size() {
        return this.m_map.size();
    }

    private Map<CaptionedValue<T>, OtherInfo> getInternalMap() {
        return this.m_map;
    }

    private void setInternalMap(LinkedHashMap<CaptionedValue<T>, OtherInfo> map) {
        if (map == null) {
            DsfExceptionHelper.chuck((String)"map is null");
        }
        this.m_map.clear();
        this.m_map = map;
    }
}

