/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace;

import org.eclipse.vjet.dsf.common.trace.IDsfTracer;
import org.eclipse.vjet.dsf.common.trace.ITraceWriter;

public class ConsoleTraceWriter
implements ITraceWriter {
    private static final String ENTER_COLON = "Enter: ";
    private static final String EXIT_COLON = "Exit: ";
    private static final String EXIT = "Exit";
    private static final String CALL_COLON = "Call: ";
    private static final String END_CALL_COLON = "End Call: ";
    private static final String END_CALL = "End Call";
    private static final String LOOP_COLON = "Loop: ";
    private static final String LOOP_STEP = "Step: ";
    private static final String END_LOOP = "End Loop";
    private static final String DOT = ".";
    private static final String COMMA = ",";
    private static final String TAB = "\t";

    public void handleEnterMethod(int depth, String className, String methodName) {
        this.write(String.valueOf(this.getPadding(depth)) + ENTER_COLON + className + DOT + methodName);
    }

    public void handleEnterMethod(int depth, String className, String methodName, String msg) {
        this.write(String.valueOf(this.getPadding(depth)) + ENTER_COLON + className + DOT + methodName + " (" + msg + ")");
    }

    public void handleExitMethod(int depth, String className, String methodName) {
        this.write(String.valueOf(this.getPadding(depth)) + EXIT);
    }

    public void handleExitMethod(int depth, String className, String methodName, IDsfTracer.ExitStatus status) {
        this.write(String.valueOf(this.getPadding(depth)) + EXIT_COLON + status);
    }

    public void handleExitMethod(int depth, String className, String methodName, String msg) {
        this.write(String.valueOf(this.getPadding(depth)) + EXIT_COLON + msg);
    }

    public void handleExitMethod(int depth, String className, String methodName, IDsfTracer.ExitStatus status, String msg) {
        this.write(String.valueOf(this.getPadding(depth)) + EXIT_COLON + status + COMMA + msg);
    }

    public void handleStartCall(int depth, String className, String methodName) {
        this.write(String.valueOf(this.getPadding(depth)) + CALL_COLON + className + DOT + methodName);
    }

    public void handleStartCall(int depth, String className, String methodName, String msg) {
        this.write(String.valueOf(this.getPadding(depth)) + CALL_COLON + className + DOT + methodName + ", " + msg);
    }

    public void handleEndCall(int depth, String className, String methodName, String msg) {
        this.write(String.valueOf(this.getPadding(depth)) + END_CALL_COLON + msg);
    }

    public void handleEndCall(int depth, String className, String methodName) {
        this.write(String.valueOf(this.getPadding(depth)) + END_CALL);
    }

    public void handleStartLoop(int depth, String group) {
        this.write(String.valueOf(this.getPadding(depth)) + LOOP_COLON + group);
    }

    public void handleLoopStep(int depth, String msg) {
        this.write(String.valueOf(this.getPadding(depth + 1)) + LOOP_STEP + msg);
    }

    public void handleEndLoop(int depth, String group) {
        this.write(String.valueOf(this.getPadding(depth)) + END_LOOP);
    }

    public void handleMsg(int depth, String msg) {
        this.write(String.valueOf(this.getPadding(depth + 1)) + msg);
    }

    public void reset() {
    }

    private String getPadding(int depth) {
        StringBuffer padding = new StringBuffer();
        int i = 0;
        while (i < depth) {
            padding.append(TAB);
            ++i;
        }
        return padding.toString();
    }

    private void write(String text) {
    }
}

