/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DElementConstructor;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DOM;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.dom.support.DNamespace;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class DDOMBuilder
implements ContentHandler,
LexicalHandler {
    protected DDocument m_document;
    protected DElement m_current;
    private boolean m_ignoreWhitespace = true;
    private boolean m_done = true;
    protected boolean m_fixDuplicateIds = false;
    private int m_sequence = 0;
    private Set<String> m_ids = new HashSet<String>();
    protected Vector m_preRootNodes;
    private boolean m_normalizeNS = false;
    protected static final DElementConstructor m_domConstructor = new DOM();

    @Override
    public void startDocument() throws SAXException {
        if (!this.m_done) {
            throw new SAXException("startDocument already called.");
        }
        this.m_document = null;
        this.m_done = false;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.m_document == null) {
            throw new SAXException("Document never started or missing document element.");
        }
        if (this.m_current != null) {
            throw new SAXException("Document ended before end of document element.");
        }
        this.m_current = null;
        this.m_done = true;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (localName == null) {
            throw new SAXException("Tag name is null.");
        }
        if (this.m_document == null) {
            this.m_document = new DDocument();
            this.m_current = this.addElem(this.m_document, namespaceURI, localName, qName);
            if (this.m_current == null) {
                throw new SAXException("No document element for this document");
            }
            if (this.m_preRootNodes != null) {
                int i = this.m_preRootNodes.size();
                while (i-- > 0) {
                    this.m_document.insertBefore((Node)this.m_preRootNodes.elementAt(i), this.m_current);
                }
                this.m_preRootNodes = null;
            }
        } else {
            if (this.m_current == null) {
                throw new SAXException("startElement called after end of document element.");
            }
            this.m_current = this.addElem(this.m_current, namespaceURI, localName, qName);
        }
        this.addAttributesToElement(atts);
    }

    private DElement addElem(DNode parent, String namespaceURI, String localName, String qName) throws SAXException {
        String name = localName;
        if ("".equals(localName)) {
            name = qName;
        }
        DElement node = m_domConstructor.domCreateDynamicElement(name);
        if (namespaceURI != null && namespaceURI.length() > 0) {
            int prefixIdx;
            if (!this.m_normalizeNS) {
                this.m_normalizeNS = true;
            }
            if ((prefixIdx = qName.indexOf(":")) != -1) {
                node.setDsfNamespace(DNamespace.getNamespace(qName.substring(0, prefixIdx), namespaceURI));
            } else {
                node.setDsfNamespace(DNamespace.getNamespace(null, namespaceURI));
            }
        }
        parent.add(node);
        return node;
    }

    protected void addAttributesToElement(Attributes atts) {
        if (atts == null) {
            return;
        }
        int i = 0;
        while (i < atts.getLength()) {
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            if ("id".equalsIgnoreCase(name)) {
                DAttr attr = (DAttr)this.m_document.createAttribute(name);
                if (this.shouldFixDuplicateIds()) {
                    while (this.m_ids.contains(value)) {
                        value = String.valueOf(value) + "_" + this.m_sequence++;
                    }
                    this.m_ids.add(value);
                }
                attr.setValue(value);
                this.m_current.setAttributeNode(attr);
                this.m_current.setIdAttribute(name, true);
            } else {
                this.m_current.setAttribute(name, value);
            }
            ++i;
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.m_current == null) {
            throw new SAXException("endElement called with no current node.");
        }
        if (this.m_current.getNamespaceURI() == null) {
            if (!this.m_current.getNodeName().equalsIgnoreCase(localName)) {
                throw new SAXException("mismatch in closing tag name " + localName + "\n" + this.m_current.getNodeName());
            }
        } else if (!this.m_current.getNodeName().equalsIgnoreCase(qName)) {
            throw new SAXException("mismatch in closing tag name " + qName + "\n" + this.m_current.getNodeName());
        }
        this.endElementInternal();
        this.m_current = this.m_current.getParentNode().getNodeType() == 9 ? null : (DElement)this.m_current.getParentNode();
    }

    protected void endElementInternal() {
    }

    public void characters(String text) throws SAXException {
        this.addText(text);
    }

    @Override
    public void characters(char[] text, int start, int length) throws SAXException {
        this.addText(new String(text, start, length));
    }

    @Override
    public void ignorableWhitespace(char[] text, int start, int length) throws SAXException {
        if (!this.m_ignoreWhitespace) {
            this.addText(new String(text, start, length));
        }
    }

    private void addText(String text) throws SAXException {
        if (this.m_current == null) {
            throw new SAXException("character data found outside of element.");
        }
        Node child = this.m_current.getLastChild();
        if (child instanceof DText) {
            ((DText)child).appendData(text);
        } else {
            this.m_current.add(text);
        }
    }

    @Override
    public void processingInstruction(String target, String instruction) throws SAXException {
    }

    public DDocument getDDocument() {
        return this.m_document;
    }

    public DElement getCurrentElement() {
        return this.m_current;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startPrefixMapping(String prefix, String uti) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void comment(char[] text, int start, int length) throws SAXException {
        if (this.m_document == null) {
            return;
        }
        this.m_current.appendChild(this.m_document.createComment(new String(text, start, length)));
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    public boolean shouldFixDuplicateIds() {
        return this.m_fixDuplicateIds;
    }

    public void setFixDuplicateIds(boolean value) {
        this.m_fixDuplicateIds = value;
    }
}

