/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ast.statements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.mod.ast.ASTNode;
import org.eclipse.dltk.mod.ast.ASTVisitor;
import org.eclipse.dltk.mod.ast.expressions.Expression;
import org.eclipse.dltk.mod.utils.CorePrinter;

public class Block
extends Expression {
    private List statements;

    public Block() {
        this.statements = new ArrayList();
    }

    public Block(int start, int end) {
        this(start, end, null);
    }

    public Block(int start, int end, List statems) {
        super(start, end);
        this.statements = statems != null ? new ArrayList(statems) : new ArrayList();
    }

    @Override
    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit(this)) {
            for (ASTNode node : this.statements) {
                node.traverse(visitor);
            }
            visitor.endvisit(this);
        }
    }

    @Override
    public int getKind() {
        return 2008;
    }

    public void acceptStatements(List statems) {
        if (statems == null) {
            throw new IllegalArgumentException();
        }
        this.statements.addAll(statems);
    }

    public List getStatements() {
        return this.statements;
    }

    public void addStatement(ASTNode statem) {
        if (statem == null) {
            throw new IllegalArgumentException();
        }
        this.statements.add(statem);
    }

    @Override
    public void printNode(CorePrinter output) {
        output.indent();
        Iterator it = this.statements.iterator();
        while (it.hasNext()) {
            ((ASTNode)it.next()).printNode(output);
            output.formatPrint("");
        }
        output.formatPrint("");
        output.dedent();
    }

    public void removeStatement(ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.statements.remove(node);
    }
}

