/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.compiler.env;

import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.compiler.CharOperation;
import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;

public class MethodSourceCode
implements ISourceModule {
    private final IMethod method;

    public MethodSourceCode(IMethod method) {
        this.method = method;
    }

    @Override
    public char[] getContentsAsCharArray() {
        try {
            return this.method.getSource().toCharArray();
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return CharOperation.NO_CHAR;
        }
    }

    @Override
    public IModelElement getModelElement() {
        return this.method;
    }

    @Override
    public IPath getScriptFolder() {
        return this.method.getSourceModule().getPath().removeLastSegments(1);
    }

    @Override
    public String getSourceContents() {
        try {
            return this.method.getSource();
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return "";
        }
    }

    @Override
    public char[] getFileName() {
        return this.method.getSourceModule().getPath().toString().toCharArray();
    }
}

