/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.AbstractExternalSourceModule;
import org.eclipse.dltk.mod.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.mod.internal.core.BuiltinScriptFolder;
import org.eclipse.dltk.mod.internal.core.DefaultWorkingCopyOwner;

public class BuiltinSourceModule
extends AbstractExternalSourceModule
implements org.eclipse.dltk.mod.compiler.env.ISourceModule {
    public BuiltinSourceModule(BuiltinScriptFolder parent, String name, WorkingCopyOwner owner) {
        super(parent, name, owner, true);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BuiltinSourceModule)) {
            return false;
        }
        return super.equals(obj);
    }

    public InputStream getContents() {
        String builtinModuleContent = this.getSourceModuleContent();
        if (builtinModuleContent == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(builtinModuleContent.getBytes());
        return input;
    }

    @Override
    public char[] getFileName() {
        return this.getPath().toOSString().toCharArray();
    }

    public IPath getFullPath() {
        return new Path(this.getName());
    }

    public String getName() {
        return this.getElementName();
    }

    @Override
    public boolean isBuiltin() {
        return true;
    }

    @Override
    protected char[] getBufferContent() {
        String content = this.getSourceModuleContent();
        if (content != null) {
            return content.toCharArray();
        }
        return new char[0];
    }

    @Override
    protected String getModuleType() {
        return "DLTK Builtin Source Module: ";
    }

    @Override
    protected String getNatureId() throws CoreException {
        IScriptProject project = this.getScriptProject();
        IDLTKLanguageToolkit toolkit = this.lookupLanguageToolkit(project);
        return toolkit != null ? toolkit.getNatureId() : null;
    }

    @Override
    protected ISourceModule getOriginalSourceModule() {
        return new BuiltinSourceModule((BuiltinScriptFolder)this.getParent(), this.getElementName(), (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    private String getSourceModuleContent() {
        BuiltinProjectFragment fragment = (BuiltinProjectFragment)this.getProjectFragment();
        String builtinModuleContent = fragment.builtinProvider.getBuiltinModuleContent(this.getName());
        return builtinModuleContent;
    }
}

