/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.compiler.CharOperation;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.compiler.env.AccessRestriction;
import org.eclipse.dltk.mod.internal.compiler.env.AccessRuleSet;
import org.eclipse.dltk.mod.internal.core.BuildpathEntry;
import org.eclipse.dltk.mod.internal.core.IModelElementRequestor;
import org.eclipse.dltk.mod.internal.core.ModelElementRequestor;
import org.eclipse.dltk.mod.internal.core.ProjectElementInfo;
import org.eclipse.dltk.mod.internal.core.ProjectFragment;
import org.eclipse.dltk.mod.internal.core.ScriptFolder;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.SingleTypeRequestor;
import org.eclipse.dltk.mod.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.dltk.mod.internal.core.util.Messages;
import org.eclipse.dltk.mod.internal.core.util.Util;

public class NameLookup {
    public static boolean VERBOSE = false;
    private static final IType[] NO_TYPES = new IType[0];
    public static final int ACCEPT_ALL = 0;
    protected IProjectFragment[] projectFragments;
    protected HashtableOfArrayToObject scriptFolders;
    protected HashtableOfArrayToObject isPackageCache;
    protected Map rootToResolvedEntries;
    protected HashMap typesInWorkingCopies;
    public long timeSpentInSeekTypesInSourcePackage = 0L;
    public long timeSpentInSeekTypesInBinaryPackage = 0L;

    public NameLookup(IProjectFragment[] ProjectFragments, HashtableOfArrayToObject ScriptFolders, HashtableOfArrayToObject isPackage, ISourceModule[] workingCopies, Map rootToResolvedEntries) {
        long start = -1L;
        if (VERBOSE) {
            Util.verbose(" BUILDING NameLoopkup");
            Util.verbose(" -> pkg roots size: " + (ProjectFragments == null ? 0 : ProjectFragments.length));
            Util.verbose(" -> pkgs size: " + (ScriptFolders == null ? 0 : ScriptFolders.size()));
            Util.verbose(" -> working copy size: " + (workingCopies == null ? 0 : workingCopies.length));
            start = System.currentTimeMillis();
        }
        this.projectFragments = ProjectFragments;
        if (workingCopies == null) {
            this.scriptFolders = ScriptFolders;
            this.isPackageCache = isPackage;
        } else {
            try {
                this.scriptFolders = (HashtableOfArrayToObject)ScriptFolders.clone();
                this.isPackageCache = (HashtableOfArrayToObject)isPackage.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
            this.typesInWorkingCopies = new HashMap();
            int i = 0;
            int length = workingCopies.length;
            while (i < length) {
                ISourceModule workingCopy = workingCopies[i];
                ScriptFolder pkg = (ScriptFolder)workingCopy.getParent();
                HashMap<String, Object> typeMap = (HashMap<String, Object>)this.typesInWorkingCopies.get(pkg);
                if (typeMap == null) {
                    typeMap = new HashMap<String, Object>();
                    this.typesInWorkingCopies.put(pkg, typeMap);
                }
                try {
                    IType[] types = workingCopy.getTypes();
                    int typeLength = types.length;
                    if (typeLength == 0) {
                        String typeName = workingCopy.getElementName();
                        typeMap.put(typeName, NO_TYPES);
                    } else {
                        int j = 0;
                        while (j < typeLength) {
                            IType type = types[j];
                            String typeName = type.getElementName();
                            Object existing = typeMap.get(typeName);
                            if (existing == null) {
                                typeMap.put(typeName, type);
                            } else if (existing instanceof IType) {
                                typeMap.put(typeName, new IType[]{(IType)existing, type});
                            } else {
                                IType[] existingTypes = (IType[])existing;
                                int existingTypeLength = existingTypes.length;
                                IType[] iTypeArray = existingTypes;
                                existingTypes = new IType[existingTypeLength + 1];
                                System.arraycopy(iTypeArray, 0, existingTypes, 0, existingTypeLength);
                                existingTypes[existingTypeLength] = type;
                                typeMap.put(typeName, existingTypes);
                            }
                            ++j;
                        }
                    }
                }
                catch (ModelException modelException) {}
                IProjectFragment root = (IProjectFragment)pkg.getParent();
                Object[] pkgName = pkg.path.segments();
                Object existing = this.scriptFolders.get(pkgName);
                if (existing == null) {
                    this.scriptFolders.put(pkgName, root);
                    ProjectElementInfo.addNames((String[])pkgName, this.isPackageCache);
                } else if (existing instanceof ProjectFragment) {
                    if (!existing.equals(root)) {
                        this.scriptFolders.put(pkgName, new IProjectFragment[]{(ProjectFragment)existing, root});
                    }
                } else {
                    IProjectFragment[] roots = (IProjectFragment[])existing;
                    int rootLength = roots.length;
                    boolean containsRoot = false;
                    int j = 0;
                    while (j < rootLength) {
                        if (roots[j].equals(root)) {
                            containsRoot = true;
                            break;
                        }
                        ++j;
                    }
                    if (containsRoot) {
                        IProjectFragment[] iProjectFragmentArray = roots;
                        roots = new IProjectFragment[rootLength + 1];
                        System.arraycopy(iProjectFragmentArray, 0, roots, 0, rootLength);
                        roots[rootLength] = root;
                        this.scriptFolders.put(pkgName, roots);
                    }
                }
                ++i;
            }
        }
        this.rootToResolvedEntries = rootToResolvedEntries;
        if (VERBOSE) {
            Util.verbose(" -> spent: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    protected boolean acceptType(IType type, int acceptFlags, boolean isSourceType) {
        return true;
    }

    private void findAllTypes(String prefix, boolean partialMatch, int acceptFlags, IModelElementRequestor requestor) {
        int count = this.projectFragments.length;
        int i = 0;
        while (i < count) {
            block7: {
                if (requestor.isCanceled()) {
                    return;
                }
                IProjectFragment root = this.projectFragments[i];
                IModelElement[] packages = null;
                try {
                    packages = root.getChildren();
                }
                catch (ModelException modelException) {
                    break block7;
                }
                if (packages != null) {
                    int j = 0;
                    int packageCount = packages.length;
                    while (j < packageCount) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        this.seekTypes(prefix, (IScriptFolder)packages[j], partialMatch, acceptFlags, requestor);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public ISourceModule findSourceModule(String qualifiedTypeName) {
        Object value;
        Object[] pkgName = CharOperation.NO_STRINGS;
        String cuName = qualifiedTypeName;
        int index = qualifiedTypeName.lastIndexOf(46);
        if (index != -1) {
            pkgName = Util.splitOn('.', qualifiedTypeName, 0, index);
            cuName = qualifiedTypeName.substring(index + 1);
        }
        if ((index = cuName.indexOf(36)) != -1) {
            cuName = cuName.substring(0, index);
        }
        if ((value = this.scriptFolders.get(pkgName)) != null) {
            if (value instanceof ProjectFragment) {
                return this.findSourceModule((String[])pkgName, cuName, (ProjectFragment)value);
            }
            IProjectFragment[] roots = (IProjectFragment[])value;
            int i = 0;
            while (i < roots.length) {
                ProjectFragment root = (ProjectFragment)roots[i];
                ISourceModule cu = this.findSourceModule((String[])pkgName, cuName, root);
                if (cu != null) {
                    return cu;
                }
                ++i;
            }
        }
        return null;
    }

    private IPath toPath(String[] pkgName) {
        Path path = new Path("");
        int i = 0;
        while (i < pkgName.length) {
            path = path.append(pkgName[i]);
            ++i;
        }
        return path;
    }

    private ISourceModule findSourceModule(String[] pkgName, String cuName, ProjectFragment root) {
        IScriptFolder pkg = root.getScriptFolder(this.toPath(pkgName));
        try {
            ISourceModule[] cus = pkg.getSourceModules();
            int j = 0;
            int length = cus.length;
            while (j < length) {
                ISourceModule cu = cus[j];
                if (Util.equalsIgnoreExtension(cu.getElementName(), cuName)) {
                    return cu;
                }
                ++j;
            }
        }
        catch (ModelException modelException) {}
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public IScriptFolder findScriptFolder(IPath path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(Messages.path_mustBeAbsolute);
        }
        IResource possibleFragment = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (possibleFragment == null) {
            int i = 0;
            while (i < this.projectFragments.length) {
                block22: {
                    IPath rootPath;
                    int matchingCount;
                    IProjectFragment root = this.projectFragments[i];
                    if (root.isExternal() && (matchingCount = (rootPath = root.getPath()).matchingFirstSegments(path)) != 0) {
                        String name = path.toOSString();
                        name = name.substring(rootPath.toOSString().length() + 1, name.length());
                        name = name.replace(File.separatorChar, '.');
                        IModelElement[] list = null;
                        try {
                            list = root.getChildren();
                        }
                        catch (ModelException modelException) {
                            break block22;
                        }
                        int elementCount = list.length;
                        int j = 0;
                        while (j < elementCount) {
                            IScriptFolder scriptFolder = (IScriptFolder)list[j];
                            if (this.nameMatches(name, scriptFolder, false)) {
                                return scriptFolder;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        } else {
            IModelElement fromFactory = DLTKCore.create(possibleFragment);
            if (fromFactory == null) {
                return null;
            }
            switch (fromFactory.getElementType()) {
                case 4: {
                    return (IScriptFolder)fromFactory;
                }
                case 2: {
                    ScriptProject project = (ScriptProject)fromFactory;
                    try {
                        IBuildpathEntry entry = project.getBuildpathEntryFor(path);
                        if (entry != null) {
                            IProjectFragment root = project.getProjectFragment(project.getResource());
                            Object defaultPkgRoot = this.scriptFolders.get(CharOperation.NO_STRINGS);
                            if (defaultPkgRoot == null) {
                                return null;
                            }
                            if (defaultPkgRoot instanceof ProjectFragment && defaultPkgRoot.equals(root)) {
                                return ((ProjectFragment)root).getScriptFolder((IPath)Path.EMPTY);
                            }
                            IProjectFragment[] roots = (IProjectFragment[])defaultPkgRoot;
                            int i = 0;
                            while (i < roots.length) {
                                if (roots[i].equals(root)) {
                                    return ((ProjectFragment)root).getScriptFolder((IPath)Path.EMPTY);
                                }
                                ++i;
                            }
                        }
                    }
                    catch (ModelException modelException) {
                        return null;
                    }
                    return null;
                }
                case 3: {
                    return ((ProjectFragment)fromFactory).getScriptFolder((IPath)Path.EMPTY);
                }
            }
        }
        return null;
    }

    public IScriptFolder[] findScriptFolders(String name, boolean partialMatch) {
        if (partialMatch) {
            String[] splittedName = Util.splitOn('.', name, 0, name.length());
            IScriptFolder[] oneFragment = null;
            ArrayList<IScriptFolder> pkgs = null;
            Object[][] keys = this.scriptFolders.keyTable;
            int i = 0;
            int length = keys.length;
            while (i < length) {
                String[] pkgName = (String[])keys[i];
                if (pkgName != null && Util.startsWithIgnoreCase(pkgName, splittedName)) {
                    Object value = this.scriptFolders.valueTable[i];
                    if (value instanceof ProjectFragment) {
                        IScriptFolder pkg = ((ProjectFragment)value).getScriptFolder(this.toPath(pkgName));
                        if (oneFragment == null) {
                            oneFragment = new IScriptFolder[]{pkg};
                        } else {
                            if (pkgs == null) {
                                pkgs = new ArrayList<IScriptFolder>();
                                pkgs.add(oneFragment[0]);
                            }
                            pkgs.add(pkg);
                        }
                    } else {
                        IProjectFragment[] roots = (IProjectFragment[])value;
                        int j = 0;
                        int length2 = roots.length;
                        while (j < length2) {
                            ProjectFragment root = (ProjectFragment)roots[j];
                            IScriptFolder pkg = root.getScriptFolder(this.toPath(pkgName));
                            if (oneFragment == null) {
                                oneFragment = new IScriptFolder[]{pkg};
                            } else {
                                if (pkgs == null) {
                                    pkgs = new ArrayList();
                                    pkgs.add(oneFragment[0]);
                                }
                                pkgs.add(pkg);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            if (pkgs == null) {
                return oneFragment;
            }
            int resultLength = pkgs.size();
            IScriptFolder[] result = new IScriptFolder[resultLength];
            pkgs.toArray(result);
            return result;
        }
        Object[] splittedName = Util.splitOn('.', name, 0, name.length());
        Object value = this.scriptFolders.get(splittedName);
        if (value == null) {
            return null;
        }
        if (value instanceof ProjectFragment) {
            return new IScriptFolder[]{((ProjectFragment)value).getScriptFolder(this.toPath((String[])splittedName))};
        }
        IProjectFragment[] roots = (IProjectFragment[])value;
        IScriptFolder[] result = new IScriptFolder[roots.length];
        int i = 0;
        while (i < roots.length) {
            result[i] = ((ProjectFragment)roots[i]).getScriptFolder(this.toPath((String[])splittedName));
            ++i;
        }
        return result;
    }

    public Answer findType(String typeName, String packageName, boolean partialMatch, int acceptFlags, boolean checkRestrictions) {
        return this.findType(typeName, packageName, partialMatch, acceptFlags, true, false, checkRestrictions, null);
    }

    public Answer findType(String typeName, String packageName, boolean partialMatch, int acceptFlags, boolean considerSecondaryTypes, boolean waitForIndexes, boolean checkRestrictions, IProgressMonitor monitor) {
        if (packageName == null || packageName.length() == 0) {
            packageName = "";
        } else if (typeName.length() > 0 && Character.isLowerCase(typeName.charAt(0)) && this.findScriptFolders(String.valueOf(packageName) + "." + typeName, false) != null) {
            return null;
        }
        ModelElementRequestor elementRequestor = new ModelElementRequestor();
        this.seekScriptFolders(packageName, false, elementRequestor);
        IScriptFolder[] packages = elementRequestor.getScriptFolders();
        IType type = null;
        int length = packages.length;
        HashSet<IScriptProject> projects = null;
        IScriptProject scriptProject = null;
        Answer suggestedAnswer = null;
        int i = 0;
        while (i < length) {
            type = this.findType(typeName, packages[i], partialMatch, acceptFlags);
            if (type != null) {
                Answer answer;
                AccessRestriction accessRestriction = null;
                if (checkRestrictions) {
                    accessRestriction = this.getViolatedRestriction(typeName, packageName, type, accessRestriction);
                }
                if (!(answer = new Answer(type, accessRestriction)).ignoreIfBetter()) {
                    if (answer.isBetter(suggestedAnswer)) {
                        return answer;
                    }
                } else if (answer.isBetter(suggestedAnswer)) {
                    suggestedAnswer = answer;
                }
            } else if (suggestedAnswer == null && considerSecondaryTypes) {
                if (scriptProject == null) {
                    scriptProject = packages[i].getScriptProject();
                } else if (projects == null) {
                    if (!scriptProject.equals(packages[i].getScriptProject())) {
                        projects = new HashSet<IScriptProject>(3);
                        projects.add(scriptProject);
                        projects.add(packages[i].getScriptProject());
                    }
                } else {
                    projects.add(packages[i].getScriptProject());
                }
            }
            ++i;
        }
        if (suggestedAnswer != null) {
            return suggestedAnswer;
        }
        return type == null ? null : new Answer(type, null);
    }

    private AccessRestriction getViolatedRestriction(String typeName, String packageName, IType type, AccessRestriction accessRestriction) {
        AccessRuleSet accessRuleSet;
        ProjectFragment root = (ProjectFragment)type.getAncestor(3);
        BuildpathEntry entry = (BuildpathEntry)this.rootToResolvedEntries.get(root);
        if (entry != null && (accessRuleSet = entry.getAccessRuleSet()) != null) {
            char[][] packageChars = CharOperation.splitOn('.', packageName.toCharArray());
            char[] typeChars = typeName.toCharArray();
            accessRestriction = accessRuleSet.getViolatedRestriction(CharOperation.concatWith(packageChars, typeChars, '/'));
        }
        return accessRestriction;
    }

    public IType findType(String name, IScriptFolder pkg, boolean partialMatch, int acceptFlags, boolean considerSecondaryTypes) {
        IType type = this.findType(name, pkg, partialMatch, acceptFlags);
        return type;
    }

    public IType findType(String name, IScriptFolder pkg, boolean partialMatch, int acceptFlags) {
        if (pkg == null) {
            return null;
        }
        SingleTypeRequestor typeRequestor = new SingleTypeRequestor();
        this.seekTypes(name, pkg, partialMatch, acceptFlags, typeRequestor);
        return typeRequestor.getType();
    }

    public IType findType(String name, boolean partialMatch, int acceptFlags) {
        Answer answer = this.findType(name, partialMatch, acceptFlags, false);
        return answer == null ? null : answer.type;
    }

    public Answer findType(String name, boolean partialMatch, int acceptFlags, boolean checkRestrictions) {
        return this.findType(name, partialMatch, acceptFlags, true, true, checkRestrictions, null);
    }

    public Answer findType(String name, boolean partialMatch, int acceptFlags, boolean considerSecondaryTypes, boolean waitForIndexes, boolean checkRestrictions, IProgressMonitor monitor) {
        int index = name.lastIndexOf(46);
        String className = null;
        String packageName = null;
        if (index == -1) {
            packageName = "";
            className = name;
        } else {
            packageName = name.substring(0, index);
            className = name.substring(index + 1);
        }
        return this.findType(className, packageName, partialMatch, acceptFlags, considerSecondaryTypes, waitForIndexes, checkRestrictions, monitor);
    }

    private IType getMemberType(IType type, String name, int dot) {
        while (dot != -1) {
            int start;
            String typeName = name.substring(start, (dot = name.indexOf(46, start = dot + 1)) == -1 ? name.length() : dot);
            type = type.getType(typeName);
        }
        return type;
    }

    public boolean isPackage(String[] pkgName) {
        return this.isPackageCache.get(pkgName) != null;
    }

    protected boolean nameMatches(String searchName, IModelElement element, boolean partialMatch) {
        if (partialMatch) {
            return element.getElementName().toLowerCase().startsWith(searchName);
        }
        return element.getElementName().equals(searchName);
    }

    protected boolean nameMatches(String searchName, ISourceModule cu, boolean partialMatch) {
        if (partialMatch) {
            return cu.getElementName().toLowerCase().startsWith(searchName);
        }
        return Util.equalsIgnoreExtension(cu.getElementName(), searchName);
    }

    public void seekScriptFolders(String name, boolean partialMatch, IModelElementRequestor requestor) {
        block10: {
            Object value;
            Object[] splittedName;
            block11: {
                block9: {
                    if (!partialMatch) break block9;
                    String[] splittedName2 = Util.splitOn('.', name, 0, name.length());
                    Object[][] keys = this.scriptFolders.keyTable;
                    int i = 0;
                    int length = keys.length;
                    while (i < length) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        String[] pkgName = (String[])keys[i];
                        if (pkgName != null && Util.startsWithIgnoreCase(pkgName, splittedName2)) {
                            Object value2 = this.scriptFolders.valueTable[i];
                            if (value2 instanceof ProjectFragment) {
                                ProjectFragment root = (ProjectFragment)value2;
                                requestor.acceptScriptFolder(root.getScriptFolder(this.toPath(pkgName)));
                            } else {
                                IProjectFragment[] roots = (IProjectFragment[])value2;
                                int j = 0;
                                int length2 = roots.length;
                                while (j < length2) {
                                    if (requestor.isCanceled()) {
                                        return;
                                    }
                                    ProjectFragment root = (ProjectFragment)roots[j];
                                    requestor.acceptScriptFolder(root.getScriptFolder(this.toPath(pkgName)));
                                    ++j;
                                }
                            }
                        }
                        ++i;
                    }
                    break block10;
                }
                splittedName = Util.splitOn('.', name, 0, name.length());
                value = this.scriptFolders.get(splittedName);
                if (!(value instanceof ProjectFragment)) break block11;
                requestor.acceptScriptFolder(((ProjectFragment)value).getScriptFolder(this.toPath((String[])splittedName)));
                break block10;
            }
            IProjectFragment[] roots = (IProjectFragment[])value;
            if (roots == null) break block10;
            int i = 0;
            int length = roots.length;
            while (i < length) {
                if (requestor.isCanceled()) {
                    return;
                }
                ProjectFragment root = (ProjectFragment)roots[i];
                requestor.acceptScriptFolder(root.getScriptFolder(this.toPath((String[])splittedName)));
                ++i;
            }
        }
    }

    public void seekTypes(String name, IScriptFolder pkg, boolean partialMatch, int acceptFlags, IModelElementRequestor requestor) {
        String matchName;
        String string = matchName = partialMatch ? name.toLowerCase() : name;
        if (pkg == null) {
            this.findAllTypes(matchName, partialMatch, acceptFlags, requestor);
            return;
        }
        IProjectFragment root = (IProjectFragment)pkg.getParent();
        try {
            int firstDot = -1;
            String topLevelTypeName = null;
            int packageFlavor = root.getKind();
            if (this.typesInWorkingCopies != null || packageFlavor == 1) {
                firstDot = matchName.indexOf(46);
                if (!partialMatch) {
                    String string2 = topLevelTypeName = firstDot == -1 ? matchName : matchName.substring(0, firstDot);
                }
            }
            if (this.typesInWorkingCopies != null && this.seekTypesInWorkingCopies(matchName, pkg, firstDot, partialMatch, topLevelTypeName, acceptFlags, requestor)) {
                return;
            }
            switch (packageFlavor) {
                case 1: {
                    this.seekTypesInSourcePackage(matchName, pkg, firstDot, partialMatch, topLevelTypeName, acceptFlags, requestor);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (ModelException modelException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void seekTypesInSourcePackage(String name, IScriptFolder pkg, int firstDot, boolean partialMatch, String topLevelTypeName, int acceptFlags, IModelElementRequestor requestor) {
        long start = -1L;
        if (VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            if (!partialMatch) {
                try {
                    IModelElement[] compilationUnits = pkg.getChildren();
                    int i = 0;
                    int length = compilationUnits.length;
                    if (i >= length) return;
                }
                catch (ModelException modelException) {
                    return;
                }
                {
                }
            }
            try {
                String cuPrefix = firstDot == -1 ? name : name.substring(0, firstDot);
                IModelElement[] compilationUnits = pkg.getChildren();
                int i = 0;
                int length = compilationUnits.length;
                if (i >= length) return;
            }
            catch (ModelException modelException) {
                return;
            }
            {
            }
        }
        finally {
            if (VERBOSE) {
                this.timeSpentInSeekTypesInSourcePackage += System.currentTimeMillis() - start;
            }
        }
    }

    protected boolean seekTypesInType(String prefix, int firstDot, IType type, IModelElementRequestor requestor, int acceptFlags) {
        IType[] types = null;
        try {
            types = type.getTypes();
        }
        catch (ModelException modelException) {
            return false;
        }
        int length = types.length;
        if (length == 0) {
            return false;
        }
        String memberPrefix = prefix;
        boolean isMemberTypePrefix = false;
        if (firstDot != -1) {
            memberPrefix = prefix.substring(0, firstDot);
            isMemberTypePrefix = true;
        }
        int i = 0;
        while (i < length) {
            if (requestor.isCanceled()) {
                return false;
            }
            IType memberType = types[i];
            if (memberType.getElementName().toLowerCase().startsWith(memberPrefix)) {
                if (isMemberTypePrefix) {
                    String subPrefix = prefix.substring(firstDot + 1, prefix.length());
                    return this.seekTypesInType(subPrefix, subPrefix.indexOf(46), memberType, requestor, acceptFlags);
                }
                if (this.acceptType(memberType, acceptFlags, true)) {
                    requestor.acceptMemberType(memberType);
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    protected boolean seekTypesInTopLevelType(String prefix, int firstDot, IType topLevelType, IModelElementRequestor requestor, int acceptFlags) {
        if (!topLevelType.getElementName().toLowerCase().startsWith(prefix)) {
            return false;
        }
        if (firstDot == -1) {
            if (this.acceptType(topLevelType, acceptFlags, true)) {
                requestor.acceptType(topLevelType);
                return true;
            }
        } else {
            return this.seekTypesInType(prefix, firstDot, topLevelType, requestor, acceptFlags);
        }
        return false;
    }

    protected boolean seekTypesInWorkingCopies(String name, IScriptFolder pkg, int firstDot, boolean partialMatch, String topLevelTypeName, int acceptFlags, IModelElementRequestor requestor) {
        block11: {
            block10: {
                Object object;
                block12: {
                    if (partialMatch) break block10;
                    HashMap typeMap = this.typesInWorkingCopies == null ? null : this.typesInWorkingCopies.get(pkg);
                    if (typeMap == null) break block11;
                    object = typeMap.get(topLevelTypeName);
                    if (!(object instanceof IType)) break block12;
                    IType type = this.getMemberType((IType)object, name, firstDot);
                    if (this.acceptType(type, acceptFlags, true)) {
                        requestor.acceptType(type);
                        return true;
                    }
                    break block11;
                }
                if (!(object instanceof IType[])) break block11;
                if (object == NO_TYPES) {
                    return true;
                }
                IType[] topLevelTypes = (IType[])object;
                int i = 0;
                int length = topLevelTypes.length;
                while (i < length) {
                    if (requestor.isCanceled()) {
                        return false;
                    }
                    IType type = this.getMemberType(topLevelTypes[i], name, firstDot);
                    if (this.acceptType(type, acceptFlags, true)) {
                        requestor.acceptType(type);
                        return true;
                    }
                    ++i;
                }
                break block11;
            }
            HashMap typeMap = this.typesInWorkingCopies == null ? null : this.typesInWorkingCopies.get(pkg);
            if (typeMap != null) {
                Iterator iterator = typeMap.values().iterator();
                while (iterator.hasNext()) {
                    if (requestor.isCanceled()) {
                        return false;
                    }
                    Object object = iterator.next();
                    if (object instanceof IType) {
                        this.seekTypesInTopLevelType(name, firstDot, (IType)object, requestor, acceptFlags);
                        continue;
                    }
                    if (!(object instanceof IType[])) continue;
                    IType[] topLevelTypes = (IType[])object;
                    int i = 0;
                    int length = topLevelTypes.length;
                    while (i < length) {
                        this.seekTypesInTopLevelType(name, firstDot, topLevelTypes[i], requestor, acceptFlags);
                        ++i;
                    }
                }
            }
        }
        return false;
    }

    public static class Answer {
        public IType type;
        AccessRestriction restriction;

        Answer(IType type, AccessRestriction restriction) {
            this.type = type;
            this.restriction = restriction;
        }

        public boolean ignoreIfBetter() {
            return this.restriction != null && this.restriction.ignoreIfBetter();
        }

        public boolean isBetter(Answer otherAnswer) {
            if (otherAnswer == null) {
                return true;
            }
            if (this.restriction == null) {
                return true;
            }
            return otherAnswer.restriction != null && this.restriction.getProblemId() < otherAnswer.restriction.getProblemId();
        }
    }
}

