/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.mixin;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelElementVisitor;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.search.indexing.IndexManager;
import org.eclipse.dltk.mod.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.mod.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.mixin.MixinBuiltinProjectFragmentRequest;
import org.eclipse.dltk.mod.internal.core.mixin.MixinExternalProjectFragmentRequest;
import org.eclipse.dltk.mod.internal.core.mixin.MixinIndexRequest;
import org.eclipse.dltk.mod.internal.core.mixin.MixinSourceModulesRequest;

class MixinProjectRequest
extends MixinIndexRequest {
    private final IScriptProject project;
    private final boolean indexExternal;

    public MixinProjectRequest(IScriptProject project, boolean indexExternal) {
        this.project = project;
        this.indexExternal = indexExternal;
    }

    @Override
    protected String getName() {
        return this.project.getElementName();
    }

    @Override
    protected void run() throws CoreException {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this.project);
        IProjectFragment[] fragments = this.project.getProjectFragments();
        IndexManager manager = ModelManager.getModelManager().getIndexManager();
        SourceModuleCollector moduleCollector = new SourceModuleCollector();
        int i = 0;
        while (i < fragments.length) {
            if (this.isCancelled) {
                return;
            }
            IProjectFragment fragment = fragments[i];
            if (fragment instanceof BuiltinProjectFragment) {
                if (this.indexExternal) {
                    manager.request(new MixinBuiltinProjectFragmentRequest(fragment, toolkit, ((BuiltinProjectFragment)fragment).lastModified()));
                }
            } else if (fragment instanceof ExternalProjectFragment) {
                if (this.indexExternal) {
                    manager.request(new MixinExternalProjectFragmentRequest(fragment, toolkit));
                }
            } else {
                fragment.accept(moduleCollector);
            }
            ++i;
        }
        manager.request(new MixinSourceModulesRequest(this.project, toolkit, moduleCollector.modules));
    }

    @Override
    public boolean belongsTo(String jobFamily) {
        return jobFamily.equals(this.project.getProject().getName());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MixinProjectRequest other = (MixinProjectRequest)obj;
        return !(this.project == null ? other.project != null : !this.project.equals(other.project));
    }

    static class SourceModuleCollector
    implements IModelElementVisitor {
        final Set modules = new HashSet();

        SourceModuleCollector() {
        }

        @Override
        public boolean visit(IModelElement element) {
            if (element.getElementType() == 5) {
                this.modules.add(element);
                return false;
            }
            return true;
        }
    }
}

