/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.launching.sourcelookup;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptStackFrame;
import org.eclipse.dltk.mod.internal.launching.LaunchConfigurationUtils;
import org.eclipse.dltk.mod.launching.sourcelookup.DBGPSourceModule;
import org.eclipse.dltk.mod.launching.sourcelookup.RemoteScriptSourceLookupParticipant;

public class RemoteScriptSourceLookupDirector
extends AbstractSourceLookupDirector {
    public void initializeParticipants() {
        this.addParticipants(new ISourceLookupParticipant[]{new RemoteScriptSourceLookupParticipant()});
    }

    public Object getSourceElement(Object element) {
        Object o = super.getSourceElement(element);
        if (o instanceof IFile) {
            return o;
        }
        ScriptStackFrame frame = (ScriptStackFrame)element;
        URI uri = frame.getFileName();
        String path = uri.getPath();
        IProject project = LaunchConfigurationUtils.getProject(this.getLaunchConfiguration());
        if (project == null) {
            return null;
        }
        ScriptProject scriptProject = new ScriptProject(project, null);
        return new DBGPSourceModule(scriptProject, path, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, frame);
    }
}

