/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.internal.corext.refactoring.reorg.ReorgUtils;

public class ParentChecker {
    private IResource[] fResources;
    private IModelElement[] fScriptElements;

    public ParentChecker(IResource[] resources, IModelElement[] modelElements) {
        Assert.isNotNull((Object)resources);
        Assert.isNotNull((Object)modelElements);
        this.fResources = resources;
        this.fScriptElements = modelElements;
    }

    public boolean haveCommonParent() {
        return this.getCommonParent() != null;
    }

    public Object getCommonParent() {
        if (this.fScriptElements.length == 0 && this.fResources.length == 0) {
            return null;
        }
        if (!this.resourcesHaveCommonParent() || !this.modelElementsHaveCommonParent()) {
            return null;
        }
        if (this.fScriptElements.length == 0) {
            IResource commonResourceParent = this.getCommonResourceParent();
            Assert.isNotNull((Object)commonResourceParent);
            IModelElement convertedToScript = DLTKCore.create((IResource)commonResourceParent);
            if (convertedToScript != null && convertedToScript.exists()) {
                return convertedToScript;
            }
            return commonResourceParent;
        }
        if (this.fResources.length == 0) {
            return this.getCommonScriptElementParent();
        }
        IResource commonResourceParent = this.getCommonResourceParent();
        IModelElement commonScriptElementParent = this.getCommonScriptElementParent();
        Assert.isNotNull((Object)commonScriptElementParent);
        Assert.isNotNull((Object)commonResourceParent);
        IModelElement convertedToScript = DLTKCore.create((IResource)commonResourceParent);
        if (convertedToScript == null || !convertedToScript.exists() || !commonScriptElementParent.equals(convertedToScript)) {
            return null;
        }
        return commonScriptElementParent;
    }

    private IModelElement getCommonScriptElementParent() {
        Assert.isNotNull((Object)this.fScriptElements);
        Assert.isTrue((this.fScriptElements.length > 0 ? 1 : 0) != 0);
        return this.fScriptElements[0].getParent();
    }

    private IResource getCommonResourceParent() {
        Assert.isNotNull((Object)this.fResources);
        Assert.isTrue((this.fResources.length > 0 ? 1 : 0) != 0);
        return this.fResources[0].getParent();
    }

    private boolean modelElementsHaveCommonParent() {
        if (this.fScriptElements.length == 0) {
            return true;
        }
        IModelElement firstParent = this.fScriptElements[0].getParent();
        Assert.isNotNull((Object)firstParent);
        int i = 1;
        while (i < this.fScriptElements.length) {
            if (!firstParent.equals(this.fScriptElements[i].getParent())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean resourcesHaveCommonParent() {
        if (this.fResources.length == 0) {
            return true;
        }
        IContainer firstParent = this.fResources[0].getParent();
        Assert.isNotNull((Object)firstParent);
        int i = 1;
        while (i < this.fResources.length) {
            if (!firstParent.equals((Object)this.fResources[i].getParent())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IResource[] getResources() {
        return this.fResources;
    }

    public IModelElement[] getScriptElements() {
        return this.fScriptElements;
    }

    public void removeElementsWithAncestorsOnList(boolean removeOnlyScriptElements) {
        if (!removeOnlyScriptElements) {
            this.removeResourcesDescendantsOfResources();
            this.removeResourcesDescendantsOfScriptElements();
        }
        this.removeScriptElementsDescendantsOfScriptElements();
    }

    private void removeResourcesDescendantsOfScriptElements() {
        ArrayList<IResource> subResources = new ArrayList<IResource>(3);
        int i = 0;
        while (i < this.fResources.length) {
            IResource subResource = this.fResources[i];
            int j = 0;
            while (j < this.fScriptElements.length) {
                IModelElement superElements = this.fScriptElements[j];
                if (ParentChecker.isDescendantOf(subResource, superElements)) {
                    subResources.add(subResource);
                }
                ++j;
            }
            ++i;
        }
        this.removeFromSetToDelete(subResources.toArray(new IResource[subResources.size()]));
    }

    private void removeScriptElementsDescendantsOfScriptElements() {
        ArrayList<IModelElement> subElements = new ArrayList<IModelElement>(3);
        int i = 0;
        while (i < this.fScriptElements.length) {
            IModelElement subElement = this.fScriptElements[i];
            int j = 0;
            while (j < this.fScriptElements.length) {
                IModelElement superElement = this.fScriptElements[j];
                if (ParentChecker.isDescendantOf(subElement, superElement)) {
                    subElements.add(subElement);
                }
                ++j;
            }
            ++i;
        }
        this.removeFromSetToDelete(subElements.toArray(new IModelElement[subElements.size()]));
    }

    private void removeResourcesDescendantsOfResources() {
        ArrayList<IResource> subResources = new ArrayList<IResource>(3);
        int i = 0;
        while (i < this.fResources.length) {
            IResource subResource = this.fResources[i];
            int j = 0;
            while (j < this.fResources.length) {
                IResource superResource = this.fResources[j];
                if (ParentChecker.isDescendantOf(subResource, superResource)) {
                    subResources.add(subResource);
                }
                ++j;
            }
            ++i;
        }
        this.removeFromSetToDelete(subResources.toArray(new IResource[subResources.size()]));
    }

    public static boolean isDescendantOf(IResource subResource, IModelElement superElement) {
        IContainer parent = subResource.getParent();
        while (parent != null) {
            IModelElement el = DLTKCore.create((IResource)parent);
            if (el != null && el.exists() && el.equals(superElement)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isDescendantOf(IModelElement subElement, IModelElement superElement) {
        if (subElement.equals(superElement)) {
            return false;
        }
        IModelElement parent = subElement.getParent();
        while (parent != null) {
            if (parent.equals(superElement)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isDescendantOf(IResource subResource, IResource superResource) {
        return !subResource.equals((Object)superResource) && superResource.getFullPath().isPrefixOf(subResource.getFullPath());
    }

    private void removeFromSetToDelete(IResource[] resourcesToNotDelete) {
        this.fResources = ReorgUtils.setMinus(this.fResources, resourcesToNotDelete);
    }

    private void removeFromSetToDelete(IModelElement[] elementsToNotDelete) {
        this.fScriptElements = ReorgUtils.setMinus(this.fScriptElements, elementsToNotDelete);
    }
}

