/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.preferences;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.mod.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.mod.internal.ui.dialogs.StatusUtil;
import org.eclipse.dltk.mod.ui.preferences.ControlBindingManager;
import org.eclipse.dltk.mod.ui.preferences.IFieldValidator;
import org.eclipse.dltk.mod.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.dltk.mod.ui.preferences.IPreferenceDelegate;
import org.eclipse.dltk.mod.ui.preferences.ITextConverter;
import org.eclipse.dltk.mod.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.mod.ui.util.IStatusChangeListener;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class ImprovedAbstractConfigurationBlock
implements IPreferenceConfigurationBlock,
IPreferenceDelegate {
    private PreferencePage page;
    private OverlayPreferenceStore store;
    private ControlBindingManager bindManager;

    public ImprovedAbstractConfigurationBlock(OverlayPreferenceStore store, PreferencePage page) {
        this.page = page;
        this.store = store;
        this.bindManager = new ControlBindingManager(this, this.getStatusListener());
        this.addOverlayKeys();
    }

    @Override
    public void initialize() {
        this.initializeFields();
    }

    @Override
    public void performOk() {
    }

    @Override
    public void performDefaults() {
        this.initializeFields();
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean getBoolean(Object key) {
        return this.store.getBoolean((String)key);
    }

    @Override
    public String getString(Object key) {
        return this.store.getString((String)key);
    }

    @Override
    public void setBoolean(Object key, boolean value) {
        this.store.setValue((String)key, value);
    }

    @Override
    public void setString(Object key, String value) {
        this.store.setValue((String)key, value);
    }

    protected abstract List createOverlayKeys();

    protected void bindControl(Button button, String key, Control[] dependencies) {
        this.bindManager.bindControl(button, (Object)key, dependencies);
    }

    protected void bindControl(Button button, String key) {
        this.bindControl(button, key, null);
    }

    protected void bindControl(Text text, String key, IFieldValidator validator) {
        this.bindManager.bindControl(text, (Object)key, validator);
    }

    protected void bindControl(Text text, String key, IFieldValidator validator, ITextConverter transformer) {
        this.bindManager.bindControl(text, key, validator, transformer);
    }

    protected void bindControl(Text text, String key) {
        this.bindControl(text, key, null);
    }

    protected void bindControl(Text text, IFieldValidator validator) {
        this.bindManager.bindControl(text, null, validator);
    }

    protected void bindControl(Combo combo, String key) {
        this.bindManager.bindControl(combo, key);
    }

    protected void initializeFields() {
        this.bindManager.initialize();
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.store;
    }

    private IStatusChangeListener getStatusListener() {
        return new IStatusChangeListener(){

            @Override
            public void statusChanged(IStatus status) {
                if (status == null) {
                    status = new StatusInfo();
                }
                ImprovedAbstractConfigurationBlock.this.page.setValid(status.getSeverity() != 4);
                StatusUtil.applyToStatusLine((DialogPage)ImprovedAbstractConfigurationBlock.this.page, status);
            }
        };
    }

    private void addOverlayKeys() {
        List overlayKeys = this.createOverlayKeys();
        if (overlayKeys != null) {
            OverlayPreferenceStore.OverlayKey[] keys = overlayKeys.toArray(new OverlayPreferenceStore.OverlayKey[overlayKeys.size()]);
            this.store.addKeys(keys);
        }
    }
}

