/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.text.completion;

import java.util.Comparator;
import org.eclipse.dltk.mod.ui.text.completion.AbstractScriptCompletionProposal;
import org.eclipse.dltk.mod.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.TemplateProposal;

public final class CompletionProposalComparator
implements Comparator {
    private boolean fOrderAlphabetically = false;

    public void setOrderAlphabetically(boolean orderAlphabetically) {
        this.fOrderAlphabetically = orderAlphabetically;
    }

    public int compare(Object o1, Object o2) {
        ICompletionProposal p1 = (ICompletionProposal)o1;
        ICompletionProposal p2 = (ICompletionProposal)o2;
        if (!this.fOrderAlphabetically) {
            int r1 = this.getRelevance(p1);
            int r2 = this.getRelevance(p2);
            int relevanceDif = r2 - r1;
            if (relevanceDif != 0) {
                return relevanceDif;
            }
        }
        return this.getSortKey(p1).compareToIgnoreCase(this.getSortKey(p2));
    }

    private String getSortKey(ICompletionProposal p) {
        String sortString;
        if (p instanceof AbstractScriptCompletionProposal && (sortString = ((AbstractScriptCompletionProposal)p).getSortString()) != null) {
            return sortString;
        }
        return p.getDisplayString();
    }

    private int getRelevance(ICompletionProposal obj) {
        if (obj instanceof IScriptCompletionProposal) {
            IScriptCompletionProposal jcp = (IScriptCompletionProposal)obj;
            return jcp.getRelevance();
        }
        if (obj instanceof TemplateProposal) {
            TemplateProposal tp = (TemplateProposal)obj;
            return tp.getRelevance();
        }
        return 0;
    }
}

