/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.IVjoSemanticRule;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticRulePolicy;

public class VjoGroupRulesCache {
    private static VjoGroupRulesCache CACHE = new VjoGroupRulesCache();
    private Map<String, Map<String, VjoSemanticRulePolicy>> m_groupPolicyMap = new HashMap<String, Map<String, VjoSemanticRulePolicy>>();
    private VjoSemanticRulePolicy m_globalErrorPolicy = VjoSemanticRulePolicy.GLOBAL_ERROR_POLICY;

    private VjoGroupRulesCache() {
    }

    public static VjoGroupRulesCache getInstance() {
        return CACHE;
    }

    public VjoSemanticRulePolicy getRulePolicy(String projectName, IVjoSemanticRule<?> rule) {
        if (projectName == null) {
            return rule.getGlobalRulePolicy();
        }
        VjoSemanticRulePolicy groupRulePolicy = rule.getGroupRulePolicy(projectName);
        return groupRulePolicy;
    }

    private VjoSemanticRulePolicy getRulePolicyFromRuleMap(String projectName, IVjoSemanticRule<?> rule) {
        Map<String, VjoSemanticRulePolicy> ruleMap = this.m_groupPolicyMap.get(projectName);
        if (ruleMap == null) {
            return this.m_globalErrorPolicy;
        }
        VjoSemanticRulePolicy resultPolicy = null;
        String ruleName = rule.getRuleName();
        if (ruleMap.containsKey(ruleName) && (resultPolicy = ruleMap.get(ruleName)) != null) {
            return resultPolicy;
        }
        return rule.getGlobalRulePolicy();
    }

    public boolean hasGroupPolicy(String projectName) {
        if (this.m_groupPolicyMap == null) {
            return false;
        }
        return this.m_groupPolicyMap.containsKey(projectName);
    }

    public void addGroupPolicy(String groupId, IVjoSemanticRule<?> rule, VjoSemanticRulePolicy policy) {
        if (this.m_groupPolicyMap == null) {
            this.m_groupPolicyMap = new HashMap<String, Map<String, VjoSemanticRulePolicy>>();
        }
        Map<String, VjoSemanticRulePolicy> rulePolicyMap = null;
        rulePolicyMap = this.m_groupPolicyMap.containsKey(groupId) ? this.m_groupPolicyMap.get(groupId) : new HashMap<String, VjoSemanticRulePolicy>();
        rulePolicyMap.put(rule.getRuleName(), policy);
        this.m_groupPolicyMap.put(groupId, rulePolicyMap);
    }

    public void clearAllGroupCache() {
        this.m_groupPolicyMap.clear();
    }

    public void clearGroupCache(String projectName) {
        Map<String, VjoSemanticRulePolicy> ruleMap = this.m_groupPolicyMap.get(projectName);
        if (ruleMap != null) {
            ruleMap.clear();
        }
    }
}

