/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor;

import java.util.Iterator;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationRuntimeException;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.validator.VjoSemanticValidatorRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.util.VjoValidationVisitorCtxUpdateUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.VjoValidationVisitorEvent;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.VjoValidationVisitorState;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstAnnotation;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ISynthesized;
import org.eclipse.vjet.dsf.jst.declaration.DefaultAnnotations;
import org.eclipse.vjet.dsf.jst.declaration.JstAnnotation;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstDoc;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstGlobalFunc;
import org.eclipse.vjet.dsf.jst.declaration.JstGlobalProp;
import org.eclipse.vjet.dsf.jst.declaration.JstGlobalVar;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstName;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstRawBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.declaration.JstVjoProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstWildcardType;
import org.eclipse.vjet.dsf.jst.expr.ArrayAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.ArrayCreationExpr;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.BoolExpr;
import org.eclipse.vjet.dsf.jst.expr.CastExpr;
import org.eclipse.vjet.dsf.jst.expr.ConditionalExpr;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.FuncExpr;
import org.eclipse.vjet.dsf.jst.expr.InfixExpr;
import org.eclipse.vjet.dsf.jst.expr.JstArrayInitializer;
import org.eclipse.vjet.dsf.jst.expr.JstInitializer;
import org.eclipse.vjet.dsf.jst.expr.ListExpr;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.expr.ParenthesizedExpr;
import org.eclipse.vjet.dsf.jst.expr.PostfixExpr;
import org.eclipse.vjet.dsf.jst.expr.PrefixExpr;
import org.eclipse.vjet.dsf.jst.expr.PtyGetter;
import org.eclipse.vjet.dsf.jst.expr.TextExpr;
import org.eclipse.vjet.dsf.jst.meta.BaseJsCommentMetaNode;
import org.eclipse.vjet.dsf.jst.stmt.BlockStmt;
import org.eclipse.vjet.dsf.jst.stmt.BreakStmt;
import org.eclipse.vjet.dsf.jst.stmt.CatchStmt;
import org.eclipse.vjet.dsf.jst.stmt.ContinueStmt;
import org.eclipse.vjet.dsf.jst.stmt.DispatchStmt;
import org.eclipse.vjet.dsf.jst.stmt.DoStmt;
import org.eclipse.vjet.dsf.jst.stmt.ExprStmt;
import org.eclipse.vjet.dsf.jst.stmt.ForInStmt;
import org.eclipse.vjet.dsf.jst.stmt.ForStmt;
import org.eclipse.vjet.dsf.jst.stmt.IfStmt;
import org.eclipse.vjet.dsf.jst.stmt.JstBlockInitializer;
import org.eclipse.vjet.dsf.jst.stmt.JstStmt;
import org.eclipse.vjet.dsf.jst.stmt.LabeledStmt;
import org.eclipse.vjet.dsf.jst.stmt.PtySetter;
import org.eclipse.vjet.dsf.jst.stmt.RtnStmt;
import org.eclipse.vjet.dsf.jst.stmt.SwitchStmt;
import org.eclipse.vjet.dsf.jst.stmt.TextStmt;
import org.eclipse.vjet.dsf.jst.stmt.ThisStmt;
import org.eclipse.vjet.dsf.jst.stmt.ThrowStmt;
import org.eclipse.vjet.dsf.jst.stmt.TryStmt;
import org.eclipse.vjet.dsf.jst.stmt.TypeDeclStmt;
import org.eclipse.vjet.dsf.jst.stmt.WhileStmt;
import org.eclipse.vjet.dsf.jst.stmt.WithStmt;
import org.eclipse.vjet.dsf.jst.term.ArrayLiteral;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.JstLiteral;
import org.eclipse.vjet.dsf.jst.term.JstProxyIdentifier;
import org.eclipse.vjet.dsf.jst.term.NV;
import org.eclipse.vjet.dsf.jst.term.ObjLiteral;
import org.eclipse.vjet.dsf.jst.term.RegexpLiteral;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;
import org.eclipse.vjet.dsf.logger.Logger;

public class VjoValidationVisitor
implements IJstNodeVisitor {
    private static final String SUPRESSTYPECHECK = "SUPRESSTYPECHECK";
    private static final String SUPPRESSTYPECHECK = "SUPPRESSTYPECHECK";
    private VjoValidationCtx m_ctx = new VjoValidationCtx();
    private static Logger s_logger = null;

    private Logger getLogger() {
        if (s_logger == null) {
            s_logger = Logger.getInstance(VjoValidationVisitor.class);
        }
        return s_logger;
    }

    public VjoValidationCtx getCtx() {
        if (this.m_ctx == null) {
            this.m_ctx = new VjoValidationCtx();
        }
        return this.m_ctx;
    }

    public VjoValidationVisitor setCtx(VjoValidationCtx ctx) {
        this.m_ctx = ctx;
        return this;
    }

    private void visitAndValidate(IJstNode jstNode) {
        if (jstNode instanceof ISynthesized || this.getCtx().getVisitedJstNodes().contains(jstNode)) {
            return;
        }
        this.getCtx().getVisitedJstNodes().add(jstNode);
        if (jstNode instanceof JstIdentifier) {
            IExpr node;
            List values;
            JstIdentifier identifier = (JstIdentifier)jstNode;
            IJstNode binding = identifier.getJstBinding();
            IJstType type = identifier.getType();
            IJstAnnotation impliedUsage = identifier.getAnnotation("@ImpliedUsageOfType");
            if (type == null && impliedUsage != null && (values = impliedUsage.values()).size() > 0 && (node = (IExpr)values.get(0)) instanceof SimpleLiteral) {
                SimpleLiteral impliedtypelit = (SimpleLiteral)node;
                JstType impliedtype = JstCache.getInstance().getType(impliedtypelit.toExprText().replace('\"', ' ').trim());
                if (impliedtype != null) {
                    JstTypeRefType typeref = new JstTypeRefType((IJstType)impliedtype);
                    this.getCtx().addMustActivelyNeededTypes(jstNode.getRootType(), (IJstRefType)typeref);
                    this.getCtx().addKnownActivelyNeededTypes(jstNode.getRootType(), (IJstRefType)typeref);
                }
            }
            if (type != null && binding instanceof JstMethod) {
                JstMethod factoryFunc = (JstMethod)binding;
                if (factoryFunc.isFuncArgMetaExtensionEnabled() && factoryFunc.getAnnotation(DefaultAnnotations.CONSTRUCTOR.getName().getName()) != null) {
                    Object typeref = null;
                    typeref = !(type instanceof IJstRefType) ? new JstTypeRefType(type) : (IJstRefType)type;
                    typeref = new JstTypeRefType(type);
                    this.getCtx().addMustActivelyNeededTypes(jstNode.getRootType(), (IJstRefType)typeref);
                    this.getCtx().addKnownActivelyNeededTypes(jstNode.getRootType(), (IJstRefType)typeref);
                }
            } else if (type != null && type instanceof IJstRefType) {
                if (binding == type) {
                    this.getCtx().addMustActivelyNeededTypes(jstNode.getRootType(), (IJstRefType)type);
                    this.getCtx().addKnownActivelyNeededTypes(jstNode.getRootType(), (IJstRefType)type);
                } else {
                    JstIdentifier vj;
                    IExpr qualifier;
                    BaseJstNode parent = identifier.getParentNode();
                    if (parent != null && parent instanceof FieldAccessExpr && (qualifier = ((FieldAccessExpr)parent).getExpr()) != null && qualifier instanceof FieldAccessExpr && (vj = ((FieldAccessExpr)qualifier).getName()) != null && vj instanceof JstIdentifier && vj.getJstBinding() != null && vj.getJstBinding() instanceof JstVjoProperty) {
                        this.getCtx().addKnownActivelyNeededTypes(jstNode.getRootType(), (IJstRefType)type);
                    }
                }
            }
        }
        this.visitAndValidate(jstNode, false, false);
    }

    private void visitAndValidate(IJstNode jstNode, boolean reverse, boolean skipChildren) {
        try {
            this.getCtx().setJstNode(jstNode);
            VjoSemanticValidatorRepo dispatcher = VjoSemanticValidatorRepo.getInstance();
            dispatcher.dispatch(this.genEvent(jstNode, null, VjoValidationVisitorState.BEFORE_ALL_CHILDREN));
            if (!reverse) {
                int i = 0;
                int size = jstNode.getChildren().size();
                while (i < size) {
                    IJstNode child = (IJstNode)jstNode.getChildren().get(i);
                    dispatcher.dispatch(this.genEvent(jstNode, child, VjoValidationVisitorState.BEFORE_CHILD));
                    this.visitChild(child);
                    dispatcher.dispatch(this.genEvent(jstNode, child, VjoValidationVisitorState.AFTER_CHILD));
                    ++i;
                }
            } else {
                int i = jstNode.getChildren().size() - 1;
                while (i >= 0) {
                    IJstNode child = (IJstNode)jstNode.getChildren().get(i);
                    dispatcher.dispatch(this.genEvent(jstNode, child, VjoValidationVisitorState.BEFORE_CHILD));
                    this.visitChild(child);
                    dispatcher.dispatch(this.genEvent(jstNode, child, VjoValidationVisitorState.AFTER_CHILD));
                    --i;
                }
            }
            dispatcher.dispatch(this.genEvent(jstNode, null, VjoValidationVisitorState.AFTER_ALL_CHILDREN));
            if (this.shouldSuppressTypeCheck(jstNode)) {
                this.getCtx().removeProblems(jstNode, true);
            }
        }
        catch (VjoValidationRuntimeException th) {
            throw th;
        }
        catch (Throwable th) {
            th.printStackTrace();
            this.getLogger().log(th);
        }
    }

    private boolean shouldSuppressTypeCheck(IJstNode jstNode) {
        return jstNode.getAnnotation(SUPPRESSTYPECHECK) != null || jstNode.getAnnotation(SUPRESSTYPECHECK) != null;
    }

    private void visitChild(IJstNode child) {
        child.accept((IJstNodeVisitor)this);
    }

    public void visit(BaseJstNode node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstAnnotation node) {
    }

    public void visit(JstArg node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstArrayInitializer node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstBlock node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstBlockInitializer node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstRawBlock node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstDoc node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstIdentifier node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstInitializer node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstLiteral node) {
    }

    public void visit(ArrayLiteral node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(ObjLiteral node) {
        VjoValidationCtx ctx = this.getCtx();
        VjoValidationVisitorCtxUpdateUtil.updateCtxBeforeObjLiteral(ctx, node);
        this.visitAndValidate((IJstNode)node);
        VjoValidationVisitorCtxUpdateUtil.updateCtxAfterObjLiteral(ctx, node);
    }

    public void visit(JstMethod node) {
        VjoValidationCtx ctx = this.getCtx();
        VjoValidationVisitorCtxUpdateUtil.updateCtxBeforeMethod(ctx, node);
        this.visitAndValidate((IJstNode)node);
        VjoValidationVisitorCtxUpdateUtil.updateCtxAfterMethod(ctx, node);
    }

    public void visit(RegexpLiteral node) {
    }

    public void visit(SimpleLiteral node) {
    }

    public void visit(JstConstructor node) {
        IJstType jstType;
        if (node.getParentNode() instanceof IJstType && (jstType = (IJstType)node.getParentNode()).getConstructor() != node) {
            return;
        }
        VjoValidationCtx ctx = this.getCtx();
        VjoValidationVisitorCtxUpdateUtil.updateCtxBeforeMethod(ctx, (JstMethod)node);
        this.visitAndValidate((IJstNode)node);
        VjoValidationVisitorCtxUpdateUtil.updateCtxAfterMethod(ctx, (JstMethod)node);
    }

    public void visit(JstModifiers node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstName node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstPackage node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstProperty node) {
        VjoValidationCtx ctx = this.getCtx();
        VjoValidationVisitorCtxUpdateUtil.updateCtxBeforeProperty(ctx, node);
        this.visitAndValidate((IJstNode)node);
        VjoValidationVisitorCtxUpdateUtil.updateCtxAfterProperty(ctx, node);
    }

    public void visit(JstType node) {
        boolean runtimeException = false;
        VjoValidationCtx ctx = this.getCtx();
        try {
            VjoValidationVisitorCtxUpdateUtil.updateCtxBeforeType(ctx, (IJstType)node);
        }
        catch (VjoValidationRuntimeException vjoValidationRuntimeException) {
            runtimeException = true;
        }
        if (!runtimeException) {
            this.visitAndValidate((IJstNode)node);
            List innerTypes = node.getEmbededTypes();
            if (innerTypes != null && innerTypes.size() > 0) {
                Iterator it = innerTypes.iterator();
                while (it.hasNext()) {
                    this.visit((JstType)it.next());
                }
            }
        } else {
            this.visitAndValidate((IJstNode)node, false, true);
        }
        try {
            VjoValidationVisitorCtxUpdateUtil.updateCtxAfterType(ctx, (IJstType)node);
        }
        catch (VjoValidationRuntimeException vjoValidationRuntimeException) {
            runtimeException = true;
        }
    }

    public void visit(JstArray node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstFunctionRefType node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstObjectLiteralType node) {
        this.getCtx().getScope().addTypeNode((IJstType)node);
        this.visitAndValidate((IJstNode)node);
        this.getCtx().getScope().removeTypeNode((IJstType)node);
    }

    public void visit(JstRefType node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(IJstRefType node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstTypeReference node) {
    }

    public void visit(JstVar node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstVars node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(NV node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(BoolExpr node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(InfixExpr node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(ParenthesizedExpr node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(PostfixExpr node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(PrefixExpr node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(ArrayAccessExpr node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(ArrayCreationExpr node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(AssignExpr node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(CastExpr node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(ConditionalExpr node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(FieldAccessExpr node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(FuncExpr node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(ObjCreationExpr node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(MtdInvocationExpr node) {
        this.visitAndValidate((IJstNode)node, true, false);
    }

    public void visit(ExprStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(SwitchStmt.CaseStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(BlockStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(CatchStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(ForInStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(ForStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(IfStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(DispatchStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(SwitchStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(TryStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(WhileStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(DoStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(WithStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(BreakStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(ContinueStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(LabeledStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(RtnStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(TypeDeclStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(ListExpr node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(ThisStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(TextExpr node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(TextStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(ThrowStmt node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(PtyGetter node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(PtySetter node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstProxyMethod node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstProxyProperty node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstParamType node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstWildcardType node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstTypeWithArgs node) {
        this.visitAndValidate((IJstNode)node);
    }

    private VjoValidationVisitorEvent genEvent(IJstNode node, IJstNode child, VjoValidationVisitorState state) {
        return new VjoValidationVisitorEvent(this.getCtx(), node, child, state);
    }

    public void visit(JstGlobalVar node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstGlobalFunc node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstGlobalProp node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(JstProxyIdentifier node) {
        this.visitAndValidate((IJstNode)node);
    }

    public void visit(BaseJsCommentMetaNode<?> node) {
        this.visitAndValidate((IJstNode)node);
    }
}

