/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.vjo;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.BaseGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.GeneratorCtx;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstRawBlock;
import org.eclipse.vjet.dsf.jst.reserved.JsCoreKeywords;
import org.eclipse.vjet.dsf.jst.token.IStmt;

public class MtdGenerator
extends BaseGenerator {
    public MtdGenerator(GeneratorCtx ctx) {
        super(ctx);
    }

    public void writeMtd(IJstMethod mtd) {
        PrintWriter writer = this.getWriter();
        this.writeNewline();
        this.writeIndent();
        String mtdName = mtd.getName().getName();
        if (mtdName != null) {
            writer.append(mtdName).append(":");
        }
        if (mtd.getOwnerType() != null && mtd.getOwnerType().isMetaType() || mtd.getAnnotation("metaMethod") != null) {
            writer.append("vjo.NEEDS_IMPL");
            return;
        }
        writer.append(JsCoreKeywords.FUNCTION);
        List args = mtd.getArgs();
        if (args.size() > 0) {
            JstArg varArg = null;
            int fixArgCount = args.size();
            writer.append("(");
            int i = 0;
            while (i < args.size()) {
                if (((JstArg)args.get(i)).isVariable()) {
                    varArg = (JstArg)args.get(i);
                    fixArgCount = i;
                    break;
                }
                if (i > 0) {
                    writer.append(",");
                }
                writer.append(((JstArg)args.get(i)).getName());
                ++i;
            }
            writer.append("){");
            if (varArg != null) {
                this.writeVarArgs(fixArgCount, varArg);
            }
        } else {
            writer.append("(){");
        }
        this.indent();
        this.writeBlock(mtd.getBlock());
    }

    private void writeVarArgs(int fixArgCount, JstArg varArg) {
        String fixArgs = String.valueOf(fixArgCount);
        String argName = varArg.getName();
        PrintWriter writer = this.getWriter();
        this.indent();
        this.writeNewline();
        this.writeIndent();
        writer.append("var ").append(argName).append(";");
        this.writeNewline();
        this.writeIndent();
        writer.append("if (arguments.length == ").append(String.valueOf(fixArgCount + 1)).append(" && arguments[").append(fixArgs).append("]  instanceof Array){");
        this.indent();
        this.writeNewline();
        this.writeIndent();
        writer.append(argName).append("=arguments[").append(fixArgs).append("];");
        this.outdent();
        this.writeNewline();
        this.writeIndent();
        writer.append("}");
        this.writeNewline();
        this.writeIndent();
        writer.append("else {");
        this.indent();
        this.writeNewline();
        this.writeIndent();
        writer.append(argName).append("=[];");
        this.writeNewline();
        this.writeIndent();
        writer.append("for (var i=").append(fixArgs).append("; i<arguments.length; i++){");
        this.indent();
        this.writeNewline();
        this.writeIndent();
        writer.append(argName).append("[i-").append(fixArgs).append("]=arguments[i];");
        this.outdent();
        this.writeNewline();
        this.writeIndent();
        writer.append("}");
        this.outdent();
        this.writeNewline();
        this.writeIndent();
        writer.append("}");
        this.outdent();
    }

    private void writeBlock(JstBlock block) {
        if (block == null) {
            return;
        }
        if (block.getStmts().isEmpty()) {
            if (block instanceof JstRawBlock) {
                int cols = 0;
                String offset = "";
                if (block.getParentNode() instanceof JstMethod) {
                    JstMethod meth = (JstMethod)block.getParentNode();
                    cols = meth.getSource().getColumn();
                }
                int i = 0;
                while (i < cols) {
                    offset = String.valueOf(offset) + " ";
                    ++i;
                }
                String blockTxt = block.toBlockText();
                LineNumberReader reader = new LineNumberReader(new StringReader(blockTxt));
                try {
                    String line = reader.readLine();
                    if (line != null) {
                        this.getWriter().append("   " + line);
                    }
                    while ((line = reader.readLine()) != null) {
                        this.getWriter().append("\n   " + line);
                    }
                }
                catch (IOException iOException) {}
            }
            return;
        }
        for (IStmt s : block.getStmts()) {
            this.getStmtGenerator().writeStmt(s);
        }
    }
}

