/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.vjo;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.util.GeneratorJstHelper;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.BaseGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.GeneratorCtx;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.GeneratorHelper;
import org.eclipse.vjet.dsf.jsnative.global.Object;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstOType;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.ISynthesized;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.term.ArrayLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;
import org.eclipse.vjet.dsf.jst.util.JstCommentHelper;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;
import org.eclipse.vjet.vjo.meta.VjoConvention;

public class VjoGenerator
extends BaseGenerator {
    public static final String END_TYPE_CLOSURE = ".endType()";
    private IJstType m_currentType;

    public VjoGenerator(GeneratorCtx ctx) {
        super(ctx);
    }

    public VjoGenerator writeVjo(IJstType type) {
        IJstType jstType;
        if (this.getCtx().getConfig().shouldAddCodeGenAnnotation() && !type.isEmbededType() && !type.isLocalType() && !type.isAnonymous()) {
            this.writeCodeGenCmt();
        }
        if ((jstType = VjoGenerator.getJstType(type)) != null) {
            this.writeType(jstType);
        }
        return this;
    }

    public VjoGenerator writeType(IJstType type) {
        this.m_currentType = type;
        this.writeType(type.getName());
        if (type.isOType()) {
            this.writeOTypeDef();
        } else {
            List initStmts;
            List expects;
            List mixins;
            List impls;
            List needs = type.getImports();
            this.writeNeeds(needs, type);
            this.writeInactiveNeeds(type);
            List inherits = type.getExtends();
            if (inherits.size() > 0) {
                for (IJstType t : inherits) {
                    if (this.isDefaultExtend(t) || GeneratorHelper.isSkipInherits(t)) continue;
                    this.writeInherits(t);
                }
            }
            if ((impls = type.getSatisfies()) != null && !impls.isEmpty()) {
                for (IJstType t : impls) {
                    if (GeneratorHelper.isSkipSatisfies(t)) continue;
                    this.writeSatisfies(t);
                }
            }
            if ((mixins = type.getMixins()) != null && !mixins.isEmpty()) {
                for (IJstType t : mixins) {
                    this.writeMixin(t);
                }
            }
            if ((expects = type.getExpects()) != null && !expects.isEmpty()) {
                for (IJstType t : expects) {
                    this.writeExpects(t);
                }
            }
            List<IJstProperty> nvs = JstTypeHelper.getDeclaredProperties((List)type.getStaticProperties());
            nvs = this.getNonProxyProperties(nvs);
            List<? extends IJstMethod> mtds = JstTypeHelper.getDeclaredMethods((List)type.getStaticMethods());
            mtds = this.getNonProxyMethods(mtds);
            List embeds = type.isInterface() ? type.getEmbededTypes() : type.getStaticEmbededTypes();
            if (nvs.size() + mtds.size() + embeds.size() > 0) {
                this.startWriteProps();
                this.writePtys(nvs, mtds.size() + embeds.size() > 0);
                this.writeEmbeds(embeds, mtds.size() > 0);
                this.writeMtds(mtds);
                this.endWriteProps();
            }
            nvs = JstTypeHelper.getDeclaredProperties((List)type.getInstanceProperties());
            nvs = this.getNonProxyProperties(nvs);
            IJstMethod constructor = type.getConstructor();
            if (constructor instanceof ISynthesized) {
                constructor = null;
            }
            mtds = JstTypeHelper.getDeclaredMethods((List)type.getInstanceMethods());
            mtds = this.getNonProxyMethods(mtds);
            embeds = type.isInterface() ? Collections.emptyList() : type.getInstanceEmbededTypes();
            List instanceInits = type.getInstanceInitializers();
            if (constructor != null || nvs.size() + mtds.size() + embeds.size() + instanceInits.size() > 0) {
                this.startWriteProtos();
                boolean hasConstructor = constructor != null || !instanceInits.isEmpty();
                this.writePtys(nvs, hasConstructor || mtds.size() + embeds.size() > 0);
                this.writeEmbeds(embeds, hasConstructor || mtds.size() > 0);
                if (hasConstructor) {
                    this.writeConstructor(constructor, instanceInits, mtds.size() > 0);
                }
                this.writeMtds(mtds);
                this.endWriteProtos();
            }
            if (type.isEnum()) {
                this.writeEnumValues(type);
            }
            if ((initStmts = type.getStaticInitializers()).size() > 0) {
                this.startWriteInits();
                for (IStmt stmt : initStmts) {
                    this.getStmtGenerator().writeStmt(stmt);
                }
                this.endWriteInits();
            }
        }
        if (type.isMetaType() && !type.isOType()) {
            this.writeNewline();
            this.getWriter().append(".options({");
            this.indent();
            this.writeNewline();
            this.writeIndent();
            this.getWriter().append("metatype:true");
            this.outdent();
            this.writeNewline();
            this.getWriter().append("})");
        }
        if (type.isSingleton()) {
            this.writeNewline();
            this.getWriter().append(".options({");
            this.indent();
            this.writeNewline();
            this.writeIndent();
            this.getWriter().append("singleton:true");
            this.outdent();
            this.writeNewline();
            this.getWriter().append("})");
        }
        if (type.getAliasTypeName() != null) {
            this.writeNewline();
            this.getWriter().append(".options({");
            this.indent();
            this.writeNewline();
            this.writeIndent();
            this.getWriter().append("alias:" + type.getAliasTypeName());
            this.outdent();
            this.writeNewline();
            this.getWriter().append("})");
        }
        this.writeTypeClosure();
        if (type.getName() != null && !type.isEmbededType()) {
            this.getWriter().append(";");
        }
        if (!type.isOType()) {
            for (IJstType t : type.getSiblingTypes()) {
                this.writeNewline();
                this.writeType(t);
            }
        }
        return this;
    }

    private void writeOTypeDef() {
        if (!this.getCurrentType().isOType()) {
            return;
        }
        this.startWriteOTypeDef();
        List list = this.getCurrentType().getOTypes();
        this.writeIndent();
        int i = 0;
        while (i < list.size()) {
            IJstOType o = (IJstOType)list.get(i);
            if (o instanceof JstObjectLiteralType) {
                this.writeOType((JstObjectLiteralType)o);
            } else if (o instanceof JstFunctionRefType) {
                this.writeOType((JstFunctionRefType)o);
            }
            if (i != list.size() - 1) {
                this.getWriter().write(",");
            }
            ++i;
        }
        this.endWriteOTypeDef();
    }

    private void writeOType(JstObjectLiteralType type) {
        this.getWriter().append(type.getSimpleName()).append(" : {");
        List props = type.getProperties();
        this.indent();
        if (type.hasOptionalFields()) {
            List oprops = type.getOptionalFields();
            this.processProps(props, oprops);
        } else {
            this.processProps(props, null);
        }
        this.outdent();
        this.writeNewline();
        this.writeIndent();
        this.getWriter().append("}");
    }

    private void processProps(List<IJstProperty> props, List<IJstProperty> oprops) {
        int propSize = props.size();
        if (oprops != null) {
            propSize += oprops.size();
        }
        this.writeDefs(props, propSize, false, 0);
        if (oprops != null) {
            this.writeDefs(oprops, propSize, true, props.size());
        }
    }

    private void writeDefs(List<IJstProperty> props, int propSize, boolean optional, int count) {
        int i = 0;
        while (i < props.size()) {
            IJstProperty p = props.get(i);
            this.writeNewline();
            this.writeIndent();
            if (p.getDoc() != null) {
                this.printjsdoccomment(p);
            }
            this.getWriter().append(p.getName().getName()).append(" : ").append(p.getValue() != null ? p.getValue().toSimpleTermText() : "null");
            if (count != propSize - 1) {
                this.getWriter().append(",");
            }
            this.getCtx().getProvider().getJsDocGenerator().writeJsDoc(p);
            if (optional) {
                this.getWriter().append("?");
            }
            ++count;
            ++i;
        }
    }

    private void writeOType(JstFunctionRefType type) {
        this.writeJsDoc(type.getMethodRef());
        this.writeNewline();
        this.writeIndent();
        this.getWriter().append(type.getMethodRef().getOriginalName()).append(" : ").append("undefined");
    }

    private boolean shouldExcludeNeed(IJstType type, IJstType t) {
        if (this.isDefaultExtend(t) || this.isNativeType(t)) {
            return true;
        }
        if (!type.isEmbededType() && !type.isAnonymous()) {
            List mxns;
            List impls;
            String name = t.getName();
            List inherits = type.getExtends();
            if (inherits.size() > 0) {
                for (IJstType tp : inherits) {
                    if (!tp.getName().equals(name)) continue;
                    return true;
                }
            }
            if ((impls = type.getSatisfies()) != null && !impls.isEmpty()) {
                for (IJstType tp : impls) {
                    if (!tp.getName().equals(name)) continue;
                    return true;
                }
            }
            if ((mxns = type.getMixinsRef()) != null && !mxns.isEmpty()) {
                for (IJstTypeReference tp : mxns) {
                    if (!tp.getReferencedType().getName().equals(name)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isNativeType(IJstType t) {
        return DataTypeHelper.getNativeType((String)t.getName()) != null;
    }

    private boolean isDefaultExtend(IJstType t) {
        return "vjo.Object".equals(t.getName()) || "vjo.Enum".equals(t.getName()) || Object.class.getName().equals(t.getName());
    }

    public void writeAnonymousType(IJstType anonType, String baseName, List<IExpr> args) {
        boolean hasConstructor;
        IJstType type = VjoGenerator.getJstType(anonType);
        if (type == null) {
            return;
        }
        this.m_currentType = type;
        String argString = "";
        if (args != null) {
            int i = 0;
            while (i < args.size()) {
                if (i > 0) {
                    argString = String.valueOf(argString) + ",";
                }
                argString = String.valueOf(argString) + args.get(i).toExprText();
                ++i;
            }
        }
        this.getWriter().append(VjoConvention.getAnonymousType((String)baseName, (String)argString));
        IJstMethod constructor = type.getConstructor();
        if (constructor instanceof ISynthesized) {
            constructor = null;
        }
        List instanceInits = type.getInstanceInitializers();
        List nvs = type.getInstanceProperties();
        List mtds = JstTypeHelper.getDeclaredMethods((List)type.getInstanceMethods());
        List embeds = type.getInstanceEmbededTypes();
        boolean bl = hasConstructor = constructor != null || !instanceInits.isEmpty();
        if (hasConstructor || nvs.size() + mtds.size() + embeds.size() > 0) {
            this.startWriteProtos();
            this.writePtys(nvs, hasConstructor || mtds.size() + embeds.size() > 0);
            if (hasConstructor) {
                this.writeConstructor(constructor, instanceInits, mtds.size() > 0);
            }
            this.writeEmbeds(embeds, mtds.size() > 0);
            this.writeMtds(mtds);
            this.endWriteProtos();
        }
        this.writeTypeClosure();
    }

    private void writeTypeClosure() {
        this.writeNewline();
        this.writeIndent();
        this.getWriter().append(END_TYPE_CLOSURE);
    }

    private void writeEnumValues(IJstType type) {
        List enumValues = type.getEnumValues();
        int count = enumValues.size();
        if (count == 0) {
            return;
        }
        this.writeNewline();
        this.writeIndent();
        PrintWriter writer = this.getWriter();
        writer.append(".").append("values").append("(");
        if (type.getConstructor() == null || type.getConstructor() instanceof ISynthesized) {
            writer.append("\"");
            int i = 0;
            while (i < count) {
                if (i > 0) {
                    writer.append(", ");
                }
                writer.append(((IJstProperty)enumValues.get(i)).getName().getName());
                ++i;
            }
            writer.append("\"");
        } else {
            int n = type.getEnumValues().size();
            writer.append("{");
            boolean addComma1 = false;
            int i = 0;
            while (i < n) {
                if (addComma1) {
                    writer.append(",");
                }
                this.writeNewline();
                this.indent();
                this.writeIndent();
                IJstProperty enumVal = (IJstProperty)type.getEnumValues().get(i);
                writer.append(enumVal.getName().getName()).append(" : ");
                if (enumVal.getInitializer() instanceof ObjCreationExpr) {
                    ObjCreationExpr expr = (ObjCreationExpr)enumVal.getInitializer();
                    writer.append("[");
                    boolean addComma3 = false;
                    for (IExpr argExpr : expr.getInvocationExpr().getArgs()) {
                        if (argExpr instanceof ArrayLiteral) {
                            boolean addComma2 = false;
                            ArrayLiteral valExpr = (ArrayLiteral)argExpr;
                            Iterator it = valExpr.getValues();
                            while (it.hasNext()) {
                                IExpr valLit = (IExpr)it.next();
                                if (addComma2) {
                                    writer.append(", ");
                                }
                                writer.append(valLit.toExprText());
                                addComma2 = true;
                            }
                            continue;
                        }
                        if (addComma3) {
                            writer.append(", ");
                        }
                        writer.append(argExpr.toExprText());
                        addComma3 = true;
                    }
                    writer.append("]");
                    addComma1 = true;
                } else if (enumVal.getValue() != null) {
                    writer.append(enumVal.getValue().toSimpleTermText());
                }
                this.outdent();
                ++i;
            }
            this.writeNewline();
            writer.append("}");
        }
        writer.append(")");
    }

    public VjoGenerator writeNeeds(String type, String alias) {
        this.writeNewline();
        if (alias != null && !alias.equals(type)) {
            this.getWriter().append(".").append("needs").append("('").append(type).append("','").append(alias).append("')");
        } else {
            this.getWriter().append(".").append("needs").append("('").append(type).append("')");
        }
        return this;
    }

    private VjoGenerator writeInactiveNeeds(IJstType currentType) {
        List needs = currentType.getInactiveImports();
        if (needs == null || needs.size() == 0) {
            return this;
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (IJstType type : needs) {
            if (this.isNativeType(type)) continue;
            if (!first) {
                sb.append(",");
            }
            sb.append(type.getName());
            first = false;
        }
        if (!first) {
            this.writeNewline();
            this.getWriter().append("//> needs ").append(sb);
        }
        return this;
    }

    public VjoGenerator writeNeeds(List<? extends IJstType> needs, IJstType type) {
        if (needs == null || needs.size() == 0) {
            return this;
        }
        if (needs.size() == 1) {
            if (!this.shouldExcludeNeed(type, needs.get(0))) {
                this.writeNeeds(needs.get(0).getName(), needs.get(0).getAlias());
            }
            return this;
        }
        IJstType first = null;
        ArrayList<IJstType> alias = new ArrayList<IJstType>();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (IJstType iJstType : needs) {
            if (this.shouldExcludeNeed(type, iJstType)) continue;
            if (!(iJstType.getAlias() == null || iJstType.getAlias().equals(iJstType.getName()) && type.getImportsMap().get(iJstType.getName()) == null)) {
                alias.add(iJstType);
                continue;
            }
            if (i > 0) {
                sb.append(",");
                if (i % 2 == 0) {
                    sb.append(this.getNewline()).append("    ");
                }
                first = null;
            } else {
                first = iJstType;
            }
            sb.append("'").append(iJstType.getName()).append("'");
            ++i;
        }
        if (first != null) {
            this.writeNeeds(first.getName(), first.getAlias());
        } else if (sb.length() > 0) {
            this.writeNewline();
            this.getWriter().append(".").append("needs").append("([").append(sb.toString()).append("])");
        }
        for (IJstType iJstType : alias) {
            String als = "";
            if (type.getImportsMap().get(iJstType.getName()) == null) {
                als = iJstType.getAlias();
            }
            this.writeNeeds(iJstType.getName(), als);
        }
        return this;
    }

    public VjoGenerator writeType(String type) {
        this.writeJsComment(this.m_currentType);
        if (this.m_currentType.isLocalType()) {
            this.writeIndent();
            String label = type == null ? "$anonymous" : type;
            this.getWriter().append("var ").append(label).append(" = ");
        }
        if (this.m_currentType.getModifiers().isAbstract()) {
            this.getWriter().append("vjo").append(".");
            this.getWriter().append("ctype").append("(");
        } else if (this.m_currentType.isInterface()) {
            this.getWriter().append("vjo").append(".");
            this.getWriter().append("itype").append("(");
        } else if (this.m_currentType.isEnum()) {
            this.getWriter().append("vjo").append(".");
            this.getWriter().append("etype").append("(");
        } else if (this.m_currentType.isMixin()) {
            this.getWriter().append("vjo").append(".");
            this.getWriter().append("mtype").append("(");
        } else if (this.m_currentType.isOType()) {
            this.getWriter().append("vjo").append(".");
            this.getWriter().append("otype").append("(");
        } else {
            this.getWriter().append("vjo").append(".");
            this.getWriter().append("ctype").append("(");
        }
        if (!this.m_currentType.isLocalType() && type != null && !this.getCurrentType().isEmbededType()) {
            this.getWriter().append("'").append(type);
            this.getCtx().getProvider().getJsDocGenerator().writeParamTypes(this.m_currentType);
            this.getWriter().append("'");
        }
        this.getWriter().append(")");
        this.writeJsDoc(this.m_currentType);
        return this;
    }

    private void writeJsComment(IJstType currentType) {
        if (currentType.getCommentLocations() == null) {
            return;
        }
        List comments = null;
        List commentLocations = currentType.getCommentLocations();
        if (currentType.getComments() != null && !currentType.getComments().isEmpty()) {
            comments = currentType.getComments();
        } else if (!commentLocations.isEmpty()) {
            comments = JstCommentHelper.getCommentsAsString((IJstType)currentType, (List)commentLocations);
        }
        if (comments != null) {
            for (String comment : comments) {
                this.getWriter().append(comment);
            }
            this.writeNewline();
        }
    }

    public VjoGenerator writeInherits(IJstType type) {
        this.writeNewline();
        this.writeIndent();
        this.getWriter().append(".").append("inherits").append("('").append(type.getName()).append(GeneratorJstHelper.getArgsDecoration(type)).append("')");
        return this;
    }

    public VjoGenerator writeSatisfies(IJstType type) {
        this.writeNewline();
        this.writeIndent();
        this.getWriter().append(".").append("satisfies").append("('").append(type.getName()).append(GeneratorJstHelper.getArgsDecoration(type)).append("')");
        return this;
    }

    public VjoGenerator writeMixin(IJstType type) {
        this.writeNewline();
        this.writeIndent();
        this.getWriter().append(".").append("mixin").append("('").append(type.getName()).append("')");
        return this;
    }

    public VjoGenerator writeExpects(IJstType type) {
        this.writeNewline();
        this.writeIndent();
        this.getWriter().append(".").append("expects").append("('").append(type.getName()).append("')");
        return this;
    }

    public VjoGenerator writeSatisfies(List<? extends IJstType> needs) {
        if (needs == null || needs.size() == 0) {
            return this;
        }
        if (needs.size() == 0) {
            this.writeSatisfies(needs.get(0));
            return this;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (IJstType iJstType : needs) {
            if (i > 0) {
                sb.append(",");
                if (i % 2 == 0) {
                    sb.append(this.getNewline()).append("    ");
                }
            }
            sb.append("'").append(iJstType.getName()).append("'");
            ++i;
        }
        if (sb.length() > 0) {
            this.writeNewline();
            this.getWriter().append(".").append("satisfies").append("([").append(sb.toString()).append("])");
        }
        return this;
    }

    public VjoGenerator startWriteProps() {
        this.writeNewline();
        this.writeIndent();
        this.getWriter().append(".").append("props").append("({");
        this.indent();
        return this;
    }

    public VjoGenerator endWriteProps() {
        this.outdent();
        this.writeNewline();
        this.writeIndent();
        this.getWriter().append("})");
        return this;
    }

    public VjoGenerator startWriteProtos() {
        this.writeNewline();
        this.writeIndent();
        String meth = "protos";
        if (this.m_currentType.isOType()) {
            meth = "defs";
        }
        this.getWriter().append(".").append(meth).append("({");
        this.indent();
        return this;
    }

    public VjoGenerator endWriteProtos() {
        this.outdent();
        this.writeNewline();
        this.writeIndent();
        this.getWriter().append("})");
        return this;
    }

    public VjoGenerator startWriteOTypeDef() {
        this.writeNewline();
        this.writeIndent();
        this.getWriter().append(".").append("defs").append("({");
        this.writeNewline();
        this.indent();
        return this;
    }

    public VjoGenerator endWriteOTypeDef() {
        this.outdent();
        this.writeNewline();
        this.getWriter().append("})");
        return this;
    }

    public VjoGenerator startWriteInits() {
        this.writeNewline();
        this.writeIndent();
        this.getWriter().append(".").append("inits").append("(function(){");
        this.indent();
        return this;
    }

    public VjoGenerator endWriteInits() {
        this.outdent();
        this.writeNewline();
        this.writeIndent();
        this.getWriter().append("})");
        return this;
    }

    public VjoGenerator writePtys(List<IJstProperty> ptys, boolean hasMore) {
        int size = ptys.size();
        Iterator<IJstProperty> nvs = ptys.iterator();
        int count = 0;
        while (nvs.hasNext()) {
            IJstProperty pty = nvs.next();
            this.writePty(pty, hasMore || count++ < size - 1);
            if (this.suppressJsDoc()) continue;
            this.getCtx().getProvider().getJsDocGenerator().writeJsDoc(pty);
        }
        return this;
    }

    public VjoGenerator writePty(IJstProperty pty, boolean hasMore) {
        this.writeNewline();
        this.writeIndent();
        this.printjsdoccomment(pty);
        this.getWriter().append(((JstProperty)pty).toNVText());
        if (hasMore) {
            this.getWriter().append(",");
        }
        return this;
    }

    private void printjsdoccomment(IJstProperty pty) {
        if (pty.getDoc() != null && pty.getDoc().getComment() != null) {
            this.getWriter().append("/**").append(pty.getDoc().getComment()).append("*/");
            this.writeNewline();
            this.writeIndent();
        }
    }

    public VjoGenerator writeEmbeds(List<? extends IJstType> embeds, boolean hasMore) {
        int size = embeds.size();
        Iterator<? extends IJstType> itr = embeds.iterator();
        int count = 0;
        while (itr.hasNext()) {
            IJstType embed = itr.next();
            this.writeNewline();
            this.writeIndent();
            this.getWriter().append(embed.getSimpleName()).append(":");
            IJstType previousType = this.getCurrentType();
            this.writeVjo(embed);
            this.setCurrentType(previousType);
            if (!hasMore && count++ >= size - 1) continue;
            this.getWriter().append(",");
        }
        return this;
    }

    public VjoGenerator writeMtds(List<? extends IJstMethod> mtds) {
        int size = mtds.size();
        Iterator<? extends IJstMethod> itr = mtds.iterator();
        int count = 0;
        while (itr.hasNext()) {
            IJstMethod mtd = itr.next();
            this.writeNameFunc(mtd, count++ < size - 1);
        }
        return this;
    }

    public VjoGenerator writeConstructor(IJstMethod mtd, List<IStmt> instanceInits, boolean hasMore) {
        IJstMethod constructor = mtd;
        if (mtd == null) {
            constructor = new JstConstructor(new JstArg[0]);
            constructor.getModifiers().setPublic();
            ((JstConstructor)constructor).setParent((IJstNode)this.m_currentType);
        }
        if (instanceInits != null) {
            JstBlock body = ((JstMethod)constructor).getBlock(true);
            int i = 0;
            while (i < instanceInits.size()) {
                body.addStmt(i, instanceInits.get(i));
                ++i;
            }
        }
        ((JstMethod)constructor).setIsConstructor(true);
        this.writeNameFunc(constructor, hasMore);
        return this;
    }

    public VjoGenerator writeNameFunc(IJstMethod mtd, boolean hasMore) {
        this.writeComments((IJstNode)mtd);
        if (mtd.getDoc() != null && mtd.getDoc().getComment() != null) {
            this.writeNewline();
            this.getWriter().append("/**").append(mtd.getDoc().getComment()).append("*/");
            this.writeIndent();
        }
        if (mtd.getRtnType() != null || mtd instanceof JstConstructor || mtd.isConstructor()) {
            this.writeJsDoc(mtd);
        }
        this.getMtdGenerator().writeMtd(mtd);
        boolean isMetaType = this.isMetaMtd(mtd);
        this.getJsCoreGenerator().endWriteFunc(hasMore, isMetaType);
        return this;
    }

    private boolean isMetaMtd(IJstMethod mtd) {
        if (mtd.getAnnotation("metaMethod") != null) {
            return true;
        }
        boolean isMetaType = mtd.getOwnerType() != null ? mtd.getOwnerType().isMetaType() : false;
        return isMetaType;
    }

    public VjoGenerator writeJsDoc(IJstMethod mtd) {
        if (this.suppressJsDoc()) {
            return this;
        }
        this.getCtx().getProvider().getJsDocGenerator().writeJsDoc(mtd);
        List omtds = mtd.getOverloaded();
        if (omtds != null) {
            for (IJstMethod omtd : omtds) {
                if (this.isSame(mtd, omtd)) continue;
                this.getCtx().getProvider().getJsDocGenerator().writeJsDoc(omtd, ((JstMethod)omtd).getAccessScope(), mtd.getOriginalName());
            }
        }
        return this;
    }

    public VjoGenerator writeJsDoc(IJstType type) {
        if (this.suppressJsDoc()) {
            return this;
        }
        this.getCtx().getProvider().getJsDocGenerator().writeJsDoc(type);
        return this;
    }

    private static IJstType getJstType(IJstType type) {
        IJstType jstType = type;
        while (jstType != null) {
            if (!(jstType instanceof JstTypeWithArgs)) break;
            jstType = ((JstTypeWithArgs)jstType).getType();
        }
        if (jstType instanceof IJstType) {
            return type;
        }
        return null;
    }

    IJstType getCurrentType() {
        return this.m_currentType;
    }

    void setCurrentType(IJstType currentType) {
        this.m_currentType = currentType;
    }

    private boolean suppressJsDoc() {
        return this.m_currentType == null || this.m_currentType.getSimpleName() == null;
    }

    private boolean isSame(IJstMethod source, IJstMethod target) {
        int targetParamsCount;
        List sourceParams = source.getArgs();
        List targetParams = target.getArgs();
        int sourceParamsCount = sourceParams.size();
        if (sourceParamsCount == (targetParamsCount = targetParams.size())) {
            int i = 0;
            while (i < sourceParamsCount) {
                JstArg sourceArg = (JstArg)sourceParams.get(i);
                JstArg targetArg = (JstArg)targetParams.get(i);
                if (sourceArg == null && targetArg != null) {
                    return false;
                }
                if (sourceArg != null && targetArg == null) {
                    return false;
                }
                if (!sourceArg.getType().equals(targetArg.getType())) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    private void writeCodeGenCmt() {
        this.getWriter().append("/* ");
        this.writeCodeGenMarker(VjoGenerator.class);
        this.getWriter().append(" */");
        this.writeNewline();
    }

    private List<IJstProperty> getNonProxyProperties(List<IJstProperty> ptys) {
        Iterator<IJstProperty> nvs = ptys.iterator();
        boolean useNew = false;
        ArrayList<IJstProperty> newList = new ArrayList<IJstProperty>();
        while (nvs.hasNext()) {
            IJstProperty pty = nvs.next();
            if (pty instanceof JstProxyProperty) {
                useNew = true;
                continue;
            }
            newList.add(pty);
        }
        return useNew ? newList : ptys;
    }

    private List<? extends IJstMethod> getNonProxyMethods(List<? extends IJstMethod> mtds) {
        ArrayList<IJstMethod> newList = new ArrayList<IJstMethod>();
        boolean useNew = false;
        for (IJstMethod iJstMethod : mtds) {
            if (iJstMethod instanceof JstProxyMethod) {
                useNew = true;
                continue;
            }
            newList.add(iJstMethod);
        }
        return useNew ? newList : mtds;
    }
}

