/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.controller;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.util.TypeCheckUtil;
import org.eclipse.vjet.dsf.jsnative.global.PrimitiveBoolean;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IInferred;
import org.eclipse.vjet.dsf.jst.IJstDoc;
import org.eclipse.vjet.dsf.jst.IJstGlobalFunc;
import org.eclipse.vjet.dsf.jst.IJstGlobalProp;
import org.eclipse.vjet.dsf.jst.IJstGlobalVar;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstOType;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstResultTypeModifier;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstAttributedType;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstDeferredType;
import org.eclipse.vjet.dsf.jst.declaration.JstExtendedType;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncArgAttributedType;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncScopeAttributedType;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstInferredRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstInferredType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstMixedType;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstPotentialAttributedMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstPotentialOtypeMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyType;
import org.eclipse.vjet.dsf.jst.declaration.JstSynthesizedMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.declaration.JstVariantType;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.declaration.JstWildcardType;
import org.eclipse.vjet.dsf.jst.declaration.SynthJstProxyMethod;
import org.eclipse.vjet.dsf.jst.declaration.SynthOlType;
import org.eclipse.vjet.dsf.jst.declaration.TopLevelVarTable;
import org.eclipse.vjet.dsf.jst.declaration.VarTable;
import org.eclipse.vjet.dsf.jst.expr.ArrayAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.ConditionalExpr;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.FuncExpr;
import org.eclipse.vjet.dsf.jst.expr.JstArrayInitializer;
import org.eclipse.vjet.dsf.jst.expr.JstInitializer;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jst.meta.JsCommentMetaNode;
import org.eclipse.vjet.dsf.jst.meta.JsType;
import org.eclipse.vjet.dsf.jst.meta.JsTypingMeta;
import org.eclipse.vjet.dsf.jst.stmt.BlockStmt;
import org.eclipse.vjet.dsf.jst.stmt.RtnStmt;
import org.eclipse.vjet.dsf.jst.stmt.WithStmt;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.JstLiteral;
import org.eclipse.vjet.dsf.jst.term.JstProxyIdentifier;
import org.eclipse.vjet.dsf.jst.term.NV;
import org.eclipse.vjet.dsf.jst.term.ObjLiteral;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;
import org.eclipse.vjet.dsf.jst.traversal.IJstVisitor;
import org.eclipse.vjet.dsf.jst.ts.JstQueryExecutor;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;
import org.eclipse.vjet.dsf.jstojava.controller.GroupInfo;
import org.eclipse.vjet.dsf.jstojava.controller.JstExpressionBindingResolver;
import org.eclipse.vjet.dsf.jstojava.controller.JstExpressionTypeLinker;
import org.eclipse.vjet.dsf.jstojava.controller.JstExpressionTypeLinkerTraversal;
import org.eclipse.vjet.dsf.jstojava.mixer.TypeExtensionRegistry;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsVariantType;
import org.eclipse.vjet.dsf.jstojava.resolver.FunctionMetaRegistry;
import org.eclipse.vjet.dsf.jstojava.resolver.FunctionParamsMetaRegistry;
import org.eclipse.vjet.dsf.jstojava.resolver.IMetaExtension;
import org.eclipse.vjet.dsf.jstojava.resolver.OTypeResolverRegistry;
import org.eclipse.vjet.dsf.jstojava.resolver.TypeResolverRegistry;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.ts.ITypeSpace;
import org.eclipse.vjet.dsf.ts.group.IGroup;
import org.eclipse.vjet.dsf.ts.type.TypeName;

public class JstExpressionTypeLinkerHelper {
    private static final JstSource UNKNOWNBINDING = new JstSource(2, 1, 1, 1, 1, 1);
    private static JstFuncType s_fakeFunc;

    public static IJstNode look4ActualBinding(JstExpressionBindingResolver resolver, IJstType type) {
        return JstExpressionTypeLinkerHelper.look4ActualBinding(resolver, type, null);
    }

    public static IJstNode look4ActualBinding(JstExpressionBindingResolver resolver, IJstType type, GroupInfo groupInfo) {
        if (type == null) {
            return null;
        }
        if (type instanceof JstArray) {
            JstExpressionTypeLinkerHelper.look4ActualBinding(resolver, ((JstArray)type).getComponentType(), groupInfo);
            return null;
        }
        if (type instanceof JstTypeWithArgs) {
            for (IJstType argType : ((JstTypeWithArgs)type).getArgTypes()) {
                JstExpressionTypeLinkerHelper.look4ActualBinding(resolver, argType);
            }
            return null;
        }
        if (type instanceof JstWildcardType) {
            JstExpressionTypeLinkerHelper.look4ActualBinding(resolver, ((JstWildcardType)type).getType(), groupInfo);
            return null;
        }
        if (type instanceof JstFuncType) {
            IJstMethod func = ((JstFuncType)type).getFunction();
            JstExpressionTypeLinkerHelper.bindAttributedType(resolver, func, groupInfo);
            return null;
        }
        if (type instanceof JstAttributedType) {
            return JstExpressionTypeLinkerHelper.doAttributedTypeBindings(resolver, (JstAttributedType)type, groupInfo);
        }
        if (type instanceof JstInferredType) {
            return JstExpressionTypeLinkerHelper.look4ActualBinding(resolver, ((JstInferredType)type).getType(), groupInfo);
        }
        if (type.isFType()) {
            return type;
        }
        return null;
    }

    protected static IJstType bindParamTypes(JstExpressionBindingResolver resolver, IJstNode mtd, MtdInvocationExpr invocation, IJstType qualifierType, IJstType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof JstParamType) {
            return JstExpressionTypeLinkerHelper.resolveParamType(resolver, (JstParamType)type, mtd, invocation, qualifierType);
        }
        if (type instanceof JstArray) {
            return new JstArray(JstExpressionTypeLinkerHelper.bindParamTypes(resolver, mtd, invocation, qualifierType, ((JstArray)type).getComponentType()));
        }
        if (type instanceof JstTypeWithArgs) {
            JstTypeWithArgs typeWithArgs = (JstTypeWithArgs)type;
            IJstType rtnType = JstExpressionTypeLinkerHelper.bindParamTypes(resolver, mtd, invocation, qualifierType, typeWithArgs.getType());
            JstTypeWithArgs resolvedTypeWithArgs = new JstTypeWithArgs(rtnType);
            for (IJstType argType : typeWithArgs.getArgTypes()) {
                resolvedTypeWithArgs.addArgType(JstExpressionTypeLinkerHelper.bindParamTypes(resolver, mtd, invocation, qualifierType, argType));
            }
            return resolvedTypeWithArgs;
        }
        if (type instanceof JstFuncType) {
            JstFuncType funcType = (JstFuncType)type;
            IJstMethod function = funcType.getFunction();
            if (function != null) {
                OverwritableSynthJstProxyMethod resolvedFunction = JstExpressionTypeLinkerHelper.resolveParamFunction(resolver, mtd, invocation, qualifierType, function);
                return new JstFuncType((IJstMethod)resolvedFunction);
            }
        } else {
            IJstMethod invoke;
            if (type instanceof JstAttributedType) {
                JstAttributedType attributedType = (JstAttributedType)type;
                IJstType resolvedAttributorType = JstExpressionTypeLinkerHelper.bindParamTypes(resolver, mtd, invocation, qualifierType, attributedType.getAttributorType());
                return new JstAttributedType(resolvedAttributorType, attributedType.getAttributeName(), attributedType.isStaticAttribute());
            }
            if (type instanceof JstWildcardType) {
                JstWildcardType wildcardType = (JstWildcardType)type;
                IJstType resolvedBoundType = JstExpressionTypeLinkerHelper.bindParamTypes(resolver, mtd, invocation, qualifierType, wildcardType.getType());
                return new JstWildcardType(resolvedBoundType, wildcardType.isUpperBound());
            }
            if (type instanceof JstInferredType) {
                JstInferredType inferredType = (JstInferredType)type;
                IJstType resolvedInferredType = JstExpressionTypeLinkerHelper.bindParamTypes(resolver, mtd, invocation, qualifierType, inferredType.getType());
                return new JstInferredType(resolvedInferredType);
            }
            if (type.isFType() && (invoke = JstExpressionTypeLinkerHelper.getFTypeInvokeMethod(resolver, type)) != null) {
                OverwritableSynthJstProxyMethod resolvedFunction = JstExpressionTypeLinkerHelper.resolveParamFunction(resolver, mtd, invocation, qualifierType, invoke);
                return new OverwritableFType(type, (IJstMethod)resolvedFunction);
            }
        }
        return type;
    }

    private static OverwritableSynthJstProxyMethod resolveParamFunction(JstExpressionBindingResolver resolver, IJstNode mtd, MtdInvocationExpr invocation, IJstType qualifierType, IJstMethod function) {
        if (function == null) {
            throw new IllegalArgumentException("proxy function could not be null");
        }
        if (!function.isDispatcher()) {
            IJstType resolvedRtnType = JstExpressionTypeLinkerHelper.bindParamTypes(resolver, mtd, invocation, qualifierType, function.getRtnType());
            ArrayList<JstArg> resolvedJstArgs = new ArrayList<JstArg>(function.getArgs().size());
            for (JstArg arg : function.getArgs()) {
                JstArg resolvedArg = new JstArg(arg.getTypes(), arg.getName(), arg.isVariable(), arg.isOptional(), arg.isFinal());
                for (IJstType argType : arg.getTypes()) {
                    resolvedArg.updateType(arg.getName(), JstExpressionTypeLinkerHelper.bindParamTypes(resolver, mtd, invocation, qualifierType, argType));
                }
                resolvedJstArgs.add(resolvedArg);
            }
            OverwritableSynthJstProxyMethod resolvedFunction = new OverwritableSynthJstProxyMethod(function);
            resolvedFunction.setRtnType(resolvedRtnType);
            resolvedFunction.setArgs(resolvedJstArgs);
            return resolvedFunction;
        }
        OverwritableSynthJstProxyMethod host = null;
        for (IJstMethod overload : function.getOverloaded()) {
            OverwritableSynthJstProxyMethod resolvedOverload = JstExpressionTypeLinkerHelper.resolveParamFunction(resolver, mtd, invocation, qualifierType, overload);
            if (host == null) {
                host = resolvedOverload;
            }
            host.addOverloaded((IJstMethod)resolvedOverload);
        }
        return host;
    }

    private static IJstType resolveParamType(JstExpressionBindingResolver resolver, JstParamType paramType, IJstNode node, MtdInvocationExpr invocation, IJstType qualifierType) {
        if (paramType == null) {
            throw new IllegalArgumentException("param type to be resolved should not be null");
        }
        if (node instanceof IJstMethod) {
            IJstMethod mtd = (IJstMethod)node;
            List methodParamTypes = mtd.getParamTypes();
            for (JstParamType methodParamType : methodParamTypes) {
                if (!paramType.equals(methodParamType)) continue;
                int i = 0;
                int len = mtd.getArgs().size();
                while (i < len) {
                    List args;
                    JstArg param = (JstArg)mtd.getArgs().get(i);
                    if (paramType.equals(param.getType()) && (args = invocation.getArgs()).size() > i) {
                        return ((IExpr)args.get(i)).getResultType();
                    }
                    ++i;
                }
            }
        }
        if (qualifierType instanceof JstTypeWithArgs) {
            JstTypeWithArgs jstTypeWithArgs = (JstTypeWithArgs)qualifierType;
            IJstType resolved = jstTypeWithArgs.getParamArgType(paramType);
            if (resolved != null) {
                return resolved;
            }
        } else {
            IJstType objectType = JstExpressionTypeLinkerHelper.getNativeTypeFromTS(resolver, "Object");
            return new JstInferredType(objectType);
        }
        return paramType;
    }

    protected static IJstNode bindAttributedType(JstExpressionBindingResolver resolver, IJstMethod method, GroupInfo groupInfo) {
        if (method != null) {
            JstExpressionTypeLinkerHelper.look4ActualBinding(resolver, method.getRtnType(), groupInfo);
            for (JstArg arg : method.getArgs()) {
                for (IJstType argType : arg.getTypes()) {
                    JstExpressionTypeLinkerHelper.look4ActualBinding(resolver, argType, groupInfo);
                }
            }
            return method;
        }
        return null;
    }

    protected static IJstNode doAttributedTypeBindings(JstExpressionBindingResolver resolver, JstAttributedType attributedType, GroupInfo groupInfo) {
        Object bound = null;
        IJstType attributorType = attributedType.getType();
        String attributeName = attributedType.getAttributeName();
        boolean staticAttribute = attributedType.isStaticAttribute();
        if (attributorType != null && attributeName != null) {
            if (attributorType.isOType()) {
                IJstOType objLiteralOrFunctionRefType = attributorType.getOType(attributeName);
                if (objLiteralOrFunctionRefType != null) {
                    bound = objLiteralOrFunctionRefType;
                }
            } else {
                IJstProperty pty = attributorType.getProperty(attributeName, staticAttribute);
                IJstProperty iJstProperty = pty == null ? attributorType.getProperty(attributeName, !staticAttribute) : (pty = pty);
                if (pty != null) {
                    bound = new TranslateHelper.RenameableSynthJstProxyProp(pty, null);
                } else {
                    IJstMethod mtd = attributorType.getMethod(attributeName, staticAttribute);
                    IJstMethod iJstMethod = mtd == null ? attributorType.getMethod(attributeName, !staticAttribute) : (mtd = mtd);
                    if (mtd != null) {
                        bound = new TranslateHelper.RenameableSynthJstProxyMethod(mtd, mtd.getName());
                        JstExpressionTypeLinkerHelper.look4ActualBinding(resolver, mtd.getRtnType(), groupInfo);
                        for (JstArg arg : mtd.getArgs()) {
                            for (IJstType argType : arg.getTypes()) {
                                JstExpressionTypeLinkerHelper.look4ActualBinding(resolver, argType, groupInfo);
                            }
                        }
                    } else if ("Global".equals(attributorType.getSimpleName()) && (bound = JstExpressionTypeLinkerHelper.getFromGlobalVarName(resolver, attributeName, true, groupInfo)) == null && (bound = JstExpressionTypeLinkerHelper.getFromGlobalTypeName(resolver, attributeName, groupInfo)) != null) {
                        if (bound instanceof IJstGlobalFunc) {
                            bound = JstExpressionTypeLinkerHelper.getFurtherGlobalVarBinding(resolver, (IJstGlobalFunc)bound, groupInfo);
                        } else if (bound instanceof IJstGlobalProp) {
                            bound = JstExpressionTypeLinkerHelper.getFurtherGlobalVarBinding(resolver, (IJstGlobalProp)bound, groupInfo);
                        }
                    }
                }
            }
        }
        if (bound != null) {
            attributedType.setJstBinding(bound);
        }
        return bound;
    }

    public static IJstType getResolvedAttributedType(JstExpressionBindingResolver resolver, JstIdentifier identifier, JstAttributedType type, IJstNode bound) {
        JstAttributedType attributedType = type;
        if (bound instanceof IJstProperty) {
            attributedType = ((IJstProperty)bound).getType();
        } else if (bound instanceof IJstMethod) {
            attributedType = new JstFuncType((IJstMethod)bound);
        }
        return attributedType;
    }

    public static IJstNode getFromGlobalVarName(JstExpressionBindingResolver resolver, String name, boolean overwiteBindings, GroupInfo groupInfo) {
        IJstNode bound = JstExpressionTypeLinkerHelper.findIdentifierBinding(JstExpressionTypeLinkerHelper.getNativeTypeFromTS(resolver, groupInfo != null ? groupInfo.getGroupName() : null, "Window"), name);
        if (bound != null) {
            return bound;
        }
        bound = JstExpressionTypeLinkerHelper.findIdentifierBinding(JstExpressionTypeLinkerHelper.getNativeTypeFromTS(resolver, "Global"), name);
        return bound;
    }

    public static boolean getFromWithVarName(JstExpressionBindingResolver resolver, JstExpressionTypeLinker.ScopeFrame scope, JstIdentifier identifier, GroupInfo groupInfo) {
        WithStmt withStmt;
        IExpr withExpr;
        IJstType nodeType = null;
        BaseJstNode it = identifier.getParentNode();
        while (it != null && !(it instanceof WithStmt)) {
            it = it.getParentNode();
        }
        return it != null && it instanceof WithStmt && JstExpressionTypeLinkerHelper.mapVarToTypeMember(resolver, scope, nodeType = (withExpr = (withStmt = (WithStmt)it).getCondition().getLeft()).getResultType(), identifier, identifier.getName(), false, groupInfo);
    }

    public static boolean getFromGlobalTypeName(JstExpressionBindingResolver resolver, JstExpressionTypeLinker.ScopeFrame scope, JstIdentifier identifier, GroupInfo groupInfo) {
        IJstNode bound = JstExpressionTypeLinkerHelper.getFromGlobalTypeName(resolver, identifier.getName(), groupInfo);
        if (bound != null) {
            List<IJstType> symbolTypes = JstExpressionTypeLinkerHelper.collectBindingTypes(bound);
            int i = 0;
            int len = symbolTypes.size();
            while (i < len) {
                JstExpressionTypeLinkerHelper.look4ActualBinding(resolver, symbolTypes.get(i), groupInfo);
                ++i;
            }
            if (symbolTypes.size() <= 0) {
                return false;
            }
            JstExpressionTypeLinkerHelper.bindIdentifier(resolver, scope, identifier, identifier.getName(), bound, symbolTypes.get(0), true, groupInfo);
            return true;
        }
        return false;
    }

    public static IJstNode getFromGlobalTypeName(JstExpressionBindingResolver resolver, String name, GroupInfo groupInfo) {
        List types;
        ITypeSpace typeSpace = resolver.getController().getJstTypeSpaceMgr().getTypeSpace();
        IGroup currentGroup = typeSpace.getGroup(groupInfo != null ? groupInfo.getGroupName() : null);
        IJstNode bound = (IJstNode)typeSpace.getVisibleGlobal(name, currentGroup);
        if ((bound = JstExpressionTypeLinkerHelper.findGlobalVarBinding(resolver, bound, groupInfo)) == null && name.indexOf(46) == -1 && (types = resolver.getController().getJstTypeSpaceMgr().getTypeSpace().getVisibleType(name, currentGroup)) != null && types.size() == 1) {
            bound = (IJstNode)types.get(0);
        }
        bound = bound instanceof IJstType && !(bound instanceof IJstRefType) && !((IJstType)bound).isSingleton() ? JstTypeHelper.getJstTypeRefType((IJstType)((IJstType)bound)) : bound;
        return bound;
    }

    public static IJstNode getFromGlobalTypeName2(JstExpressionBindingResolver resolver, String name, GroupInfo groupInfo) {
        List visibleType;
        ITypeSpace typeSpace = resolver.getController().getJstTypeSpaceMgr().getTypeSpace();
        IJstNode bound = (IJstNode)typeSpace.getVisibleGlobal(name, typeSpace.getGroup(groupInfo.getGroupName()));
        if ((bound = JstExpressionTypeLinkerHelper.findGlobalVarBinding(resolver, bound, groupInfo)) != null) {
            Object object = bound = bound instanceof IJstType && !(bound instanceof IJstRefType) ? JstTypeHelper.getJstTypeRefType((IJstType)((IJstType)bound)) : bound;
        }
        if (bound != null && name.indexOf(46) == -1 && (visibleType = resolver.getController().getJstTypeSpaceMgr().getTypeSpace().getVisibleType(name, typeSpace.getGroup(groupInfo.getGroupName()))).size() == 1 && (bound = JstTypeHelper.getJstTypeRefType((IJstType)((IJstType)visibleType.get(0)))) != null) {
            bound = bound instanceof IJstType && !(bound instanceof IJstRefType) ? JstTypeHelper.getJstTypeRefType((IJstType)((IJstType)bound)) : bound;
        }
        return bound;
    }

    public static List<IJstType> collectBindingTypes(IJstNode bound) {
        ArrayList<IJstType> toBindTypes = new ArrayList<IJstType>(2);
        if (bound instanceof IJstType) {
            if (bound instanceof IJstRefType || ((IJstType)bound).isSingleton()) {
                toBindTypes.add((IJstType)bound);
            } else {
                toBindTypes.add((IJstType)JstTypeHelper.getJstTypeRefType((IJstType)((IJstType)bound)));
            }
        } else if (bound instanceof IJstProperty) {
            toBindTypes.add(((IJstProperty)bound).getType());
        } else if (bound instanceof IJstMethod) {
            toBindTypes.add(((IJstMethod)bound).getRtnType());
            for (JstArg arg : ((IJstMethod)bound).getArgs()) {
                for (IJstType argType : arg.getTypes()) {
                    toBindTypes.add(argType);
                }
            }
        } else if (bound instanceof IExpr) {
            toBindTypes.add(((IExpr)bound).getResultType());
        }
        return toBindTypes;
    }

    public static IJstNode findGlobalVarBinding(JstExpressionBindingResolver resolver, IJstNode node, GroupInfo groupInfo) {
        if (node instanceof IJstGlobalVar) {
            IJstGlobalVar jstGlobalVar = (IJstGlobalVar)node;
            if (jstGlobalVar.isFunc()) {
                IJstGlobalFunc method = jstGlobalVar.getFunction();
                JstExpressionTypeLinkerHelper.bindAttributedType(resolver, (IJstMethod)method, groupInfo);
                return method;
            }
            IJstGlobalProp property = jstGlobalVar.getProperty();
            JstExpressionTypeLinkerHelper.look4ActualBinding(resolver, property.getType(), groupInfo);
            return property;
        }
        return node;
    }

    public static String getGlobalVarNameFromBinding(IJstNode qualifierBinding) {
        String globalVarName = null;
        if (qualifierBinding instanceof IJstGlobalFunc) {
            globalVarName = ((IJstGlobalFunc)qualifierBinding).getName().getName();
        } else if (qualifierBinding instanceof IJstGlobalProp) {
            globalVarName = ((IJstGlobalProp)qualifierBinding).getName().getName();
        }
        return globalVarName;
    }

    public static boolean isGlobalVarExtended(JstExpressionBindingResolver resolver, String globalVarName) {
        return resolver.getController().getJstTypeSpaceMgr().getQueryExecutor().hasGlobalExtension(globalVarName);
    }

    public static IJstGlobalVar getGlobalVarExtensionByName(JstExpressionBindingResolver resolver, String extName, String globalVarName) {
        List extensions = resolver.getController().getJstTypeSpaceMgr().getQueryExecutor().getGlobalExtensions(globalVarName);
        if (extensions != null) {
            for (IJstNode ext : extensions) {
                IJstGlobalVar extVar;
                if (!(ext instanceof IJstGlobalVar) || !extName.equals((extVar = (IJstGlobalVar)ext).getName().getName())) continue;
                return extVar;
            }
        }
        return null;
    }

    public static IJstNode look4ActualGlobalVarBinding(JstExpressionBindingResolver resolver, IJstGlobalVar extVar, GroupInfo groupInfo) {
        IJstNode mtdBinding;
        if (extVar.isFunc()) {
            IJstGlobalFunc extFunc = extVar.getFunction();
            mtdBinding = JstExpressionTypeLinkerHelper.getFurtherGlobalVarBinding(resolver, extFunc, groupInfo);
        } else {
            IJstGlobalProp extProp = extVar.getProperty();
            mtdBinding = JstExpressionTypeLinkerHelper.getFurtherGlobalVarBinding(resolver, extProp, groupInfo);
        }
        return mtdBinding;
    }

    public static void doMethodBinding(JstExpressionBindingResolver resolver, MtdInvocationExpr mie, JstIdentifier methodId, IJstNode mtdBinding) {
        if (mtdBinding != null) {
            if (mtdBinding instanceof IJstMethod) {
                methodId.setJstBinding(mtdBinding);
                mie.setResultType(((IJstMethod)mtdBinding).getRtnType());
            } else if (mtdBinding instanceof IJstType && ((IJstType)mtdBinding).isFType()) {
                IJstMethod _invoke_ = JstExpressionTypeLinkerHelper.getFTypeInvokeMethod(resolver, (IJstType)mtdBinding);
                methodId.setJstBinding((IJstNode)_invoke_);
                mie.setResultType(_invoke_.getRtnType());
            }
        }
    }

    public static IJstNode getFurtherGlobalVarBinding(JstExpressionBindingResolver resolver, IJstGlobalFunc method, GroupInfo groupInfo) {
        return JstExpressionTypeLinkerHelper.bindAttributedType(resolver, (IJstMethod)method, groupInfo);
    }

    public static IJstNode getFurtherGlobalVarBinding(JstExpressionBindingResolver resolver, IJstGlobalProp property, GroupInfo groupInfo) {
        IJstNode furtherBinding = JstExpressionTypeLinkerHelper.look4ActualBinding(resolver, property.getType(), groupInfo);
        return furtherBinding != null ? furtherBinding : property;
    }

    public static IJstNode findIdentifierBinding(IJstType nodeType, String name) {
        if (nodeType != null) {
            IJstProperty namedProperty = nodeType.getProperty(name, nodeType instanceof IJstRefType, true);
            if (namedProperty != null) {
                return namedProperty;
            }
            IJstMethod namedMethod = nodeType.getMethod(name, nodeType instanceof IJstRefType, true);
            return namedMethod;
        }
        return null;
    }

    public static boolean mapVarToTypeMember(JstExpressionBindingResolver resolver, JstExpressionTypeLinker.ScopeFrame scope, IJstType nodeType, JstIdentifier identifier, String name, boolean overwriteBindings, GroupInfo groupInfo) {
        IJstNode bound;
        boolean found = false;
        if (nodeType != null && (bound = JstExpressionTypeLinkerHelper.findIdentifierBinding(nodeType, name)) != null) {
            List<IJstType> symbolTypes = JstExpressionTypeLinkerHelper.collectBindingTypes(bound);
            JstExpressionTypeLinkerHelper.bindIdentifier(resolver, scope, identifier, name, bound, symbolTypes.get(0), false, groupInfo);
            found = true;
        }
        return found;
    }

    public static boolean getFromGlobalVarName(JstExpressionBindingResolver resolver, JstExpressionTypeLinker.ScopeFrame scope, JstIdentifier identifier, GroupInfo groupInfo) {
        String name = identifier.getName();
        IJstNode bound = JstExpressionTypeLinkerHelper.getFromGlobalVarName(resolver, name, false, groupInfo);
        if (bound != null) {
            List<IJstType> symbolTypes = JstExpressionTypeLinkerHelper.collectBindingTypes(bound);
            JstExpressionTypeLinkerHelper.bindIdentifier(resolver, scope, identifier, name, bound, symbolTypes.get(0), false, groupInfo);
            return true;
        }
        return false;
    }

    public static IJstMethod getFTypeInvokeMethod(JstExpressionBindingResolver resolver, IJstType ftype) {
        if (ftype == null || !ftype.isFType()) {
            throw new IllegalArgumentException("the vjo type in this context must be a non-null ftype");
        }
        IJstMethod _invoke_ = ftype.getMethod("_invoke_", true);
        if (_invoke_ != null) {
            return _invoke_;
        }
        JstSynthesizedMethod flexMtd = JstExpressionTypeLinkerHelper.createFlexMethod(resolver, "_invoke_");
        if (ftype instanceof JstType) {
            ((JstType)ftype).addMethod((IJstMethod)flexMtd);
        }
        return flexMtd;
    }

    public static JstSynthesizedMethod createFlexMethod(JstExpressionBindingResolver resolver, String name) {
        JstModifiers flexModifiers = new JstModifiers();
        flexModifiers.setPublic();
        JstSynthesizedMethod flexMtd = new JstSynthesizedMethod(name != null ? name : "flex", flexModifiers, null);
        IJstType objType = JstExpressionTypeLinkerHelper.getNativeObjectJstType(resolver);
        flexMtd.setRtnType(objType);
        JstArg flexArg = new JstArg(objType, name != null ? String.valueOf(name) + "Arg" : "flexArg", true);
        flexMtd.addArg(flexArg);
        return flexMtd;
    }

    public static JstConstructor createFlexConstructor(JstExpressionBindingResolver resolver) {
        JstSynthesizedMethod flexMethod = JstExpressionTypeLinkerHelper.createFlexMethod(resolver, "constructs");
        return new JstConstructor(flexMethod.getModifiers(), flexMethod.getArgs().toArray(new JstArg[flexMethod.getArgs().size()]));
    }

    public static IJstNode getCorrectMethod(JstExpressionBindingResolver resolver, IJstType nodeType, String methodName, boolean isStatic) {
        IJstProperty pty;
        IJstMethod method = nodeType.getMethod(methodName, isStatic, true);
        if (method == null && (pty = nodeType.getProperty(methodName, isStatic, true)) != null) {
            IJstType ptyType = pty.getType();
            if (ptyType instanceof IJstRefType) {
                method = ptyType.getConstructor();
            } else if (ptyType instanceof JstFuncType) {
                method = ((JstFuncType)ptyType).getFunction();
                JstExpressionTypeLinkerHelper.getMethodMetaFromProperty((IJstNode)method, pty);
            } else {
                method = pty;
            }
        }
        return method;
    }

    private static void getMethodMetaFromProperty(IJstNode mtd, IJstProperty pty) {
        if (mtd instanceof JstMethod) {
            JstMethod mtdNode = (JstMethod)mtd;
            mtdNode.setParent(pty.getParentNode());
            mtdNode.getModifiers().merge(pty.getModifiers().getFlags());
        }
    }

    public static IJstOType getOtype(String otypeName) {
        LinkedList<String> subs = new LinkedList<String>();
        IJstType otype = JstExpressionTypeLinkerHelper.getOtypeParentType(otypeName, subs);
        if (otype == null) {
            return null;
        }
        Object otypeSubType = otype;
        Iterator it = subs.iterator();
        while (it.hasNext() && otypeSubType != null) {
            String sub = (String)it.next();
            otypeSubType = it.hasNext() ? otypeSubType.getEmbededType(sub) : otypeSubType.getOType(sub);
        }
        return otypeSubType instanceof IJstOType ? (IJstOType)otypeSubType : null;
    }

    private static IJstType getOtypeParentType(String otypeName, List<String> subs) {
        int lastDotAt;
        JstType potentialOtypeJstFunctionRefType = JstCache.getInstance().getType(otypeName);
        if (potentialOtypeJstFunctionRefType instanceof JstType && potentialOtypeJstFunctionRefType.getStatus().hasResolution()) {
            return potentialOtypeJstFunctionRefType;
        }
        int n = lastDotAt = otypeName != null ? otypeName.lastIndexOf(46) : -1;
        if (lastDotAt < 0) {
            return null;
        }
        String otypeParentTypeName = otypeName.substring(0, lastDotAt);
        if (lastDotAt < otypeName.length()) {
            String sub = otypeName.substring(lastDotAt + 1);
            subs.add(0, sub);
        }
        return JstExpressionTypeLinkerHelper.getOtypeParentType(otypeParentTypeName, subs);
    }

    public static String getFullNameIfShortName4InnerType(IJstType currentType, IJstType potentialOtypeMemberType) {
        if (currentType == null || potentialOtypeMemberType == null) {
            return "";
        }
        return currentType.getName() + '.' + potentialOtypeMemberType.getName();
    }

    public static void fixMethodTypeRef(JstExpressionBindingResolver resolver, JstMethod method, IJstType currentType, GroupInfo groupInfo) {
        List overloaded;
        List args;
        IJstType rtnType;
        IJstType rtnCorrectType = rtnType = method.getRtnType();
        if (rtnType instanceof JstType && !((JstType)rtnType).getStatus().isValid()) {
            IJstType potentialOtypeMemberType = rtnType;
            IJstOType resolvedOtype = JstExpressionTypeLinkerHelper.getOtype(potentialOtypeMemberType.getName());
            if (resolvedOtype == null) {
                resolvedOtype = JstExpressionTypeLinkerHelper.getOtype(JstExpressionTypeLinkerHelper.getFullNameIfShortName4InnerType(currentType, potentialOtypeMemberType));
            }
            if (resolvedOtype != null) {
                rtnCorrectType = resolvedOtype;
            }
        }
        if ((rtnCorrectType = JstExpressionTypeLinkerHelper.getCorrectType(resolver, rtnType, groupInfo)) != rtnType) {
            method.setRtnType(rtnCorrectType);
        }
        if ((args = method.getArgs()) != null) {
            for (JstArg arg : args) {
                Iterator iterator = arg.getTypes().iterator();
                while (iterator.hasNext()) {
                    IJstType parameterType;
                    IJstType parameterCorrectType = parameterType = (IJstType)iterator.next();
                    if (parameterType instanceof JstMixedType && !((JstType)parameterType).getStatus().isValid()) {
                        JstMixedType mixedOTypes = (JstMixedType)parameterType;
                        for (IJstType mixedType : mixedOTypes.getMixedTypes()) {
                            JstExpressionTypeLinkerHelper.look4ActualBinding(resolver, mixedType, groupInfo);
                        }
                    } else if (parameterType instanceof JstType && !((JstType)parameterType).getStatus().isValid()) {
                        IJstType potentialOtypeMemberType = parameterType;
                        IJstOType resolvedOtype = JstExpressionTypeLinkerHelper.getOtype(potentialOtypeMemberType.getName());
                        if (resolvedOtype == null) {
                            resolvedOtype = JstExpressionTypeLinkerHelper.getOtype(JstExpressionTypeLinkerHelper.getFullNameIfShortName4InnerType(currentType, potentialOtypeMemberType));
                        }
                        if (resolvedOtype != null) {
                            parameterCorrectType = resolvedOtype;
                        }
                    }
                    parameterCorrectType = JstExpressionTypeLinkerHelper.getCorrectType(resolver, parameterCorrectType, groupInfo);
                    if (parameterCorrectType == parameterType) continue;
                    arg.updateType(parameterType.getName(), parameterCorrectType);
                }
            }
        }
        if ((overloaded = method.getOverloaded()) != null && !overloaded.isEmpty()) {
            for (IJstMethod mtd : overloaded) {
                if (!(mtd instanceof JstMethod)) continue;
                JstExpressionTypeLinkerHelper.fixMethodTypeRef(resolver, (JstMethod)mtd, currentType, groupInfo);
            }
        }
        JstExpressionTypeLinkerHelper.updateMethodSignature(method);
    }

    private static void updateMethodSignature(JstMethod method) {
        if (method.hasJsAnnotation()) {
            return;
        }
        BaseJstNode parent = method.getParentNode();
        if (!(parent instanceof IJstType)) {
            return;
        }
    }

    private static IJstMethod searchParentMethodWithAnnotation(IJstType type, String mtdName, boolean isStatic) {
        if (type != null) {
            IJstMethod method = type.getMethod(mtdName, isStatic);
            if (method != null && method.hasJsAnnotation()) {
                return method;
            }
            ArrayList parentTypes = new ArrayList();
            parentTypes.addAll(type.getExtends());
            parentTypes.addAll(type.getSatisfies());
            for (IJstType parentType : parentTypes) {
                IJstMethod parentMtd;
                if (parentType == type || (parentMtd = JstExpressionTypeLinkerHelper.searchParentMethodWithAnnotation(parentType, mtdName, isStatic)) == null) continue;
                return parentMtd;
            }
            return method;
        }
        return null;
    }

    public static void updateResultType(IJstResultTypeModifier expr, IJstType resultType) {
        expr.setType(resultType);
    }

    public static void updateArrayType(JstArray arrayType, GroupInfo groupInfo) {
        IJstType nativeArrType = arrayType.getExtend();
        IJstType extendedType = JstExpressionTypeLinkerHelper.getExtendedType(nativeArrType, groupInfo);
        if (extendedType != nativeArrType) {
            arrayType.clearExtends();
            arrayType.addExtend(extendedType);
        }
    }

    public static void updateFunctionType(JstType ftype, GroupInfo groupInfo) {
        IJstType nativeFuncType = ftype.getExtend();
        IJstType extendedType = JstExpressionTypeLinkerHelper.getExtendedType(nativeFuncType, groupInfo);
        if (extendedType != nativeFuncType) {
            ftype.clearExtends();
            ftype.addExtend(extendedType);
        }
    }

    public static void updateFunctionType(JstFuncType funcType, GroupInfo groupInfo) {
        IJstType nativeFuncType = funcType.getExtend();
        IJstType extendedType = JstExpressionTypeLinkerHelper.getExtendedType(nativeFuncType, groupInfo);
        if (extendedType != nativeFuncType) {
            funcType.clearExtends();
            funcType.addExtend(extendedType);
        }
    }

    public static void fixPropertyTypeRef(JstExpressionBindingResolver resolver, IJstVisitor jstExpressionTypeLinker, JstProperty pty, GroupInfo groupInfo) {
        IJstType ptyType = pty.getType();
        IJstType correctType = JstExpressionTypeLinkerHelper.getCorrectType(resolver, ptyType, groupInfo);
        if (pty.getValue() != null && pty.getValue() instanceof IExpr) {
            JstExpressionTypeLinkerHelper.doExprTypeResolve(resolver, jstExpressionTypeLinker, (IExpr)pty.getValue(), correctType);
        } else if (pty.getInitializer() != null) {
            JstExpressionTypeLinkerHelper.doExprTypeResolve(resolver, jstExpressionTypeLinker, pty.getInitializer(), correctType);
        }
        if (correctType != ptyType) {
            pty.setType(correctType);
        }
    }

    public static void fixVarsTypeRef(JstExpressionBindingResolver resolver, JstVars var, GroupInfo groupInfo) {
        IJstType varType = var.getType();
        IJstType correctType = JstExpressionTypeLinkerHelper.getCorrectType(resolver, varType, groupInfo);
        if (correctType != varType) {
            var.setType(correctType);
        }
    }

    public static IJstType getQualifierType(JstExpressionBindingResolver resolver, IExpr expr) {
        if (expr == null) {
            return null;
        }
        IExpr qualifier = null;
        if (expr instanceof FieldAccessExpr) {
            qualifier = ((FieldAccessExpr)expr).getExpr();
        } else if (expr instanceof MtdInvocationExpr) {
            qualifier = ((MtdInvocationExpr)expr).getQualifyExpr();
        } else if (expr instanceof JstIdentifier) {
            qualifier = ((JstIdentifier)expr).getQualifier();
        } else if (expr instanceof ObjCreationExpr) {
            qualifier = ((ObjCreationExpr)expr).getInvocationExpr();
        } else if (expr instanceof ArrayAccessExpr) {
            qualifier = ((ArrayAccessExpr)expr).getExpr();
        }
        if (qualifier != null) {
            IJstNode binding;
            IJstType qualifierType = qualifier.getResultType();
            if (qualifierType instanceof JstAttributedType && (binding = ((JstAttributedType)qualifierType).getJstBinding()) != null) {
                if (binding instanceof IJstProperty) {
                    return ((IJstProperty)binding).getType();
                }
                if (binding instanceof IJstMethod) {
                    return new JstFuncType((IJstMethod)binding);
                }
            }
            return qualifierType;
        }
        return null;
    }

    public static String getSimpleTypeName(IJstType nodeType) {
        String simpleName = null;
        simpleName = nodeType instanceof IJstRefType ? ((IJstRefType)nodeType).getReferencedNode().getSimpleName() : nodeType.getSimpleName();
        return simpleName == null ? "" : simpleName;
    }

    public static IJstMethod getConstructs(IJstType nodeType, String methodName) {
        IJstMethod construct;
        if (nodeType != null && methodName != null && (construct = nodeType.getConstructor()) != null && (JstExpressionTypeLinkerHelper.getSimpleTypeName(nodeType).equals(methodName) || construct.getName().getName().equals(methodName))) {
            return construct;
        }
        return null;
    }

    public static IJstMethod getDeclaredMethod(IJstType declaringType, String methodName, boolean isStatic) {
        return declaringType.getMethod(methodName, isStatic);
    }

    public static String getTypeName(IJstType declaringType) {
        if (declaringType == null) {
            return "";
        }
        return declaringType.getName();
    }

    public static JstSource createSourceRef(IExpr mtdInvocationExpr) {
        if (mtdInvocationExpr == null) {
            return UNKNOWNBINDING;
        }
        JstSource src = mtdInvocationExpr.getSource();
        if (src == null) {
            return UNKNOWNBINDING;
        }
        return src;
    }

    public static IJstType getVarType(JstExpressionBindingResolver resolver, IJstNode var) {
        IJstNode jstVars;
        IJstNode grandParent;
        IJstNode parent;
        Object type = null;
        if (var instanceof JstVar) {
            type = ((JstVar)var).getType();
        } else if (var instanceof JstVars) {
            type = ((JstVars)var).getType();
        } else if (var instanceof JstArg) {
            JstArg arg = (JstArg)var;
            List listTypes = arg.getTypes();
            type = listTypes.size() > 1 ? new JstVariantType(listTypes) : arg.getType();
        } else if (var instanceof IJstMethod) {
            type = new JstFuncType((IJstMethod)var);
        } else if (var instanceof JstIdentifier) {
            type = ((JstIdentifier)var).getType();
        } else if (var instanceof IJstType) {
            type = (IJstType)var;
        }
        if (var instanceof ILHS && (parent = var.getParentNode()) instanceof AssignExpr && (grandParent = parent.getParentNode()) instanceof JstInitializer && (jstVars = grandParent.getParentNode()) instanceof JstVars) {
            type = ((JstVars)jstVars).getType();
        }
        return type;
    }

    public static IInferred cloneInferredType(IInferred type) {
        if (type instanceof JstInferredRefType) {
            return new JstInferredRefType((IJstRefType)((JstInferredRefType)type).getType());
        }
        if (type instanceof JstInferredType) {
            return new JstInferredType(((JstInferredType)type).getType());
        }
        return type;
    }

    public static IJstType getReturnTypeFormFactoryEnabled(MtdInvocationExpr mie, IJstMethod mtd) {
        List exprs;
        String mtdKey = mtd.getOwnerType().getName();
        mtdKey = String.valueOf(mtdKey) + (mtd.isStatic() ? "::" : ":");
        mtdKey = String.valueOf(mtdKey) + mtd.getName().getName();
        TypeResolverRegistry trr = TypeResolverRegistry.getInstance();
        if (trr.hasResolver(mtdKey) && (exprs = mie.getArgs()).size() > 0) {
            String[] args = new String[exprs.size()];
            int i = 0;
            while (i < exprs.size()) {
                args[i] = ((IExpr)exprs.get(i)).toExprText();
                ++i;
            }
            IJstType type = trr.resolve(mtdKey, args);
            if (type != null) {
                return type;
            }
        }
        return null;
    }

    public static IJstType getBestRtnTypeFromAllOverloadMtds(MtdInvocationExpr mie, IJstMethod mtd) {
        IJstType returnType = JstExpressionTypeLinkerHelper.getRtnTypeFromSingleMtd(mie, mtd);
        List overloads = mtd.getOverloaded();
        if (!mtd.isDispatcher() || JstExpressionTypeLinkerHelper.checkAllOverloadsRtnTypeTheSame(overloads)) {
            return returnType;
        }
        List arguments = mie.getArgs();
        int argumentsLength = arguments.size();
        HashMap<IJstMethod, List<JstArg>> overloads2ParamsMap = new HashMap<IJstMethod, List<JstArg>>(overloads.size());
        JstExpressionTypeLinkerHelper.initOverloadsWithCorrectParamSize(overloads, argumentsLength, overloads2ParamsMap);
        JstExpressionTypeLinkerHelper.filterOverloadsWithMismatchingParamTypes(arguments, argumentsLength, overloads2ParamsMap);
        if (overloads2ParamsMap.keySet().size() > 0) {
            return JstExpressionTypeLinkerHelper.getRtnTypeFromSingleMtd(mie, JstExpressionTypeLinkerHelper.getBestOverloadFromAllValid(overloads2ParamsMap, arguments));
        }
        return returnType;
    }

    private static boolean checkAllOverloadsRtnTypeTheSame(List<IJstMethod> allOverloads) {
        if (allOverloads == null || allOverloads.size() < 1) {
            return true;
        }
        IJstType prevRtnType = allOverloads.get(0).getRtnType();
        for (IJstMethod it : allOverloads) {
            if (prevRtnType == it.getRtnType()) continue;
            return false;
        }
        return true;
    }

    public static void initOverloadsWithCorrectParamSize(List<IJstMethod> overloads, int argumentsLength, Map<IJstMethod, List<JstArg>> overloads2ParamsMap) {
        for (IJstMethod overload : overloads) {
            if (!JstExpressionTypeLinkerHelper.preCheckOverloadParamSize(argumentsLength, overload)) continue;
            overloads2ParamsMap.put(overload, JstExpressionTypeLinkerHelper.paddingParams(overload.getArgs(), argumentsLength));
        }
    }

    private static boolean preCheckOverloadParamSize(int argumentsLength, IJstMethod overload) {
        List parameters = overload.getArgs();
        return parameters.size() <= argumentsLength || parameters.size() == argumentsLength + 1 && ((JstArg)parameters.get(parameters.size() - 1)).isVariable();
    }

    private static void filterOverloadsWithMismatchingParamTypes(List<IExpr> arguments, int argumentsLength, Map<IJstMethod, List<JstArg>> overloads2ParamsMap) {
        int i = 0;
        while (i < argumentsLength) {
            IJstType argumentType = arguments.get(i).getResultType();
            LinkedList<IJstMethod> badOverloads = new LinkedList<IJstMethod>();
            for (Map.Entry<IJstMethod, List<JstArg>> overloadEntry : overloads2ParamsMap.entrySet()) {
                List<JstArg> overloadParams = overloadEntry.getValue();
                IJstType overloadParamType = overloadParams.get(i).getType();
                if (TypeCheckUtil.isAssignable((IJstType)overloadParamType, (IJstType)argumentType)) continue;
                badOverloads.add(overloadEntry.getKey());
            }
            for (IJstMethod invalidKey : badOverloads) {
                overloads2ParamsMap.remove(invalidKey);
            }
            ++i;
        }
    }

    private static IJstType getRtnTypeFromSingleMtd(MtdInvocationExpr mie, IJstMethod mtd) {
        IJstType returnType = null;
        if (mtd.isTypeFactoryEnabled() && (returnType = JstExpressionTypeLinkerHelper.getReturnTypeFormFactoryEnabled(mie, mtd)) != null) {
            return returnType;
        }
        returnType = mtd.getRtnType();
        return JstExpressionTypeLinkerHelper.resolvingFuncReturnType(mie, returnType);
    }

    private static IJstType resolvingFuncReturnType(MtdInvocationExpr mie, IJstType returnType) {
        if (returnType instanceof JstFuncArgAttributedType) {
            int argIndex = ((JstFuncArgAttributedType)returnType).getArgPosition() - 1;
            List args = mie.getArgs();
            if (args.size() > argIndex) {
                returnType = ((IExpr)args.get(argIndex)).getResultType();
            }
        } else if (returnType instanceof JstFuncScopeAttributedType) {
            IExpr scope = mie.getQualifyExpr();
            if (scope != null) {
                returnType = scope.getResultType();
            }
        } else if (returnType instanceof JstMixedType) {
            returnType = JstExpressionTypeLinkerHelper.resolve(mie, (JstMixedType)returnType);
        }
        return returnType;
    }

    private static IJstType resolve(MtdInvocationExpr mie, JstMixedType mixedType) {
        List mTypes = mixedType.getMixedTypes();
        ArrayList<IJstType> resolvedTypes = new ArrayList<IJstType>(mTypes.size());
        boolean needResolve = false;
        for (IJstType mType : mixedType.getMixedTypes()) {
            IJstType resolved;
            if (mType instanceof JstFuncArgAttributedType || mType instanceof JstFuncScopeAttributedType) {
                needResolve = true;
            }
            if ((resolved = JstExpressionTypeLinkerHelper.resolvingFuncReturnType(mie, mType)) == null) continue;
            resolvedTypes.add(resolved);
        }
        if (needResolve && resolvedTypes.size() > 0) {
            mixedType = new JstMixedType(resolvedTypes);
        }
        return mixedType;
    }

    private static ParamMatchingArgCase argMatchingParam(IExpr arg, JstArg param) {
        IJstType parameterType;
        IJstType argumentType = arg.getResultType();
        if (argumentType == (parameterType = param.getType()) || argumentType == null || parameterType == null) {
            return ParamMatchingArgCase.exact;
        }
        if (JstExpressionTypeLinkerHelper.isSubType(parameterType, argumentType)) {
            return ParamMatchingArgCase.subtype;
        }
        if ("proxy".equals(param.getName()) || "Object".equals(parameterType.getName())) {
            return ParamMatchingArgCase.object;
        }
        return ParamMatchingArgCase.implicitConversion;
    }

    private static IJstMethod getBestOverloadFromAllValid(Map<IJstMethod, List<JstArg>> validOverloads2ParamsMap, List<IExpr> arguments) {
        assert (validOverloads2ParamsMap.size() >= 1);
        assert (arguments.size() >= 0);
        if (validOverloads2ParamsMap.size() == 1) {
            return validOverloads2ParamsMap.keySet().iterator().next();
        }
        TreeSet<OverloadBestMatchCandidate> scoreSortedOverloads = new TreeSet<OverloadBestMatchCandidate>();
        HashSet<OverloadBestMatchCandidate> filteredOverloads = new HashSet<OverloadBestMatchCandidate>();
        for (Map.Entry<IJstMethod, List<JstArg>> scoreEntry : validOverloads2ParamsMap.entrySet()) {
            IJstMethod key = scoreEntry.getKey();
            List<JstArg> value = scoreEntry.getValue();
            if (key.getArgs().size() < value.size()) {
                filteredOverloads.add(new OverloadBestMatchCandidate(key, value, arguments));
                continue;
            }
            scoreSortedOverloads.add(new OverloadBestMatchCandidate(key, value, arguments));
        }
        if (scoreSortedOverloads.size() == 0) {
            scoreSortedOverloads.addAll(filteredOverloads);
        }
        return ((OverloadBestMatchCandidate)scoreSortedOverloads.iterator().next()).getMethod();
    }

    private static List<JstArg> paddingParams(List<JstArg> params, int argumentsLength) {
        int paramsLength = params.size();
        if (paramsLength >= argumentsLength) {
            return params;
        }
        JstArg lastParam = paramsLength > 0 ? params.get(paramsLength - 1) : null;
        ArrayList<JstArg> paddingParams = new ArrayList<JstArg>(argumentsLength);
        paddingParams.addAll(params);
        JstArg paddingParam = lastParam != null && lastParam.isVariable() ? new JstArg(lastParam.getType(), "proxy", true) : new JstArg((IJstType)JstCache.getInstance().getType("Object"), "proxy", false);
        int i = paramsLength;
        while (i < argumentsLength) {
            paddingParams.add(paddingParam);
            ++i;
        }
        return paddingParams;
    }

    public static List<VarTable> getVarTablesBottomUp(IJstNode scopedVars) {
        JstBlock block;
        LinkedList<VarTable> varTables = new LinkedList<VarTable>();
        if (scopedVars instanceof IJstMethod) {
            block = ((IJstMethod)scopedVars).getBlock();
            JstExpressionTypeLinkerHelper.addVarTableRecursively(varTables, block.getVarTable());
        } else if (scopedVars instanceof FuncExpr) {
            block = ((FuncExpr)scopedVars).getFunc().getBlock();
            JstExpressionTypeLinkerHelper.addVarTableRecursively(varTables, block.getVarTable());
        }
        IJstNode parent = scopedVars;
        while (parent != null) {
            IJstNode grandParent;
            if (parent instanceof JstBlock && ((grandParent = parent.getParentNode()) instanceof IJstMethod || grandParent instanceof FuncExpr || grandParent instanceof JstType)) {
                JstExpressionTypeLinkerHelper.addVarTableRecursively(varTables, ((JstBlock)parent).getVarTable());
            }
            parent = parent.getParentNode();
        }
        return varTables;
    }

    private static void addVarTableRecursively(List<VarTable> varTables, VarTable varTable) {
        varTables.add(varTable);
        if (varTable instanceof TopLevelVarTable) {
            TopLevelVarTable topLevelVarTable = (TopLevelVarTable)varTable;
            for (VarTable linkedVarTable : topLevelVarTable.getLinkedVarTables()) {
                JstExpressionTypeLinkerHelper.addVarTableRecursively(varTables, linkedVarTable);
            }
        }
    }

    public static VarTable getVarTable(IJstNode scopedVars) {
        IJstNode parent = scopedVars;
        while (parent != null) {
            JstBlock block;
            IJstNode grandParent = parent.getParentNode();
            if (parent instanceof JstBlock && (grandParent instanceof JstMethod || grandParent instanceof FuncExpr || grandParent instanceof JstType)) {
                return ((JstBlock)parent).getVarTable();
            }
            if (parent instanceof WithStmt && grandParent instanceof BlockStmt) {
                return ((BlockStmt)grandParent).getBody().getVarTable();
            }
            if (parent instanceof JstArg && grandParent instanceof JstMethod && (block = ((JstMethod)grandParent).getBlock()) != null) {
                return block.getVarTable();
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    public static IJstType findType(JsVariantType jsTypingMeta) {
        ArrayList<IJstType> types = new ArrayList<IJstType>(3);
        for (JsTypingMeta t : jsTypingMeta.getTypes()) {
            if (!(t instanceof JsType)) continue;
            types.add(JstExpressionTypeLinkerHelper.findType((JsType)t));
        }
        return new JstVariantType(types);
    }

    public static IJstType findType(JsType typing) {
        JstType jstType = JstCache.getInstance().getType(typing.getType());
        if (typing.isTypeRef()) {
            jstType = JstTypeHelper.getJstTypeRefType((IJstType)jstType);
        }
        return jstType;
    }

    public static boolean checkConstructorCalls(JstExpressionBindingResolver resolver, IJstVisitor revisitor, MtdInvocationExpr mie, JstIdentifier methodId, IJstType mtdBindingType) {
        if (mtdBindingType instanceof JstTypeRefType && !mtdBindingType.isFType()) {
            JstTypeRefType type = (JstTypeRefType)mtdBindingType;
            IJstType boundType = JstExpressionTypeLinkerHelper.bindConstructor(resolver, revisitor, type, methodId, mie.getArgs());
            mie.setResultType(boundType);
            return true;
        }
        if ("this".equals(methodId.getName())) {
            JstTypeRefType type = new JstTypeRefType(mtdBindingType);
            JstExpressionTypeLinkerHelper.bindConstructor(resolver, revisitor, type, methodId, mie.getArgs());
            mie.setResultType(type.getType());
            return true;
        }
        if ("base".equals(methodId.getName()) && mie.getMethodIdentifier() instanceof FieldAccessExpr) {
            JstTypeRefType type = new JstTypeRefType(mtdBindingType);
            JstExpressionTypeLinkerHelper.bindConstructor(resolver, revisitor, type, methodId, mie.getArgs());
            ((FieldAccessExpr)mie.getMethodIdentifier()).setType((IJstType)type);
            mie.setResultType(type.getType());
            return true;
        }
        return mie.getParentNode() instanceof ObjCreationExpr;
    }

    public static void bindIdentifier(JstExpressionBindingResolver resolver, JstExpressionTypeLinker.ScopeFrame scope, JstIdentifier identifier, String name, IJstNode bound, IJstType symbolType, boolean override, GroupInfo groupInfo) {
        if (override || identifier.getJstBinding() == null) {
            identifier.setJstBinding(bound);
            JstExpressionTypeLinkerHelper.setExprType(resolver, (IExpr)identifier, symbolType, groupInfo);
            JstExpressionTypeLinkerHelper.addToSymbolMap(scope, name, new JstExpressionTypeLinker.LinkerSymbolInfo(name, symbolType, bound, null));
        }
    }

    protected static void addToSymbolMap(JstExpressionTypeLinker.ScopeFrame scope, String symbolName, JstExpressionTypeLinker.LinkerSymbolInfo globalNativeType) {
        if (globalNativeType.getBinding() != null && globalNativeType.getType() != null) {
            scope.addSymbolBinding(symbolName, globalNativeType);
        }
    }

    public static final IJstType bindConstructor(JstExpressionBindingResolver resolver, IJstVisitor revisitor, JstTypeRefType type, JstIdentifier methodId, List<IExpr> arguments) {
        IJstMethod constructor = type.getConstructor();
        if (constructor == null) {
            return null;
        }
        methodId.setJstBinding((IJstNode)constructor);
        List paramTypes = type.getParamTypes();
        List<IJstMethod> matchingMtds = JstExpressionTypeLinkerHelper.getMatchingMtdFromOverloads(constructor, arguments);
        if (matchingMtds.size() == 1) {
            IJstMethod matchingMtd = matchingMtds.iterator().next();
            List parameters = matchingMtd.getArgs();
            int i = 0;
            int len = arguments.size();
            while (i < len) {
                IExpr argExpr = arguments.get(i);
                if (parameters.size() > i && JstExpressionTypeLinkerHelper.doesExprRequireResolve(argExpr)) {
                    JstExpressionTypeLinkerHelper.doExprTypeResolve(resolver, revisitor, argExpr, ((JstArg)parameters.get(i)).getTypes());
                }
                methodId.setJstBinding((IJstNode)matchingMtd);
                ++i;
            }
            if (paramTypes.size() > 0) {
                JstTypeWithArgs withArgs = new JstTypeWithArgs(type.getReferencedNode());
                IJstMethod matchingConstructor = JstExpressionTypeLinkerHelper.look4MatchingConstructor(constructor, paramTypes, arguments);
                List matchingParameters = matchingConstructor.getArgs();
                int i2 = 0;
                int len2 = matchingParameters.size();
                while (i2 < len2) {
                    JstArg param = (JstArg)matchingParameters.get(i2);
                    if (paramTypes.contains(param.getType()) && arguments.size() > i2) {
                        IExpr arg = arguments.get(i2);
                        if (JstExpressionTypeLinkerHelper.doesExprRequireResolve(arg)) {
                            JstExpressionTypeLinkerHelper.doExprTypeResolve(resolver, revisitor, arg, ((JstArg)matchingParameters.get(i2)).getType());
                        }
                        withArgs.addArgType(arg.getResultType());
                    }
                    ++i2;
                }
                return withArgs;
            }
            return type.getReferencedNode();
        }
        return null;
    }

    private static IJstMethod look4MatchingConstructor(IJstMethod constructor, List<JstParamType> paramTypes, List<IExpr> arguments) {
        return constructor;
    }

    public static void bindFieldAccessExpr(JstExpressionBindingResolver resolver, IJstProperty pty, IJstType qualifierType, FieldAccessExpr fae, GroupInfo groupInfo) {
        JstIdentifier fieldId;
        IJstType type = pty.getType();
        if (pty.getType() instanceof JstParamType) {
            type = JstTypeHelper.resolveTypeWithArgs((IJstNode)pty, (IJstType)qualifierType);
        }
        if ((fieldId = fae.getName()) != null) {
            fieldId.setJstBinding((IJstNode)pty);
            fieldId.setType(type);
        }
        JstExpressionTypeLinkerHelper.setExprType(resolver, (IExpr)fae, type, groupInfo);
    }

    public static boolean bindThisMtdInvocationInConstructs(JstExpressionBindingResolver resolver, IJstVisitor revisitor, MtdInvocationExpr mie, IJstType currentType, GroupInfo groupInfo) {
        BaseJstNode parent = mie.getParentNode();
        while (parent != null && !(parent instanceof IJstType) && !(parent instanceof IJstMethod)) {
            if (parent instanceof ObjCreationExpr) {
                return false;
            }
            parent = parent.getParentNode();
        }
        if (JstTypeHelper.isConstructor((IJstNode)parent)) {
            IExpr mtdId = mie.getMethodIdentifier();
            IJstType type = null;
            if (mtdId instanceof JstIdentifier) {
                String mtdName = mtdId.toExprText();
                if (mtdName.equals("base")) {
                    IJstProperty basepty;
                    IExpr qualifier = mie.getQualifyExpr();
                    IJstType resultType = qualifier.getResultType();
                    if (resultType instanceof JstInferredType) {
                        resultType = ((JstInferredType)resultType).getType();
                    }
                    if (resultType == currentType && (basepty = resultType.getProperty("base")) != null) {
                        type = basepty.getType();
                    }
                } else {
                    IJstType resultType = mtdId.getResultType();
                    if (resultType instanceof JstInferredType) {
                        resultType = ((JstInferredType)resultType).getType();
                    }
                    if (resultType == currentType) {
                        type = mtdId.getResultType();
                    }
                }
            }
            if (type != null) {
                JstExpressionTypeLinkerHelper.bindMtdInvocations(resolver, revisitor, mie, (IJstNode)type.getConstructor(), groupInfo);
                JstExpressionTypeLinkerHelper.setExprType(resolver, (IExpr)mie, type, groupInfo);
                return true;
            }
        }
        return false;
    }

    public static void bindMtdInvocationExpr(JstExpressionBindingResolver resolver, IJstVisitor revisitor, IJstNode mtd, IJstType qualifierType, MtdInvocationExpr mie, GroupInfo groupInfo) {
        IJstType type = null;
        if (mtd instanceof JstConstructor) {
            type = mtd.getOwnerType();
        } else if (mtd instanceof IJstMethod) {
            type = JstExpressionTypeLinkerHelper.look4ReturnType(resolver, mtd, qualifierType, mie);
        }
        JstExpressionTypeLinkerHelper.bindMtdInvocations(resolver, revisitor, mie, mtd, groupInfo);
        JstExpressionTypeLinkerHelper.setExprType(resolver, (IExpr)mie, type, groupInfo);
    }

    private static IJstType look4ReturnType(JstExpressionBindingResolver resolver, IJstNode mtd, IJstType qualifierType, MtdInvocationExpr mie) {
        IJstType type = JstExpressionTypeLinkerHelper.getBestRtnTypeFromAllOverloadMtds(mie, (IJstMethod)mtd);
        type = JstExpressionTypeLinkerHelper.bindParamTypes(resolver, mtd, mie, qualifierType, type);
        return type;
    }

    public static void bindMtdInvocations(JstExpressionBindingResolver resolver, IJstVisitor revisitor, MtdInvocationExpr mtdExpr, IJstNode mtd, GroupInfo grpInfo) {
        IJstMethod bindMtd;
        List<IJstMethod> matchingMtds;
        IJstNode updateBinding = mtd;
        if (mtd instanceof IJstMethod && (matchingMtds = JstExpressionTypeLinkerHelper.getMatchingMtdFromOverloads(bindMtd = (IJstMethod)mtd, mtdExpr.getArgs())).size() == 1) {
            IJstMethod matchingMtd = matchingMtds.iterator().next();
            List arguments = mtdExpr.getArgs();
            List parameters = matchingMtd.getArgs();
            boolean supportArgTypeExt = matchingMtd.isFuncArgMetaExtensionEnabled();
            IJstMethod extMtd = null;
            if (supportArgTypeExt && mtdExpr.getArgs().size() > 1) {
                List<IJstMethod> matchingJstMtds;
                extMtd = JstExpressionTypeLinkerHelper.bindArgumentMappng(revisitor, grpInfo, matchingMtd, (IExpr)mtdExpr.getArgs().get(0));
                if (extMtd != null && extMtd.isDispatcher() && (matchingJstMtds = JstExpressionTypeLinkerHelper.getMatchingMtdFromOverloads(extMtd, mtdExpr.getArgs())).size() == 1) {
                    extMtd = matchingJstMtds.get(0);
                }
                if (extMtd != null) {
                    parameters = extMtd.getArgs();
                }
            }
            int i = 0;
            int len = arguments.size();
            while (i < len) {
                IExpr argExpr = (IExpr)arguments.get(i);
                if (parameters.size() > i && JstExpressionTypeLinkerHelper.doesExprRequireResolve(argExpr)) {
                    JstExpressionTypeLinkerHelper.doExprTypeResolve(resolver, revisitor, argExpr, ((JstArg)parameters.get(i)).getTypes());
                }
                ++i;
            }
            updateBinding = extMtd != null ? extMtd : matchingMtd;
        }
        if (mtdExpr.getMethodIdentifier() instanceof JstIdentifier) {
            ((JstIdentifier)mtdExpr.getMethodIdentifier()).setJstBinding(updateBinding);
        } else if (mtdExpr.getMethodIdentifier() instanceof FieldAccessExpr) {
            FieldAccessExpr expr = (FieldAccessExpr)mtdExpr.getMethodIdentifier();
            expr.getName().setJstBinding(updateBinding);
        }
    }

    private static IJstMethod bindArgumentMappng(IJstVisitor revisitor, GroupInfo groupInfo, IJstMethod callingMethod, IExpr keyArg) {
        String targetFunc = String.valueOf(callingMethod.getOwnerType().getName()) + (callingMethod.isStatic() ? "::" : ":") + callingMethod.getName().getName();
        FunctionParamsMetaRegistry fmr = FunctionParamsMetaRegistry.getInstance();
        if (fmr.isFuncMetaMappingSupported(targetFunc)) {
            String key = keyArg.toExprText();
            IMetaExtension metaExt = fmr.getExtentedArgBinding(targetFunc, key = JstExpressionTypeLinkerHelper.unquote(key), groupInfo.getGroupName(), groupInfo.getDependentGroups());
            if (metaExt != null) {
                IJstMethod extFunc = metaExt.getMethod();
                JstExpressionTypeLinkerTraversal.accept((IJstNode)extFunc, revisitor);
                IJstMethod resolved = JstExpressionTypeLinkerHelper.unwrapMethod(extFunc);
                return resolved;
            }
        }
        return null;
    }

    private static List<IJstMethod> getMatchingMtdFromOverloads(IJstMethod bindMtd, List<IExpr> arguments) {
        if (!bindMtd.isDispatcher()) {
            return Arrays.asList(bindMtd);
        }
        List overloads = bindMtd.getOverloaded();
        int argumentsLength = arguments.size();
        HashMap<IJstMethod, List<JstArg>> overloads2ParamsMap = new HashMap<IJstMethod, List<JstArg>>(overloads.size());
        JstExpressionTypeLinkerHelper.initOverloadsWithCorrectParamSize(overloads, argumentsLength, overloads2ParamsMap);
        JstExpressionTypeLinkerHelper.filterOverloadsWithMismatchingParamTypesToleratingErrors(arguments, argumentsLength, overloads2ParamsMap);
        if (overloads2ParamsMap.size() > 0) {
            IJstMethod bestMatch = JstExpressionTypeLinkerHelper.getBestOverloadFromAllValid(overloads2ParamsMap, arguments);
            if (bestMatch != null) {
                return Arrays.asList(bestMatch);
            }
            return new ArrayList<IJstMethod>(overloads2ParamsMap.keySet());
        }
        JstExpressionTypeLinkerHelper.initOverloadsWithCorrectParamSize(overloads, argumentsLength, overloads2ParamsMap);
        if (overloads2ParamsMap.size() > 0) {
            return new ArrayList<IJstMethod>(overloads2ParamsMap.keySet());
        }
        return Collections.unmodifiableList(overloads);
    }

    private static void filterOverloadsWithMismatchingParamTypesToleratingErrors(List<IExpr> arguments, int argumentsLength, Map<IJstMethod, List<JstArg>> overloads2ParamsMap) {
        int i = 0;
        while (i < argumentsLength) {
            IJstType argumentType = arguments.get(i).getResultType();
            LinkedList<IJstMethod> badOverloads = new LinkedList<IJstMethod>();
            for (Map.Entry<IJstMethod, List<JstArg>> overloadEntry : overloads2ParamsMap.entrySet()) {
                List<JstArg> overloadParams = overloadEntry.getValue();
                IJstType overloadParamType = overloadParams.get(i).getType();
                if (argumentType == null || overloadParamType == null || "Object".equals(argumentType.getName()) || (argumentType instanceof JstFuncType || argumentType instanceof JstFunctionRefType || "Function".equals(argumentType.getName()) || argumentType.isFType()) && (overloadParamType instanceof JstFuncType || overloadParamType instanceof JstFunctionRefType || "Function".equals(overloadParamType.getName())) || overloadParamType.isFType() || TypeCheckUtil.isAssignable((IJstType)overloadParamType, (IJstType)argumentType)) continue;
                badOverloads.add(overloadEntry.getKey());
            }
            for (IJstMethod invalidKey : badOverloads) {
                overloads2ParamsMap.remove(invalidKey);
            }
            ++i;
        }
    }

    public static void doExprTypeUpdate(JstExpressionBindingResolver resolver, IJstVisitor revisitor, IExpr expr, IJstType type, GroupInfo groupInfo) {
        if (JstExpressionTypeLinkerHelper.doesExprRequireResolve(expr)) {
            JstExpressionTypeLinkerHelper.doExprTypeResolve(resolver, revisitor, expr, type);
        } else {
            JstExpressionTypeLinkerHelper.setExprType(resolver, expr, type, groupInfo);
        }
    }

    public static void doJsCommentMetaUpdate(IJstType resolvedMetaType, IJstNode srcNode) {
        JsCommentMetaNode metaNode = JstExpressionTypeLinkerHelper.getJsCommentMetaNode(srcNode);
        if (metaNode != null) {
            metaNode.setResultType(resolvedMetaType);
        }
    }

    public static void doExprTypeResolve(JstExpressionBindingResolver resolver, IJstVisitor revisitor, IExpr expr, IJstType type) {
        IJstType exprType;
        if (expr instanceof ConditionalExpr) {
            ConditionalExpr condExpr = (ConditionalExpr)expr;
            JstExpressionTypeLinkerHelper.doExprTypeResolve(resolver, revisitor, condExpr.getThenExpr(), type);
            JstExpressionTypeLinkerHelper.doExprTypeResolve(resolver, revisitor, condExpr.getElseExpr(), type);
        }
        if ((exprType = expr.getResultType()) != null) {
            if (exprType instanceof JstDeferredType) {
                ((JstDeferredType)exprType).setResolvedType(type);
            } else if (expr instanceof ObjLiteral && exprType instanceof SynthOlType && type instanceof JstMixedType) {
                JstExpressionTypeLinkerHelper.doObjLiteralAndOTypeBindingsMixedTypes((ObjLiteral)expr, (SynthOlType)exprType, (JstMixedType)type, revisitor);
            } else if (expr instanceof ObjLiteral && exprType instanceof SynthOlType) {
                JstExpressionTypeLinkerHelper.doObjLiteralAndOTypeBindings((ObjLiteral)expr, (SynthOlType)exprType, type, revisitor, null);
            } else if (expr instanceof FuncExpr && exprType instanceof JstFuncType) {
                if (type instanceof JstFuncType) {
                    JstExpressionTypeLinkerHelper.tryDerivingAnonymousFunctionsFromAssignment((FuncExpr)expr, ((JstFuncType)type).getFunction(), true, revisitor);
                } else if (type instanceof JstFunctionRefType) {
                    JstExpressionTypeLinkerHelper.tryDerivingAnonymousFunctionsFromAssignment((FuncExpr)expr, ((JstFunctionRefType)type).getMethodRef(), true, revisitor);
                }
            } else if (expr instanceof JstIdentifier && type.isFType() && !(type instanceof IJstRefType)) {
                ((JstIdentifier)expr).setType((IJstType)JstTypeHelper.getJstTypeRefType((IJstType)type));
            } else if ((expr instanceof ObjCreationExpr || expr instanceof MtdInvocationExpr) && exprType instanceof JstTypeWithArgs && type instanceof JstTypeWithArgs) {
                List inferArgTypes = ((JstTypeWithArgs)exprType).getArgTypes();
                List targetArgTypes = ((JstTypeWithArgs)type).getArgTypes();
                int i = 0;
                int len = targetArgTypes.size();
                while (i < len) {
                    IJstType targetArgType = (IJstType)targetArgTypes.get(i);
                    if (i >= inferArgTypes.size()) {
                        ((JstTypeWithArgs)exprType).addArgType(targetArgType);
                    } else {
                        IJstType inferArgType = (IJstType)inferArgTypes.get(i);
                        if (JstExpressionTypeLinkerHelper.isSubType(targetArgType, inferArgType)) {
                            try {
                                JstExpressionTypeLinkerHelper.replaceArgType((JstTypeWithArgs)exprType, inferArgType, i);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    ++i;
                }
            } else if (expr instanceof JstArrayInitializer && exprType instanceof JstArray && type instanceof JstArray) {
                JstArray exprArray = (JstArray)exprType;
                JstArray trueArray = (JstArray)type;
                if (exprArray.getComponentType() != trueArray.getComponentType()) {
                    ((JstArrayInitializer)expr).setType(trueArray);
                }
            }
        }
    }

    public static void doExprTypeResolve(JstExpressionBindingResolver resolver, IJstVisitor revisitor, IExpr expr, List<IJstType> types) {
        for (IJstType iJstType : types) {
            JstExpressionTypeLinkerHelper.doExprTypeResolve(resolver, revisitor, expr, iJstType);
        }
    }

    private static void replaceArgType(JstTypeWithArgs jstTypeWithArgs, IJstType inferArgType, int i) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field argTypesField = JstTypeWithArgs.class.getField("m_argTypes");
        argTypesField.setAccessible(true);
        List argTypes = (List)argTypesField.get(jstTypeWithArgs);
        if (i < argTypes.size()) {
            argTypes.remove(i);
            argTypes.add(i, inferArgType);
        }
    }

    private static boolean isSubType(IJstType candidateSuperType, IJstType candidateSubType) {
        if (candidateSuperType == candidateSubType) {
            return true;
        }
        for (IJstType inherit : candidateSubType.getExtends()) {
            if (!JstExpressionTypeLinkerHelper.isSubType(candidateSuperType, inherit)) continue;
            return true;
        }
        for (IJstType inherit : candidateSubType.getSatisfies()) {
            if (!JstExpressionTypeLinkerHelper.isSubType(candidateSuperType, inherit)) continue;
            return true;
        }
        return false;
    }

    private static void doObjLiteralAndOTypeBindingsMixedTypes(ObjLiteral objLiteral, SynthOlType synthOlType, JstMixedType mtype, IJstVisitor revisitor) {
        for (IJstType type : mtype.getMixedTypes()) {
            if (type instanceof JstAttributedType) {
                JstAttributedType atype = (JstAttributedType)type;
                IJstOType otype = atype.getOType(atype.getAttributeName());
                JstExpressionTypeLinkerHelper.doObjLiteralAndOTypeBindings(objLiteral, synthOlType, (IJstType)otype, revisitor, mtype);
                continue;
            }
            if (!(type instanceof JstObjectLiteralType)) continue;
            JstExpressionTypeLinkerHelper.doObjLiteralAndOTypeBindings(objLiteral, synthOlType, (IJstType)((IJstOType)type), revisitor, null);
        }
    }

    static void doObjLiteralAndOTypeBindings(ObjLiteral objLiteral, SynthOlType synthOlType, IJstType otype, IJstVisitor revisitor, JstMixedType mtype) {
        IJstType override = JstExpressionTypeLinkerHelper.resolveOtype(objLiteral);
        if (otype instanceof JstAttributedType) {
            JstAttributedType atype = (JstAttributedType)otype;
            otype = atype.getOType(atype.getAttributeName());
        }
        if (override != null) {
            otype = override;
        }
        if (otype != null && otype instanceof SynthOlType) {
            objLiteral.setJstType(otype);
        } else if (synthOlType != null && otype != null && otype instanceof JstObjectLiteralType) {
            synthOlType.addResolvedOType(otype);
        } else if (synthOlType != null && otype != null && otype instanceof JstMixedType) {
            JstMixedType mixed = (JstMixedType)otype;
            for (IJstType type : mixed.getMixedTypes()) {
                IJstOType mixedOType = null;
                if (type instanceof JstAttributedType) {
                    JstAttributedType atype = (JstAttributedType)type;
                    mixedOType = atype.getOType(atype.getAttributeName());
                }
                if (synthOlType == null || mixedOType == null || !(mixedOType instanceof JstObjectLiteralType)) continue;
                synthOlType.addResolvedOType((IJstType)mixedOType);
            }
        } else {
            return;
        }
        for (NV nv : objLiteral.getNVs()) {
            JstIdentifier id = nv.getIdentifier();
            String name = id.getName();
            if (otype == null) continue;
            JstExpressionTypeLinkerHelper.doObjLiteralNameBinding(otype, id, name, mtype);
            IExpr valueExpr = nv.getValue();
            if (valueExpr == null) continue;
            JstExpressionTypeLinkerHelper.doObjLiteralValueBinding(otype, revisitor, name, valueExpr, mtype);
        }
    }

    private static IJstType resolveOtype(ObjLiteral objLiteral) {
        IJstType otype = null;
        OTypeResolverRegistry otypeResolver = OTypeResolverRegistry.getInstance();
        if (objLiteral.getNVs().size() > 0) {
            Set<String> keys = OTypeResolverRegistry.getInstance().getKeys();
            for (String field : keys) {
                NV firstPosition = objLiteral.getNV(field);
                if (firstPosition == null) {
                    return null;
                }
                String key = firstPosition.getName();
                if (!otypeResolver.hasResolver(key) || !((otype = otypeResolver.resolve(key, firstPosition)) instanceof JstAttributedType)) continue;
                JstAttributedType atype = (JstAttributedType)otype;
                otype = JstExpressionTypeLinkerHelper.convertAttributedTypeToOtype(atype);
            }
        }
        return otype;
    }

    private static IJstType convertAttributedTypeToOtype(JstAttributedType atype) {
        IJstOType objLiteralOrFunctionRefType;
        String attributeName = atype.getAttributeName();
        if (atype.isOType() && (objLiteralOrFunctionRefType = atype.getOType(attributeName)) != null) {
            return objLiteralOrFunctionRefType;
        }
        return null;
    }

    private static void doObjLiteralNameBinding(IJstType otype, JstIdentifier id, String name, JstMixedType mtype) {
        if (id.getJstBinding() != null) {
            return;
        }
        IJstProperty oBinding = otype.getProperty(name, false);
        if (oBinding != null) {
            id.setJstBinding((IJstNode)oBinding);
        } else {
            oBinding = otype.getMethod(name, false);
            if (oBinding != null) {
                id.setJstBinding((IJstNode)oBinding);
            }
        }
    }

    private static void doObjLiteralValueBinding(IJstType otype, IJstVisitor revisitor, String name, IExpr valueExpr, JstMixedType mtype) {
        if (valueExpr instanceof JstArrayInitializer) {
            JstArrayInitializer arrayValueExpr = (JstArrayInitializer)valueExpr;
            for (IExpr element : arrayValueExpr.getExprs()) {
                if (!(element instanceof ObjLiteral)) continue;
                JstExpressionTypeLinkerHelper.doObjLiteralAndOTypeBindings((ObjLiteral)element, (SynthOlType)element.getResultType(), otype, revisitor, mtype);
            }
        }
        if (valueExpr instanceof FuncExpr && JstExpressionTypeLinkerHelper.isAnonymousFunction((IJstMethod)((FuncExpr)valueExpr).getFunc())) {
            IJstProperty matchingOTypePty = otype.getProperty(name, false, true);
            JstMethod func = ((FuncExpr)valueExpr).getFunc();
            if (matchingOTypePty != null && func != null && matchingOTypePty.getType() != null) {
                if (matchingOTypePty.getType() instanceof JstFunctionRefType) {
                    JstExpressionTypeLinkerHelper.deriveAnonymousFunction(((JstFunctionRefType)matchingOTypePty.getType()).getMethodRef(), func, matchingOTypePty.getDoc());
                    JstExpressionTypeLinkerTraversal.accept((IJstNode)valueExpr, revisitor);
                } else if (matchingOTypePty.getType() instanceof JstFuncType) {
                    JstExpressionTypeLinkerHelper.deriveAnonymousFunction(((JstFuncType)matchingOTypePty.getType()).getFunction(), func, matchingOTypePty.getDoc());
                    JstExpressionTypeLinkerTraversal.accept((IJstNode)valueExpr, revisitor);
                }
            }
        } else if (valueExpr instanceof ObjLiteral && valueExpr.getResultType() != null && valueExpr.getResultType() instanceof SynthOlType) {
            IJstType propertyType = null;
            IJstProperty prop = otype.getProperty(name, false, true);
            if (prop != null && mtype == null) {
                propertyType = otype.getProperty(name, false, true).getType();
            }
            if (mtype != null) {
                propertyType = JstExpressionTypeLinkerHelper.findLiteralFieldTypeFromMixedType(mtype, name);
            }
            if (propertyType != null) {
                JstExpressionTypeLinkerHelper.doObjLiteralAndOTypeBindings((ObjLiteral)valueExpr, (SynthOlType)valueExpr.getResultType(), propertyType, revisitor, null);
            } else {
                JstExpressionTypeLinkerHelper.doObjLiteralAndOTypeBindings((ObjLiteral)valueExpr, (SynthOlType)valueExpr.getResultType(), otype, revisitor, null);
            }
        }
    }

    private static IJstType findLiteralFieldTypeFromMixedType(JstMixedType mtype, String name) {
        ArrayList<IJstType> types = new ArrayList<IJstType>();
        for (IJstType type : mtype.getMixedTypes()) {
            IJstProperty prop;
            IJstType otype;
            if (!(type instanceof JstAttributedType) || (otype = JstExpressionTypeLinkerHelper.convertAttributedTypeToOtype((JstAttributedType)type)) == null || (prop = otype.getProperty(name, false, true)) == null) continue;
            if (prop.getType() instanceof JstMixedType) {
                types.addAll(((JstMixedType)prop.getType()).getMixedTypes());
                continue;
            }
            types.add(prop.getType());
        }
        if (!types.isEmpty()) {
            return new JstMixedType(types);
        }
        return null;
    }

    public static boolean isFunctionMetaAvailable(FuncExpr funcExpr) {
        for (IJstNode child : funcExpr.getChildren()) {
            JsCommentMetaNode commentMetaNode;
            if (child == null || !(child instanceof JsCommentMetaNode) || (commentMetaNode = (JsCommentMetaNode)child).getJsCommentMetas() == null || commentMetaNode.getJsCommentMetas().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public static JsCommentMetaNode getJsCommentMetaNode(IJstNode node) {
        if (node != null) {
            for (IJstNode child : node.getChildren()) {
                if (child == null || !(child instanceof JsCommentMetaNode)) continue;
                return (JsCommentMetaNode)child;
            }
        }
        return null;
    }

    public static List<IJsCommentMeta> getJsCommentMeta(IJstNode node) {
        JsCommentMetaNode metaNode = JstExpressionTypeLinkerHelper.getJsCommentMetaNode(node);
        return metaNode != null ? metaNode.getJsCommentMetas() : null;
    }

    public static boolean isAnonymousFunction(IJstMethod func) {
        if (func == null || func.getName() == null) {
            return false;
        }
        return "anonymous_function".equals(func.getName().getName());
    }

    public static boolean doesExprRequireResolve(IExpr rhsExpr) {
        if (rhsExpr != null && rhsExpr.getResultType() != null) {
            IJstType resultType = rhsExpr.getResultType();
            return resultType instanceof JstDeferredType || resultType instanceof SynthOlType || resultType instanceof JstFuncType || resultType.isFType() && !(resultType instanceof IJstRefType) || resultType instanceof JstTypeWithArgs || resultType instanceof JstArray;
        }
        return false;
    }

    public static void tryDerivingAnonymousFunctionsFromAssignment(FuncExpr funcExpr, IJstMethod lhsFunc, boolean checkAnonymous, IJstVisitor revisitor) {
        JstMethod func = funcExpr.getFunc();
        if (func != null && (!checkAnonymous || checkAnonymous && JstExpressionTypeLinkerHelper.isAnonymousFunction((IJstMethod)func)) && func instanceof JstMethod) {
            JstExpressionTypeLinkerHelper.deriveAnonymousFunction(lhsFunc, func, func.getDoc());
            JstExpressionTypeLinkerTraversal.accept((IJstNode)func, revisitor);
        }
    }

    private static JstFuncType getFakeFunc() {
        if (s_fakeFunc == null) {
            JstMethod method = new JstMethod(new JstArg[]{new JstArg((IJstType)JstCache.getInstance().getType("Object"), "p", true)});
            s_fakeFunc = new JstFuncType((IJstMethod)method);
        }
        return s_fakeFunc;
    }

    public static void tryDerivingAnonymousFunctionsFromParam(MtdInvocationExpr mie, IJstNode mtdBinding, IJstVisitor revisitor, GroupInfo groupInfo) {
        if (mtdBinding != null && mie != null && mtdBinding instanceof IJstMethod) {
            IJstMethod callingMethod = (IJstMethod)mtdBinding;
            List arguments = mie.getArgs();
            if (callingMethod != null && arguments != null) {
                boolean supportArgTypeExt = callingMethod.isFuncArgMetaExtensionEnabled();
                List<JstFuncType> paramTypes = JstExpressionTypeLinkerHelper.getFilteredParamTypes(callingMethod, arguments.size());
                int paramLen = paramTypes.size();
                int argLen = arguments.size();
                if (supportArgTypeExt && paramLen >= 2 && argLen >= 2 && paramTypes.get(1) == null && arguments.get(1) instanceof FuncExpr) {
                    paramTypes.set(1, JstExpressionTypeLinkerHelper.getFakeFunc());
                }
                int paramIdx = 0;
                int argIdx = 0;
                while (paramIdx < paramLen && argIdx < argLen) {
                    IExpr arg;
                    JstFuncType paramType = paramTypes.get(paramIdx);
                    if (paramType != null && (arg = (IExpr)arguments.get(argIdx)) instanceof FuncExpr) {
                        JstExpressionTypeLinkerHelper.processFunctionExpression(mie, revisitor, groupInfo, callingMethod, arguments, supportArgTypeExt, paramIdx, paramType, arg);
                    }
                    ++paramIdx;
                    ++argIdx;
                }
            }
        }
    }

    private static void processFunctionExpression(MtdInvocationExpr mie, IJstVisitor revisitor, GroupInfo groupInfo, IJstMethod callingMethod, List<IExpr> arguments, boolean supportArgTypeExt, int paramIdx, JstFuncType paramType, IExpr arg) {
        FuncExpr funcArg = (FuncExpr)arg;
        JstMethod func = funcArg.getFunc();
        if (func != null && JstExpressionTypeLinkerHelper.isAnonymousFunction((IJstMethod)func) && func instanceof JstMethod) {
            IJstType qualiferType;
            IExpr keyArg;
            if (paramIdx == 1 && supportArgTypeExt && (keyArg = arguments.get(0)) instanceof JstLiteral && (qualiferType = mie.getQualifyExpr().getResultType()) != null) {
                if (qualiferType instanceof IJstRefType) {
                    qualiferType = ((IJstRefType)qualiferType).getReferencedNode();
                }
                String targetFunc = String.valueOf(qualiferType.getName()) + (callingMethod.isStatic() ? "::" : ":") + callingMethod.getName().getName();
                FunctionMetaRegistry fmr = FunctionMetaRegistry.getInstance();
                if (fmr.isFuncMetaMappingSupported(targetFunc)) {
                    IJstMethod extFunc;
                    String key = ((JstLiteral)keyArg).toString();
                    IMetaExtension metaExt = fmr.getExtentedArgBinding(targetFunc, key = JstExpressionTypeLinkerHelper.unquote(key), groupInfo.getGroupName(), groupInfo.getDependentGroups());
                    if (metaExt != null && (extFunc = metaExt.getMethod()) != null) {
                        JstExpressionTypeLinkerTraversal.accept((IJstNode)extFunc, revisitor);
                        IJstMethod resolved = JstExpressionTypeLinkerHelper.unwrapMethod(extFunc);
                        if (resolved != null) {
                            paramType = new JstFuncType(JstExpressionTypeLinkerHelper.unwrapMethod(extFunc));
                        }
                    }
                }
            }
            JstExpressionTypeLinkerHelper.deriveAnonymousFunction(paramType, func, func.getDoc());
            JstExpressionTypeLinkerTraversal.accept((IJstNode)func, revisitor);
        }
    }

    private static IJstMethod unwrapMethod(IJstMethod extFunc) {
        if (extFunc instanceof JstPotentialOtypeMethod) {
            return ((JstPotentialOtypeMethod)extFunc).getResolvedOtypeMethod();
        }
        if (extFunc instanceof JstPotentialAttributedMethod) {
            return ((JstPotentialAttributedMethod)extFunc).getResolvedAttributedMethod();
        }
        return extFunc;
    }

    private static String unquote(String val) {
        if (val.startsWith("\"") && val.endsWith("\"") || val.startsWith("'") && val.endsWith("'")) {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    private static List<JstFuncType> getFilteredParamTypes(IJstMethod callingMethod, int argumentsLength) {
        ArrayList<JstFuncType> filteredParamTypes;
        block19: {
            block18: {
                filteredParamTypes = new ArrayList<JstFuncType>(argumentsLength);
                if (callingMethod.isDispatcher()) break block18;
                List parameters = callingMethod.getArgs();
                int paramSize = parameters.size();
                int i = 0;
                int len = paramSize;
                while (i < len && i < argumentsLength) {
                    JstArg param = (JstArg)parameters.get(i);
                    if (param != null) {
                        JstFuncType funcType = JstExpressionTypeLinkerHelper.getFilteredFuncType(param.getTypes());
                        filteredParamTypes.add(funcType);
                    }
                    ++i;
                }
                if (argumentsLength <= paramSize || paramSize <= 0) break block19;
                JstArg lastParam = (JstArg)parameters.get(paramSize - 1);
                if (lastParam.isVariable()) {
                    JstFuncType lastParamFuncType = JstExpressionTypeLinkerHelper.getFilteredFuncType(lastParam.getTypes());
                    int i2 = paramSize;
                    while (i2 < argumentsLength) {
                        filteredParamTypes.add(lastParamFuncType);
                        ++i2;
                    }
                } else {
                    int i3 = paramSize;
                    while (i3 < argumentsLength) {
                        filteredParamTypes.add(null);
                        ++i3;
                    }
                }
                break block19;
            }
            List overloads = callingMethod.getOverloaded();
            int i = 0;
            while (i < argumentsLength) {
                JstFuncType filteredFuncType = null;
                int j = 0;
                int len = overloads.size();
                while (j < len) {
                    JstArg lastParam;
                    IJstMethod overload = (IJstMethod)overloads.get(j);
                    List overloadParams = overload.getArgs();
                    int overloadParamSize = overloadParams.size();
                    if (overloadParamSize > i) {
                        JstArg overloadParam = (JstArg)overloadParams.get(i);
                        if (overloadParam != null && overloadParam.getType() instanceof JstFuncType) {
                            if (filteredFuncType == null) {
                                filteredFuncType = (JstFuncType)overloadParam.getType();
                            } else if (!JstExpressionTypeLinkerHelper.isEqualFuncType(filteredFuncType, (JstFuncType)overloadParam.getType())) {
                                filteredFuncType = null;
                                break;
                            }
                        }
                    } else if (overloadParamSize > 0 && (lastParam = (JstArg)overloadParams.get(overloadParamSize - 1)) != null && lastParam.isVariable() && lastParam.getType() instanceof JstFuncType) {
                        if (filteredFuncType == null) {
                            filteredFuncType = (JstFuncType)lastParam.getType();
                        } else if (!JstExpressionTypeLinkerHelper.isEqualFuncType(filteredFuncType, (JstFuncType)lastParam.getType())) {
                            filteredFuncType = null;
                            break;
                        }
                    }
                    ++j;
                }
                filteredParamTypes.add(filteredFuncType);
                ++i;
            }
        }
        return filteredParamTypes;
    }

    private static JstFuncType getFilteredFuncType(List<IJstType> types) {
        if (types == null || types.isEmpty()) {
            return null;
        }
        JstFuncType funcType = null;
        for (IJstType type : types) {
            if (type == null || !(type instanceof JstFuncType)) continue;
            if (funcType == null) {
                funcType = (JstFuncType)type;
                continue;
            }
            if (JstExpressionTypeLinkerHelper.isEqualFuncType(funcType, (JstFuncType)type)) continue;
            return null;
        }
        return funcType;
    }

    private static boolean isEqualFuncType(JstFuncType func1, JstFuncType func2) {
        if (func1 == null || func2 == null) {
            return false;
        }
        IJstMethod f1 = func1.getFunction();
        IJstMethod f2 = func2.getFunction();
        if (f1 == null || f2 == null) {
            return false;
        }
        if (!f1.getRtnType().toString().equals(f2.getRtnType().toString())) {
            return false;
        }
        return f1.getArgs().toString().equals(f2.getArgs().toString());
    }

    public static void tryDerivingAnonymousFunctionsFromReturn(RtnStmt rtnStmt, IJstNode mtdBinding, IJstVisitor revisitor) {
        Set<IJstType> returnTypes;
        if (mtdBinding != null && rtnStmt != null && mtdBinding instanceof IJstMethod && (returnTypes = JstExpressionTypeLinkerHelper.getDedupedReturnTypes((IJstMethod)mtdBinding)).size() == 1) {
            FuncExpr funcArg;
            JstMethod func;
            IExpr rtnExpr = rtnStmt.getExpression();
            IJstType rtnType = returnTypes.iterator().next();
            if (rtnType instanceof JstFuncType && rtnExpr instanceof FuncExpr && (func = (funcArg = (FuncExpr)rtnExpr).getFunc()) != null && JstExpressionTypeLinkerHelper.isAnonymousFunction((IJstMethod)func) && func instanceof JstMethod) {
                JstExpressionTypeLinkerHelper.deriveAnonymousFunction((JstFuncType)rtnType, func, func.getDoc());
                JstExpressionTypeLinkerTraversal.accept((IJstNode)func, revisitor);
            }
        }
    }

    private static Set<IJstType> getDedupedReturnTypes(IJstMethod mtd) {
        HashSet<IJstType> returnTypes = new HashSet<IJstType>(8);
        if (mtd.isDispatcher()) {
            for (IJstMethod overload : mtd.getOverloaded()) {
                returnTypes.add(overload.getRtnType());
            }
        } else {
            returnTypes.add(mtd.getRtnType());
        }
        return returnTypes;
    }

    private static void deriveAnonymousFunction(JstFuncType functionDefType, JstMethod anonymousFunction, IJstDoc doc) {
        IJstMethod paramFunction = functionDefType.getFunction();
        JstExpressionTypeLinkerHelper.deriveAnonymousFunction(paramFunction, anonymousFunction, doc);
    }

    private static void deriveAnonymousFunction(IJstMethod paramFunction, JstMethod anonymousFunction, IJstDoc doc) {
        block7: {
            IJstType paramFunctionRtnType;
            block6: {
                if (anonymousFunction == paramFunction) {
                    return;
                }
                paramFunctionRtnType = paramFunction.getRtnType();
                anonymousFunction.setRtnType(paramFunctionRtnType);
                anonymousFunction.setReturnOptional(paramFunction.isReturnTypeOptional());
                if (paramFunction instanceof JstMethod) {
                    ((JstMethod)paramFunction).setDoc(doc);
                }
                if (paramFunction.isDispatcher()) break block6;
                List params = paramFunction.getArgs();
                List inferParams = anonymousFunction.getArgs();
                JstExpressionTypeLinkerHelper.deriveAnonymousFunctionParams(params, inferParams, true);
                if (!anonymousFunction.isDispatcher()) break block7;
                for (IJstMethod anonymousFunctionOverload : anonymousFunction.getOverloaded()) {
                    JstExpressionTypeLinkerHelper.deriveAnonymousFunctionOverload(anonymousFunctionOverload, inferParams, paramFunctionRtnType);
                }
                break block7;
            }
            List inferParams = anonymousFunction.getArgs();
            boolean firstOverload = true;
            for (IJstMethod paramFunctionOverload : JstExpressionTypeLinkerHelper.sortByNumberOfParams(paramFunction)) {
                List params = paramFunctionOverload.getArgs();
                JstExpressionTypeLinkerHelper.deriveAnonymousFunctionParams(params, inferParams, firstOverload);
                firstOverload = false;
            }
            if (anonymousFunction.isDispatcher()) {
                for (IJstMethod anonymousFunctionOverload : anonymousFunction.getOverloaded()) {
                    JstExpressionTypeLinkerHelper.deriveAnonymousFunctionOverload(anonymousFunctionOverload, inferParams, paramFunctionRtnType);
                }
            }
        }
    }

    private static List<IJstMethod> sortByNumberOfParams(IJstMethod paramFunction) {
        ArrayList<IJstMethod> overloads = new ArrayList<IJstMethod>(paramFunction.getOverloaded());
        ArrayList<IJstMethodSortable> sorting = new ArrayList<IJstMethodSortable>(overloads.size());
        for (IJstMethod overload : overloads) {
            sorting.add(new IJstMethodSortable(overload));
        }
        Collections.sort(sorting);
        overloads.clear();
        for (IJstMethodSortable sort : sorting) {
            overloads.add(sort.getMethod());
        }
        return overloads;
    }

    private static void deriveAnonymousFunctionOverload(IJstMethod anonymousFunctionOverload, List<JstArg> inferParams, IJstType paramFunctionRtnType) {
        List anonymousFunctionOverloadParams = anonymousFunctionOverload.getArgs();
        Iterator anonymousFunctionOverloadParamsIt = anonymousFunctionOverloadParams.iterator();
        Iterator<JstArg> inferParamsIt = inferParams.iterator();
        while (anonymousFunctionOverloadParamsIt.hasNext() && inferParamsIt.hasNext()) {
            JstArg anonymousFunctionOverloadParam = (JstArg)anonymousFunctionOverloadParamsIt.next();
            JstArg inferParam = inferParamsIt.next();
            anonymousFunctionOverloadParam.clearTypes();
            anonymousFunctionOverloadParam.addTypes(inferParam.getTypes());
        }
        if (anonymousFunctionOverload instanceof JstMethod) {
            ((JstMethod)anonymousFunctionOverload).setRtnType(paramFunctionRtnType);
        }
    }

    private static void deriveAnonymousFunctionParams(List<JstArg> params, List<JstArg> inferParams, boolean clearTypes) {
        if (params != null && inferParams != null) {
            int paramIdx = 0;
            int paramLen = params.size();
            int inferParamLen = inferParams.size();
            while (paramIdx < paramLen && paramIdx < inferParamLen) {
                JstArg param = params.get(paramIdx);
                JstArg inferParam = inferParams.get(paramIdx);
                ArrayList inferParamTypes = new ArrayList(param.getTypes());
                if (clearTypes) {
                    inferParam.clearTypes();
                }
                inferParam.addTypes(inferParamTypes);
                ++paramIdx;
            }
        }
    }

    public static boolean isStaticRef(IJstType qualifierType) {
        boolean isStatic = qualifierType instanceof IJstRefType || qualifierType.isFType();
        return isStatic;
    }

    public static void setExprType(JstExpressionBindingResolver resolver, IExpr expr, IJstType type, GroupInfo groupInfo) {
        IJstType realType = type instanceof JstAttributedType || type instanceof JstFuncType ? type : JstExpressionTypeLinkerHelper.getBindedJstType(type);
        realType = JstExpressionTypeLinkerHelper.getCorrectType(resolver, realType, groupInfo);
        if (expr instanceof JstIdentifier) {
            JstIdentifier identifier = (JstIdentifier)expr;
            identifier.setType(realType);
        } else if (expr instanceof FieldAccessExpr) {
            FieldAccessExpr identifier = (FieldAccessExpr)expr;
            identifier.setType(realType);
        } else if (expr instanceof MtdInvocationExpr) {
            MtdInvocationExpr mtdExpr = (MtdInvocationExpr)expr;
            mtdExpr.setResultType(realType);
        } else if (expr instanceof ArrayAccessExpr) {
            ArrayAccessExpr arrayAccessExpr = (ArrayAccessExpr)expr;
            arrayAccessExpr.setType(realType);
        }
    }

    public static IJstType getBindedJstType(IJstType type) {
        if (type instanceof JstTypeWithArgs || type instanceof IJstRefType || type instanceof JstWildcardType) {
            return type;
        }
        return JstExpressionTypeLinkerHelper.getTargetJstType(type);
    }

    public static IJstType getTargetJstType(IJstType type) {
        while (type instanceof JstProxyType && !(type instanceof IInferred) && !(type instanceof JstParamType)) {
            type = ((JstProxyType)type).getType();
        }
        return type;
    }

    public static IJstType getCorrectType(JstExpressionBindingResolver resolver, IJstType type, GroupInfo groupInfo) {
        if (type == null) {
            return null;
        }
        if (type instanceof JstMixedType) {
            for (IJstType mixedType : ((JstMixedType)type).getMixedTypes()) {
                JstExpressionTypeLinkerHelper.getCorrectType(resolver, mixedType, groupInfo);
            }
            return type;
        }
        if (type instanceof JstAttributedType) {
            IJstNode rtnBinding = JstExpressionTypeLinkerHelper.look4ActualBinding(resolver, type, groupInfo);
            if (rtnBinding instanceof IJstOType && rtnBinding != type) {
                return (IJstOType)rtnBinding;
            }
            if (rtnBinding instanceof JstProxyMethod) {
                return new JstFuncType((IJstMethod)((JstProxyMethod)rtnBinding));
            }
        } else if (type instanceof JstTypeRefType) {
            IJstType target = ((JstTypeRefType)type).getReferencedNode();
            IJstType extended = JstExpressionTypeLinkerHelper.getExtendedType(target, groupInfo);
            if (extended != target) {
                return new JstTypeRefType(extended);
            }
        } else if (type instanceof JstFuncType) {
            JstExpressionTypeLinkerHelper.updateFunctionType((JstFuncType)type, groupInfo);
        }
        if (!(type instanceof JstType)) {
            return type;
        }
        JstType jstType = (JstType)type;
        if (!jstType.getStatus().isPhantom()) {
            if (jstType instanceof JstArray) {
                JstExpressionTypeLinkerHelper.updateArrayType((JstArray)jstType, groupInfo);
            } else if (jstType.isFType() || jstType instanceof JstFunctionRefType) {
                JstExpressionTypeLinkerHelper.updateFunctionType(jstType, groupInfo);
            }
            return JstExpressionTypeLinkerHelper.getExtendedType((IJstType)jstType, groupInfo);
        }
        JstType typeInCache = JstCache.getInstance().getType(jstType.getName());
        if (typeInCache != null) {
            if (typeInCache instanceof JstArray) {
                JstExpressionTypeLinkerHelper.updateArrayType((JstArray)typeInCache, groupInfo);
            } else if (jstType.isFType() || jstType instanceof JstFunctionRefType) {
                JstExpressionTypeLinkerHelper.updateFunctionType(jstType, groupInfo);
            }
            return JstExpressionTypeLinkerHelper.getExtendedType((IJstType)typeInCache, groupInfo);
        }
        return JstExpressionTypeLinkerHelper.getExtendedType((IJstType)jstType, groupInfo);
    }

    public static IJstType getExtendedType(IJstType targetType, GroupInfo groupInfo) {
        if (targetType == null || targetType instanceof JstExtendedType) {
            return targetType;
        }
        if (targetType instanceof JstArray || targetType instanceof JstVariantType || targetType instanceof JstMixedType) {
            return targetType;
        }
        String typeName = targetType.getName();
        TypeExtensionRegistry ter = TypeExtensionRegistry.getInstance();
        if (groupInfo != null && !ter.isNonExtendedType(typeName, groupInfo.getGroupName())) {
            ArrayList<String> baseTypes = new ArrayList<String>();
            Object base = targetType.getExtend();
            while (base != null) {
                baseTypes.add(base.getName());
                base = base != base.getExtend() ? base.getExtend() : null;
            }
            List<String> extensions = ter.getExtension(typeName, baseTypes, groupInfo.getGroupName(), groupInfo.getDependentGroups());
            if (extensions != null && extensions.size() > 0) {
                ArrayList<JstType> extTypes = new ArrayList<JstType>(extensions.size());
                for (String extName : extensions) {
                    JstType extType = JstCache.getInstance().getType(extName);
                    if (extType == null) continue;
                    extTypes.add(extType);
                }
                return new JstExtendedType(targetType, extTypes);
            }
        }
        return targetType;
    }

    public static String getFullName(MtdInvocationExpr mie) {
        if (mie.getMethodIdentifier() == null) {
            return "";
        }
        IExpr qualifier = mie.getQualifyExpr();
        String fullName = mie.getMethodIdentifier().toExprText();
        if (qualifier != null) {
            fullName = String.valueOf(qualifier.toExprText()) + "." + fullName;
        }
        return fullName;
    }

    public static JstIdentifier getName(IExpr expr) {
        JstIdentifier name = null;
        if (expr instanceof MtdInvocationExpr) {
            MtdInvocationExpr expr2 = (MtdInvocationExpr)expr;
            IExpr mtdId = expr2.getMethodIdentifier();
            if (mtdId instanceof JstIdentifier) {
                name = (JstIdentifier)mtdId;
            } else if (mtdId instanceof FieldAccessExpr) {
                name = ((FieldAccessExpr)mtdId).getName();
            }
        } else if (expr instanceof FieldAccessExpr) {
            name = ((FieldAccessExpr)expr).getName();
        }
        return name;
    }

    public static IJstType findFullQualifiedType(JstExpressionBindingResolver resolver, String fullName, GroupInfo groupInfo) {
        IJstType type;
        JstTypeSpaceMgr tsMgr = resolver.getController().getJstTypeSpaceMgr();
        ITypeSpace ts = tsMgr.getTypeSpace();
        if (groupInfo == null) {
            return null;
        }
        List typeList = ts.getVisibleType(fullName, ts.getGroup(groupInfo.getGroupName()));
        if (typeList != null && typeList.size() != 0 && (type = (IJstType)typeList.get(0)) != null) {
            return type;
        }
        return null;
    }

    public static void setPackageBindingForQualifier(IExpr expr) {
        if (expr == null) {
            return;
        }
        if (expr instanceof FieldAccessExpr) {
            FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)expr;
            JstIdentifier pkgName = fieldAccessExpr.getName();
            pkgName.setJstBinding((IJstNode)new JstPackage(pkgName.getName()));
            pkgName.setType(null);
            JstExpressionTypeLinkerHelper.setPackageBindingForQualifier(fieldAccessExpr.getExpr());
        } else if (expr instanceof JstIdentifier) {
            JstIdentifier pkgName = (JstIdentifier)expr;
            pkgName.setJstBinding((IJstNode)new JstPackage(pkgName.getName()));
            pkgName.setType(null);
            JstExpressionTypeLinkerHelper.setPackageBindingForQualifier((IExpr)pkgName.getQualifier());
        }
    }

    public static IJstProperty getProperty(IJstType nodeType, String fieldName, boolean isStatic) {
        IJstProperty property = nodeType.getProperty(fieldName, isStatic);
        if (property == null && nodeType.isEnum()) {
            property = nodeType.getEnumValue(fieldName);
        }
        return property;
    }

    public static boolean isEmptyExpr(IExpr fieldName) {
        if (fieldName == null) {
            return true;
        }
        String fieldTxt = fieldName.toExprText();
        return fieldTxt == null || fieldTxt.isEmpty();
    }

    public static boolean isJstIdentifierVisitExcluded(JstIdentifier identifier, IJstNode parent) {
        if (identifier instanceof JstProxyIdentifier) {
            return true;
        }
        if (parent instanceof FieldAccessExpr) {
            IExpr qualifier = ((FieldAccessExpr)parent).getExpr();
            if (qualifier != null && qualifier != identifier) {
                return true;
            }
        } else if (parent instanceof MtdInvocationExpr) {
            MtdInvocationExpr mie = (MtdInvocationExpr)parent;
            IExpr qualifier = mie.getQualifyExpr();
            IExpr mtdIdentifier = mie.getMethodIdentifier();
            if (mtdIdentifier == identifier && qualifier != null && qualifier != identifier) {
                return true;
            }
        } else if (parent instanceof NV ? identifier == ((NV)parent).getIdentifier() : parent instanceof AssignExpr && ((AssignExpr)parent).getLHS() == identifier && parent.getParentNode() instanceof JstVars) {
            return true;
        }
        return false;
    }

    public static boolean isResolveExcluded(JstIdentifier identifier, IJstNode parent) {
        IJstNode grandParent;
        if (parent != null && parent instanceof AssignExpr && (grandParent = parent.getParentNode()) != null && (grandParent instanceof JstVars || grandParent instanceof JstVar)) {
            return identifier == ((AssignExpr)parent).getLHS();
        }
        return identifier.getType() != null && identifier.getType().isFType();
    }

    public static IJstMethod look4EnclosingMethod(IJstNode child) {
        if (child == null) {
            return null;
        }
        if (child instanceof IJstMethod) {
            return (IJstMethod)child;
        }
        return JstExpressionTypeLinkerHelper.look4EnclosingMethod(child.getParentNode());
    }

    public static IJstType processSyntacticCalls(MtdInvocationExpr mie, String methodName, GlobalNativeTypeInfoProvider provider) {
        if (mie.getQualifyExpr() != null && "vjo".equals(mie.getQualifyExpr().toExprText())) {
            List args = mie.getArgs();
            if ("mixin".equals(methodName) && args.size() == 2) {
                IExpr arg1 = (IExpr)args.get(0);
                IExpr arg2 = (IExpr)args.get(1);
                IJstType targetType = arg2.getResultType();
                if (arg1 instanceof SimpleLiteral && arg2 instanceof JstIdentifier && targetType != null) {
                    String mtypeName = ((SimpleLiteral)arg1).getValue();
                    JstType mType = JstCache.getInstance().getType(mtypeName);
                    if (mType != null) {
                        IJstType newType = JstTypeHelper.mixin((IJstType)targetType, (IJstType)mType);
                        String varName = ((JstIdentifier)arg2).getName();
                        JstExpressionTypeLinker.LinkerSymbolInfo info = provider.findTypeInSymbolMap(varName, JstExpressionTypeLinkerHelper.getVarTablesBottomUp((IJstNode)mie));
                        if (info != null) {
                            info.setType(newType);
                            info.setBinding((IJstNode)newType);
                        }
                    }
                }
            }
        } else if ("endType".equals(methodName)) {
            return JstExpressionTypeLinkerHelper.handleVjoEndType(mie);
        }
        return null;
    }

    protected static IJstType handleVjoEndType(MtdInvocationExpr mie) {
        MtdInvocationExpr current = mie;
        IExpr qualifier = mie.getQualifyExpr();
        IExpr mtdId = mie.getMethodIdentifier();
        while (qualifier != null && qualifier instanceof MtdInvocationExpr) {
            MtdInvocationExpr mieQualifier = (MtdInvocationExpr)qualifier;
            IExpr nextQualifier = mieQualifier.getQualifyExpr();
            if (nextQualifier == null) break;
            current = mieQualifier;
            qualifier = nextQualifier;
            mtdId = current.getMethodIdentifier();
        }
        if (qualifier != null && mtdId != null) {
            if ("vjo".equals(qualifier.toExprText()) && "make".equals(mtdId.toExprText())) {
                List args = current.getArgs();
                if (args.size() >= 2) {
                    IJstType resultType;
                    IExpr arg2 = (IExpr)args.get(1);
                    if (arg2 instanceof SimpleLiteral) {
                        String typeName = ((SimpleLiteral)arg2).getValue();
                        JstType parentType = JstCache.getInstance().getType(typeName);
                        if (parentType != null) {
                            IJstType newType = JstTypeHelper.make((IJstType)parentType);
                            return newType;
                        }
                    } else if (arg2 instanceof FieldAccessExpr && (resultType = ((FieldAccessExpr)arg2).getResultType()) instanceof IJstRefType) {
                        IJstType newType = JstTypeHelper.make((IJstType)((IJstRefType)resultType).getReferencedNode());
                        return newType;
                    }
                }
            } else {
                IJstType mtdResultType = mie.getQualifyExpr().getResultType();
                if (mtdResultType != null && mtdResultType.getMethod("endType") != null) {
                    mtdResultType = mtdResultType.getMethod("endType").getRtnType();
                }
                if (mtdResultType != null && mtdResultType.getPackage() != null && "VjoSelfDescribed".equals(mtdResultType.getPackage().getGroupName()) && !(mtdResultType instanceof IJstRefType)) {
                    return JstTypeHelper.getJstTypeRefType((IJstType)mtdResultType);
                }
            }
        }
        return null;
    }

    public static IJstType getNativeArrayJstType(JstExpressionBindingResolver resolver) {
        return JstExpressionTypeLinkerHelper.getNativeTypeFromTS(resolver, "Array");
    }

    public static IJstType getNativeNumberJstType(JstExpressionBindingResolver resolver) {
        return JstExpressionTypeLinkerHelper.getNativeTypeFromTS(resolver, "Number");
    }

    public static IJstType getNativeStringJstType(JstExpressionBindingResolver resolver) {
        return JstExpressionTypeLinkerHelper.getNativeTypeFromTS(resolver, "String");
    }

    public static IJstType getNativeObjectJstType(JstExpressionBindingResolver resolver) {
        return JstExpressionTypeLinkerHelper.getNativeTypeFromTS(resolver, "Object");
    }

    public static IJstType getNativeBooleanJstType(JstExpressionBindingResolver resolver) {
        return JstExpressionTypeLinkerHelper.getNativeTypeFromTS(resolver, PrimitiveBoolean.class.getSimpleName());
    }

    public static IJstType getNativeVoidJstType(JstExpressionBindingResolver resolver) {
        return JstExpressionTypeLinkerHelper.getNativeTypeFromTS(resolver, "void");
    }

    public static IJstType getNativeFunctionJstType(JstExpressionBindingResolver resolver) {
        return JstExpressionTypeLinkerHelper.getNativeTypeFromTS(resolver, "Function");
    }

    public static IJstType getNativeTypeFromTS(JstExpressionBindingResolver resolver, String name) {
        if (name == null) {
            return null;
        }
        IJstType jstType = JstExpressionTypeLinkerHelper.getNativeTypeFromTS(resolver, "JsNativeLib", name);
        return jstType;
    }

    public static IJstType getNativeTypeFromTS(JstExpressionBindingResolver resolver, String groupName, String name) {
        TypeName typeName = new TypeName(groupName, name);
        JstTypeSpaceMgr tsMgr = resolver.getController().getJstTypeSpaceMgr();
        JstQueryExecutor queryExecutor = tsMgr.getQueryExecutor();
        return queryExecutor.findType(typeName, tsMgr.getTypeSpace().getGroup(groupName));
    }

    public static IJstType getNativeElementType(JstExpressionBindingResolver resolver, String lastExpr) {
        IJstType type = null;
        type = JstExpressionTypeLinkerHelper.getNativeTypeFromTS(resolver, lastExpr);
        if (type != null) {
            type = JstTypeHelper.getJstTypeRefType((IJstType)type);
        }
        return type;
    }

    public static interface GlobalNativeTypeInfoProvider {
        public JstExpressionTypeLinker.LinkerSymbolInfo findTypeInSymbolMap(String var1, List<VarTable> var2);
    }

    private static final class IJstMethodSortable
    implements Comparable<IJstMethodSortable> {
        private final IJstMethod m_method;

        public IJstMethodSortable(IJstMethod m) {
            this.m_method = m;
        }

        public final IJstMethod getMethod() {
            return this.m_method;
        }

        @Override
        public int compareTo(IJstMethodSortable o) {
            return o.m_method.getArgs().size() - this.m_method.getArgs().size();
        }
    }

    public static class OverloadBestMatchCandidate
    implements Comparable<OverloadBestMatchCandidate> {
        private final IJstMethod m_method;
        private final List<JstArg> m_parameters;
        private final List<IExpr> m_arguments;

        public OverloadBestMatchCandidate(IJstMethod method, List<JstArg> parameter, List<IExpr> arguments) {
            assert (method != null);
            assert (parameter != null);
            assert (arguments != null);
            this.m_method = method;
            this.m_parameters = new ArrayList<JstArg>(parameter);
            this.m_arguments = new ArrayList<IExpr>(arguments);
        }

        public IJstMethod getMethod() {
            return this.m_method;
        }

        public List<JstArg> getParameters() {
            return Collections.unmodifiableList(this.m_parameters);
        }

        public List<IExpr> getArguments() {
            return Collections.unmodifiableList(this.m_arguments);
        }

        @Override
        public int compareTo(OverloadBestMatchCandidate other) {
            return this.compareToBeginsAt(0, this.m_arguments, this.m_parameters, other.m_parameters);
        }

        private int compareToBeginsAt(int argumentIndex, List<IExpr> arguments, List<JstArg> selfParameters, List<JstArg> otherParameters) {
            ParamMatchingArgCase otherCase;
            if (argumentIndex >= arguments.size()) {
                return selfParameters.size() - otherParameters.size();
            }
            IExpr argument = this.m_arguments.get(argumentIndex);
            JstArg selfParameter = this.m_parameters.get(argumentIndex);
            JstArg otherParameter = otherParameters.get(argumentIndex);
            ParamMatchingArgCase selfCase = JstExpressionTypeLinkerHelper.argMatchingParam(argument, selfParameter);
            int compared = selfCase.compareTo(otherCase = JstExpressionTypeLinkerHelper.argMatchingParam(argument, otherParameter));
            return compared == 0 ? this.compareToBeginsAt(argumentIndex + 1, arguments, selfParameters, otherParameters) : compared;
        }

        public boolean equals(Object other) {
            if (other instanceof OverloadBestMatchCandidate) {
                OverloadBestMatchCandidate otherScoreEntry = (OverloadBestMatchCandidate)other;
                return this.m_method == otherScoreEntry.m_method && this.m_parameters == otherScoreEntry.m_parameters && this.m_arguments == otherScoreEntry.m_arguments;
            }
            return false;
        }

        public int hashCode() {
            return this.m_method.hashCode() + this.m_parameters.hashCode() + this.m_arguments.hashCode();
        }
    }

    public static class OverwritableFType
    extends JstProxyType {
        private static final long serialVersionUID = 6883185350087966254L;
        private IJstMethod _invoke;

        protected OverwritableFType(IJstType targetType, IJstMethod invoke) {
            super(targetType);
            this._invoke = invoke;
        }

        public IJstMethod getMethod(String name) {
            if ("_invoke_".equals(name)) {
                return this._invoke;
            }
            return super.getMethod(name);
        }

        public IJstMethod getMethod(String name, boolean isStatic) {
            if ("_invoke_".equals(name)) {
                return this._invoke;
            }
            return super.getMethod(name, isStatic);
        }

        public IJstMethod getMethod(String name, boolean isStatic, boolean recursive) {
            if ("_invoke_".equals(name)) {
                return this._invoke;
            }
            return super.getMethod(name, isStatic, recursive);
        }

        public void accept(IJstNodeVisitor visitor) {
        }
    }

    public static class OverwritableSynthJstProxyMethod
    extends SynthJstProxyMethod {
        private static final long serialVersionUID = 1L;
        private IJstType _rtnType;
        private List<JstArg> _jstArgs;
        private List<IJstMethod> _overloaded;

        public OverwritableSynthJstProxyMethod(IJstMethod targetType) {
            super(targetType);
        }

        public IJstType getRtnType() {
            if (this._rtnType != null) {
                return this._rtnType;
            }
            return super.getRtnType();
        }

        public void setRtnType(IJstType rtnType) {
            this._rtnType = rtnType;
        }

        public List<JstArg> getArgs() {
            if (this._jstArgs != null) {
                return Collections.unmodifiableList(this._jstArgs);
            }
            return super.getArgs();
        }

        public void setArgs(List<JstArg> args) {
            this._jstArgs = new ArrayList<JstArg>(args);
        }

        public List<IJstMethod> getOverloaded() {
            if (this._overloaded != null) {
                return Collections.unmodifiableList(this._overloaded);
            }
            return super.getOverloaded();
        }

        public void addOverloaded(IJstMethod overload) {
            if (this._overloaded == null) {
                this._overloaded = new ArrayList<IJstMethod>(2);
            }
            this._overloaded.add(overload);
        }
    }

    public static enum ParamMatchingArgCase {
        exact,
        subtype,
        implicitConversion,
        object;

    }
}

