/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust;

import java.util.Stack;
import org.eclipse.mod.wst.jsdt.core.ast.IProgramElement;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ErrorChunk;
import org.eclipse.vjet.dsf.jstojava.translator.robust.IErrorCollector;

abstract class DefaultErrorCollector
implements IErrorCollector {
    private Stack<IProgramElement> astElements;
    private ErrorChunk errorChunk;

    DefaultErrorCollector(IProgramElement noErrorElement, Stack<IProgramElement> astElements) {
        this.astElements = astElements;
        this.errorChunk = new ErrorChunk(noErrorElement);
    }

    @Override
    public ErrorChunk toErrorChunk() {
        return this.errorChunk;
    }

    @Override
    public void collect() {
        IProgramElement errorElement = this.astElements.pop();
        this.errorChunk.append(errorElement);
        while (!this.astElements.empty()) {
            errorElement = this.astElements.peek();
            if (this.isValidToken(TranslateHelper.getStringToken(errorElement))) break;
            this.errorChunk.append(this.astElements.pop());
        }
    }
}

