/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.initialization;

import java.util.ListIterator;
import java.util.Set;
import org.eclipse.vjet.dsf.common.enums.BaseEnum;
import org.eclipse.vjet.dsf.common.initialization.InitializationContext;
import org.eclipse.vjet.dsf.common.initialization.InitializationException;
import org.eclipse.vjet.dsf.common.initialization.InitializationState;

public interface Initializable {
    public void doInitialize(InitializationContext var1) throws InitializationException;

    public void doShutdown(InitializationContext var1);

    public InitializationState getState();

    public void notifyInitDone();

    public boolean isNotifyUponInitDone();

    public void setCharacteristicInfo(CharacteristicEnum var1, Object var2);

    public Object getCharacteristicInfo(CharacteristicEnum var1);

    public Set<?> getCharacteristics();

    public static class CharacteristicEnum
    extends BaseEnum {
        public static final CharacteristicEnum NONE = new CharacteristicEnum("None", 0);
        public static final CharacteristicEnum REGISTER_COMMANDS = new CharacteristicEnum("RegisterCommands", 1);
        public static final CharacteristicEnum NO_LAZY_INIT = new CharacteristicEnum("NoLazyInit", 2);
        public static final CharacteristicEnum FORCE_LAZY_INIT = new CharacteristicEnum("ForceLazyInit", 3);

        private CharacteristicEnum(String name, int intValue) {
            super(intValue, name);
        }

        public static CharacteristicEnum get(int key) {
            return (CharacteristicEnum)CharacteristicEnum.getEnum(CharacteristicEnum.class, key);
        }

        public static CharacteristicEnum getElseReturn(int key, CharacteristicEnum elseEnum) {
            return (CharacteristicEnum)CharacteristicEnum.getElseReturnEnum(CharacteristicEnum.class, key, elseEnum);
        }

        public static ListIterator iterator() {
            return CharacteristicEnum.getIterator(CharacteristicEnum.class);
        }
    }
}

