/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.xml;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;

public class XmlStreamUtil {
    public static void safeWriteAttrObject(IXmlStreamWriter xmlStreamWriter, String attributeName, Object attributeObjValue) {
        XmlStreamUtil.safeWriteAttr(xmlStreamWriter, attributeName, attributeObjValue == null ? "" : attributeObjValue.toString());
    }

    public static void safeWriteAttr(IXmlStreamWriter xmlStreamWriter, String attributeName, String attributeValue) {
        xmlStreamWriter.writeAttribute(attributeName, attributeValue == null ? "" : attributeValue);
    }

    public static void safeWriteChildCData(IXmlStreamWriter xmlWriter, String elementName, String value) {
        XmlStreamUtil.writeChildCData(xmlWriter, elementName, value == null ? "(null)" : value);
    }

    public static void writeChildText(IXmlStreamWriter xmlWriter, String elementName, String data) {
        xmlWriter.writeStartElement(elementName);
        xmlWriter.writeCharacters(data);
        xmlWriter.writeEndElement();
    }

    public static void writeChildCData(IXmlStreamWriter xmlWriter, String elementName, String value) {
        xmlWriter.writeStartElement(elementName);
        xmlWriter.writeCData(value);
        xmlWriter.writeEndElement();
    }

    public static void writeChildElement(IXmlStreamWriter xmlWriter, String elementName, boolean value) {
        XmlStreamUtil.writeChildText(xmlWriter, elementName, Boolean.toString(value));
    }

    public static void writeChildElement(IXmlStreamWriter xmlWriter, String elementName, int value) {
        XmlStreamUtil.writeChildText(xmlWriter, elementName, Integer.toString(value));
    }

    public static void writeChildElement(IXmlStreamWriter xmlWriter, String elementName, long value) {
        XmlStreamUtil.writeChildText(xmlWriter, elementName, Long.toString(value));
    }

    public static void writeThrowable(IXmlStreamWriter xmlWriter, String elementName, Throwable e) {
        xmlWriter.writeStartElement(elementName);
        String stackString = XmlStreamUtil.stringForm(e);
        xmlWriter.writeCData(stackString);
        xmlWriter.writeEndElement();
    }

    public static void renderTimeElementAsDuration(IXmlStreamWriter xmlWriter, String elemName, long time, long curTime, boolean future) {
        String str = XmlStreamUtil.getTimeElementAsDuration(time, curTime, future);
        xmlWriter.writeStartElement(elemName);
        xmlWriter.writeCharacters(str);
        xmlWriter.writeEndElement();
    }

    public static String getTimeElementAsDuration(long time, long curTime, boolean future) {
        if (time < 0L) {
            return "N/A";
        }
        if (time == 0L) {
            return "unset";
        }
        long d = future ? time - curTime : curTime - time;
        return Long.toString(d);
    }

    public static void renderErrorXml(IXmlStreamWriter xmlWriter, String elemName, Throwable e) {
        XmlStreamUtil.renderErrorXml(xmlWriter, elemName, null, e);
    }

    public static void renderErrorXml(IXmlStreamWriter xmlWriter, String elemName, String text, Throwable e) {
        if (text == null && e == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder();
        if (text != null) {
            sb.append(text);
        }
        if (e != null) {
            if (sb.length() != 0) {
                sb.append(": ");
            }
            sb.append(e.toString());
            sb.append('\n');
            sb.append(XmlStreamUtil.stringForm(e));
        }
        XmlStreamUtil.writeChildCData(xmlWriter, elemName, sb.toString());
    }

    private static String stringForm(Throwable e) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.getBuffer().toString();
    }
}

