/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.lib;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstSerializer;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.ts.util.JstTypeSerializer;
import org.eclipse.vjet.vjo.lib.IResourceResolver;

public class VjoSelfDescribedLib {
    private static final String VJO_CLASS = "vjo.Class";
    private static final String VJO_OBJECT = "vjo.Object";
    private static final String VJO_ENUM = "vjo.Enum";
    private static final VjoSelfDescribedLib s_instance = new VjoSelfDescribedLib();
    private static JstType m_class;
    private static JstType m_object;
    private static JstType m_enum;
    private IResourceResolver m_resourceResolver;

    public static VjoSelfDescribedLib getInstance() {
        return s_instance;
    }

    public VjoSelfDescribedLib setResourceResolver(IResourceResolver resourceResolver) {
        this.m_resourceResolver = resourceResolver;
        return this;
    }

    public List<IJstType> getTypes() {
        this.clear();
        ArrayList<IJstType> l = new ArrayList<IJstType>();
        l.addAll(this.getVjoJst());
        VjoSelfDescribedLib.fixVjoLib(l);
        return l;
    }

    private static void fixVjoLib(List<IJstType> types) {
        JstType[] types2;
        for (IJstType type : types) {
            if (!(type instanceof JstType)) continue;
            JstType jstType = (JstType)type;
            JstCache.getInstance().addType(jstType);
        }
        JstType OBJECT = VjoSelfDescribedLib.getObject();
        JstType CLASS = VjoSelfDescribedLib.getVjoClass();
        JstType ENUM = JstCache.getInstance().getType(VJO_ENUM);
        JstType[] jstTypeArray = types2 = new JstType[]{OBJECT, CLASS, ENUM};
        int n = types2.length;
        int n2 = 0;
        while (n2 < n) {
            JstType jstType = jstTypeArray[n2];
            if (jstType != null) {
                IJstType t;
                IJstType extend = jstType.getExtend();
                if (extend == null) {
                    jstType.addExtend((IJstType)OBJECT);
                }
                for (IJstMethod mtd : jstType.getMethods()) {
                    JstMethod mtd2 = (JstMethod)mtd;
                    t = mtd2.getRtnType();
                    if (t == null) continue;
                    mtd2.setRtnType(VjoSelfDescribedLib.fixType(mtd2.getRtnType()));
                }
                for (IJstProperty pty : jstType.getProperties()) {
                    JstProperty pty2 = (JstProperty)pty;
                    t = pty2.getType();
                    if (t == null) continue;
                    pty2.setType(VjoSelfDescribedLib.fixType(pty.getType()));
                }
            }
            ++n2;
        }
    }

    private static JstType getVjoClass() {
        if (m_class == null) {
            m_class = JstCache.getInstance().getType(VJO_CLASS);
        }
        return m_class;
    }

    private static JstType getObject() {
        if (m_object == null) {
            m_object = JstCache.getInstance().getType(VJO_OBJECT);
        }
        return m_object;
    }

    private static JstType getVjoEnum() {
        if (m_enum == null) {
            m_enum = JstCache.getInstance().getType(VJO_ENUM);
        }
        return m_enum;
    }

    private static IJstType fixType(IJstType t) {
        JstType OBJECT = VjoSelfDescribedLib.getObject();
        JstType CLASS = VjoSelfDescribedLib.getVjoClass();
        JstType ENUM = VjoSelfDescribedLib.getVjoEnum();
        if (t.getName().contains(VJO_OBJECT)) {
            return OBJECT;
        }
        if (t.getName().contains(VJO_CLASS)) {
            return CLASS;
        }
        if (t.getName().contains(VJO_ENUM)) {
            return ENUM;
        }
        return t;
    }

    public List<IJstType> getVjoJst() {
        if (this.m_resourceResolver == null) {
            return Collections.emptyList();
        }
        try {
            IJstSerializer serializer = this.m_resourceResolver.getJstSerializer();
            if (serializer == null) {
                serializer = JstTypeSerializer.getInstance();
            }
            InputStream fio = this.m_resourceResolver.getVjoLibSerializedStream();
            List deserialize = serializer.deserialize(fio);
            return deserialize;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    private void clear() {
        m_class = null;
        m_enum = null;
        m_object = null;
    }
}

