/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.codeassist.keywords;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.dltk.mod.core.CompletionProposal;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.IModelElementRequestor;
import org.eclipse.dltk.mod.internal.core.ModelElementRequestor;
import org.eclipse.dltk.mod.internal.core.NameLookup;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.eclipse.codeassist.keywords.ICompletionHandler;
import org.eclipse.vjet.eclipse.core.IImportDeclaration;
import org.eclipse.vjet.eclipse.core.IJSSourceModule;
import org.eclipse.vjet.eclipse.core.IJSType;
import org.eclipse.vjet.eclipse.internal.core.util.Util;

public class BaseCompletionHandler
implements ICompletionHandler {
    @Override
    public Class getCompletionClass() {
        return null;
    }

    @Override
    public void complete(ISourceModule sourceModule, int position, JstCompletion completion, List<CompletionProposal> list) {
        String[] packageProposals;
        String wordBefore = completion.getToken();
        if (wordBefore.length() == 0) {
            return;
        }
        if (!(sourceModule instanceof IModelElement)) {
            return;
        }
        NameLookup lookup = this.getNameLookup((IModelElement)sourceModule);
        if (lookup == null) {
            return;
        }
        IScriptFolder[] paths = lookup.findScriptFolders(wordBefore, true);
        if (paths != null && (packageProposals = this.createPackageProposals(paths)).length > 0) {
            this.addProposals(list, packageProposals, position, 11, this.getRelevance(11), wordBefore);
        }
        String currentPath = "";
        int lastDotPosition = wordBefore.lastIndexOf(46);
        if (lastDotPosition != -1) {
            currentPath = wordBefore.substring(0, lastDotPosition);
        }
        IScriptFolder[] currentPackage = lookup.findScriptFolders(currentPath, false);
        ModelElementRequestor modelRequestor = new ModelElementRequestor();
        if (currentPackage != null && currentPackage.length > 0) {
            lookup.seekTypes(wordBefore.substring(wordBefore.lastIndexOf(46) + 1), currentPackage[0], true, 0, (IModelElementRequestor)modelRequestor);
            if (lastDotPosition == -1) {
                this.searchBetweenImported(sourceModule, lookup, modelRequestor, wordBefore);
            }
            if (modelRequestor.getTypes() != null && modelRequestor.getTypes().length > 0) {
                List<IType> typeProposals = this.createTypeProposals(this.getType(sourceModule), modelRequestor);
                this.addProposals(list, wordBefore, typeProposals, 7, this.getRelevance(7), position);
            }
        }
    }

    protected void completeTypes(ISourceModule sourceModule, int position, JstCompletion completion, List<CompletionProposal> list) {
        NameLookup lookup = this.getNameLookup((IModelElement)sourceModule);
        if (lookup == null) {
            return;
        }
        String wordBefore = completion.getToken();
        if (wordBefore.length() == 0) {
            return;
        }
        String currentPath = "";
        int lastDotPosition = wordBefore.lastIndexOf(46);
        if (lastDotPosition != -1) {
            currentPath = wordBefore.substring(0, lastDotPosition);
        }
        IScriptFolder[] currentPackage = lookup.findScriptFolders(currentPath, false);
        ModelElementRequestor modelRequestor = new ModelElementRequestor();
        if (currentPackage != null && currentPackage.length > 0) {
            lookup.seekTypes(wordBefore.substring(wordBefore.lastIndexOf(46) + 1), currentPackage[0], true, 0, (IModelElementRequestor)modelRequestor);
            if (lastDotPosition == -1) {
                this.searchBetweenImported(sourceModule, lookup, modelRequestor, wordBefore);
            }
            if (modelRequestor.getTypes() != null && modelRequestor.getTypes().length > 0) {
                List<IType> typeProposals = this.createTypeProposals(this.getType(sourceModule), modelRequestor);
                this.addProposals(list, wordBefore, typeProposals, 7, this.getRelevance(7), position);
            }
        }
    }

    public void completePackages(ISourceModule sourceModule, int position, JstCompletion completion, List<CompletionProposal> list) {
        String[] packageProposals;
        String wordBefore = completion.getToken();
        if (wordBefore.length() == 0) {
            return;
        }
        if (!(sourceModule instanceof IModelElement)) {
            return;
        }
        NameLookup lookup = this.getNameLookup((IModelElement)sourceModule);
        if (lookup == null) {
            return;
        }
        IScriptFolder[] paths = lookup.findScriptFolders(wordBefore, true);
        if (paths != null && (packageProposals = this.createPackageProposals(paths)).length > 0) {
            this.addProposals(list, packageProposals, position, 11, this.getRelevance(11), wordBefore);
        }
    }

    private void searchBetweenImported(ISourceModule sm, NameLookup lookup, ModelElementRequestor modelRequestor, String wordBefore) {
        IJSSourceModule sourceModule = (IJSSourceModule)sm;
        try {
            IModelElement[] imports = sourceModule.getImportContainer().getChildren();
            IType[] alreadyAddedTypes = modelRequestor.getTypes();
            ArrayList<IType> alreadyAdded = new ArrayList<IType>(alreadyAddedTypes.length);
            IType[] iTypeArray = alreadyAddedTypes;
            int n = alreadyAddedTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                alreadyAdded.add(type);
                ++n2;
            }
            iTypeArray = imports;
            n = imports.length;
            n2 = 0;
            while (n2 < n) {
                IType modelElement = iTypeArray[n2];
                IImportDeclaration importDeclaration = (IImportDeclaration)modelElement;
                String fullName = importDeclaration.getElementName();
                int dotIndex = fullName.lastIndexOf(46);
                String lastSegment = fullName.substring(dotIndex + 1);
                IType type = null;
                if ("*".equals(lastSegment)) {
                    IScriptFolder[] folders = lookup.findScriptFolders(fullName.substring(0, dotIndex), false);
                    if (folders != null && folders.length > 0) {
                        IModelElement[] children;
                        IModelElement[] iModelElementArray = children = folders[0].getChildren();
                        int n3 = children.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IType[] types;
                            IModelElement modelElement2 = iModelElementArray[n4];
                            if (modelElement2.getElementType() == 5 && (types = ((IJSSourceModule)modelElement2).getTypes()) != null && types.length > 0) {
                                BaseCompletionHandler.checkAndAdd(types[0], wordBefore, alreadyAdded, modelRequestor);
                            }
                            ++n4;
                        }
                    }
                } else if (lastSegment.startsWith(wordBefore)) {
                    type = lookup.findType(importDeclaration.getElementName(), false, 0);
                    BaseCompletionHandler.checkAndAdd(type, wordBefore, alreadyAdded, modelRequestor);
                }
                ++n2;
            }
        }
        catch (ModelException modelException) {}
    }

    private static void checkAndAdd(IType type, String prefix, Collection<IType> alreadyAdded, ModelElementRequestor modelRequestor) {
        if (type != null && type.getElementName().startsWith(prefix) && !alreadyAdded.contains(type)) {
            alreadyAdded.add(type);
            modelRequestor.acceptType(type);
        }
    }

    private void addProposals(List<CompletionProposal> keywords, String[] array, int position, int type, int relevance, String wordBefore) {
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            CompletionProposal data = CompletionProposal.create((int)type, (int)position);
            data.setName(name.toCharArray());
            data.setCompletion(name.toCharArray());
            data.setRelevance(relevance);
            data.setReplaceRange(position - wordBefore.length(), position);
            keywords.add(data);
            ++n2;
        }
    }

    private void addProposals(List<CompletionProposal> keywords, IType[] proposals, int position, int type, int relevance) {
        IType[] iTypeArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            IType itype = iTypeArray[n2];
            String typeName = itype.getFullyQualifiedName().replace('/', '.');
            CompletionProposal data = CompletionProposal.create((int)type, (int)position);
            char[] shortName = itype.getElementName().toCharArray();
            data.setName(typeName.toCharArray());
            data.setCompletion(shortName);
            data.setRelevance(relevance);
            this.setFlags(itype, data);
            keywords.add(data);
            ++n2;
        }
    }

    private void setFlags(IType itype, CompletionProposal data) {
        if (itype instanceof IJSType) {
            try {
                IJstType jstType;
                IJSType jsType = (IJSType)itype;
                if (jsType.isInterface()) {
                    data.setFlags(512);
                }
                if (jsType.isEnum()) {
                    data.setFlags(16384);
                }
                if ((jstType = Util.toJstType((IType)jsType)) != null && jstType.isMixin()) {
                    data.setFlags(32768);
                }
            }
            catch (ModelException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
            }
        }
    }

    private void addProposals(List<CompletionProposal> keywords, String wordBefore, List<IType> proposals, int type, int relevance, int position) {
        ArrayList<IType> filteredPropodals = new ArrayList<IType>();
        for (IType name : proposals) {
            name.getFullyQualifiedName().replace('/', '.');
            filteredPropodals.add(name);
        }
        this.addProposals(keywords, filteredPropodals.toArray(new IType[filteredPropodals.size()]), position, type, relevance);
    }

    private NameLookup getNameLookup(IModelElement modelElement) {
        IScriptProject project = (IScriptProject)modelElement.getAncestor(2);
        NameLookup lookup = null;
        try {
            lookup = ((ScriptProject)project).newNameLookup((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        return lookup;
    }

    protected String[] createPackageProposals(IScriptFolder[] paths) {
        LinkedList<String> packageProposals = new LinkedList<String>();
        IScriptFolder[] iScriptFolderArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IScriptFolder path = iScriptFolderArray[n2];
            packageProposals.add(path.getElementName().replace('/', '.'));
            ++n2;
        }
        return packageProposals.toArray(new String[packageProposals.size()]);
    }

    protected List<IType> createTypeProposals(IType currentType, ModelElementRequestor modelRequestor) {
        if (currentType != null && modelRequestor.getTypes() != null) {
            ArrayList<IType> proposals = new ArrayList<IType>(modelRequestor.getTypes().length);
            IType[] iTypeArray = modelRequestor.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (this.checkType(type, currentType)) {
                    proposals.add(type);
                }
                ++n2;
            }
            return proposals;
        }
        return null;
    }

    protected int getRelevance(int completionType) {
        switch (completionType) {
            case 11: {
                return 10;
            }
            case 7: {
                return 200;
            }
        }
        return 1;
    }

    private IType getType(ISourceModule sourceModule) {
        try {
            IType[] types = ((IJSSourceModule)sourceModule).getTypes();
            if (types.length > 0) {
                return types[0];
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        catch (IndexOutOfBoundsException i) {
            DLTKCore.error((String)i.toString(), (Throwable)i);
        }
        return null;
    }

    protected boolean checkType(IType type, IType currentType) {
        return !type.equals(currentType);
    }
}

