/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.codeassist.keywords;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.dltk.mod.core.CompletionProposal;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstFieldOrMethodCompletion;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.codeassist.keywords.BaseCompletionHandler;
import org.eclipse.vjet.eclipse.codeassist.keywords.ICompletionHandler;
import org.eclipse.vjet.eclipse.core.IJSMethod;
import org.eclipse.vjet.eclipse.core.IJSType;

public class FieldOrMethodCompletionHandler
extends BaseCompletionHandler
implements ICompletionHandler {
    private static final String COMMA = ",";
    private static final String TWO_DOT = " : ";
    private static final String OPEN_BRACKET = "[";
    private static final String CLOSE_BRACKET = "]";
    private static final String NEW_ENUM_VALUE = " - new enum value";
    private static final char TAB = '\t';
    private static final char NEWLINE_1 = '\r';
    private static final char NEWLINE_2 = '\n';
    private static final String RN = "\r\n";
    public static final String MAIN_METHOD = "main";

    @Override
    public void complete(ISourceModule module, int position, JstCompletion completion, List<CompletionProposal> list) {
        super.complete(module, position, completion, list);
    }

    private boolean inPropsOrProtosBlock(JstCompletion completion) {
        return completion.inScope(ScopeIds.PROPS) || completion.inScope(ScopeIds.PROTOS);
    }

    private void complete(ISourceModule module, int position, List<CompletionProposal> list, boolean isStaticBlock, String[] tokens) {
        MethodRequestor requestor = null;
        if (tokens.length < 2) {
            String tokenStr = tokens.length > 0 ? tokens[0] : "";
            requestor = new MethodRequestor(tokenStr, false);
            if (tokenStr.length() > 0 && Character.isJavaIdentifierStart(tokenStr.charAt(0))) {
                this.proposeNewFunction(tokenStr, position, list, isStaticBlock);
            }
        } else {
            String token = tokens[0];
            if ("function".startsWith(tokens[1])) {
                requestor = new MethodRequestor(token, true);
            }
        }
        if (requestor != null && !isStaticBlock) {
            this.getSuperMethodsToOverwrite(requestor, module);
            for (IMethod method : requestor.getMethods()) {
                this.createMethodCompletion(position, list, method);
            }
        }
    }

    private void createMethodCompletion(int position, List<CompletionProposal> list, IMethod method) {
        String funcName = method.getElementName();
        boolean isConstructor = false;
        int flags = 0;
        try {
            flags = method.getFlags();
            isConstructor = method.isConstructor();
        }
        catch (ModelException e2) {
            DLTKCore.error((String)e2.toString(), (Throwable)e2);
        }
        if (isConstructor) {
            funcName = "constructs";
        }
        StringBuffer completionText = new StringBuffer(funcName);
        completionText.append(" : function(");
        String[] paramNames = null;
        String[] paramTypes = null;
        String returnType = null;
        String inType = null;
        try {
            paramNames = method.getParameters();
            if (method instanceof IJSMethod) {
                paramTypes = ((IJSMethod)method).getParameterTypes();
                returnType = ((IJSMethod)method).getReturnType();
                inType = ((IJSMethod)method).getDeclaringType().getElementName();
            }
            if (paramNames != null) {
                int i = 0;
                while (i < paramNames.length) {
                    if (i > 0) {
                        completionText.append(", ");
                    }
                    completionText.append(paramNames[i]);
                    ++i;
                }
            }
            method.getFlags();
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        completionText.append(") {");
        completionText.append('\r');
        completionText.append('\n');
        completionText.append('\t');
        completionText.append(this.getSuperFunctionCall(funcName, returnType, paramNames));
        completionText.append('\r');
        completionText.append('\n');
        completionText.append("}");
        if (isConstructor) {
            returnType = "";
        }
        String comment = this.generateMethodComment(funcName, returnType, paramNames, paramTypes, flags);
        completionText.insert(0, comment);
        CompletionProposal data = CompletionProposal.create((int)6, (int)position);
        data.setName(funcName.toCharArray());
        data.setRelevance(2);
        data.setCompletion(completionText.toString().toCharArray());
        data.setIsConstructor(isConstructor);
        if (paramNames != null) {
            char[][] parameters = this.createParameters(paramNames);
            data.setParameterNames(parameters);
        }
        data.setFlags(flags);
        data.setModelElement((IModelElement)method);
        data.extraInfo = new MethodCompletionExtraInfo(paramTypes, returnType, inType);
        list.add(data);
    }

    protected char[][] createParameters(String[] paramNames) {
        char[][] parameters = new char[paramNames.length][];
        int i = 0;
        while (i < paramNames.length) {
            parameters[i] = paramNames[i].toCharArray();
            ++i;
        }
        return parameters;
    }

    private void proposeNewFunction(String token, int position, List<CompletionProposal> list, boolean isStaticBlock) {
        CompletionProposal data = this.createNewFunctionCompletion(token, position, isStaticBlock);
        list.add(data);
        if (MAIN_METHOD.startsWith(token) && isStaticBlock) {
            data = this.createNewFunctionCompletion(MAIN_METHOD, position, true);
            list.add(data);
        }
    }

    private CompletionProposal createNewFunctionCompletion(String token, int position, boolean isStaticBlock) {
        CompletionProposal data = CompletionProposal.create((int)9, (int)position);
        data.setName(token.toCharArray());
        data.setRelevance(2);
        StringBuffer completionText = new StringBuffer(token);
        completionText.append("() {").append('\r').append('\n').append('\t').append('\r').append('\n').append("}");
        data.setCompletion(completionText.toString().toCharArray());
        data.extraInfo = isStaticBlock;
        return data;
    }

    private void proposeNewEnumValue(String token, int position, List<CompletionProposal> list, JstFieldOrMethodCompletion completion) {
        CompletionProposal data = CompletionProposal.create((int)2, (int)position);
        String value = String.valueOf(token) + NEW_ENUM_VALUE;
        data.setName(value.toCharArray());
        data.setRelevance(2);
        StringBuffer completionText = new StringBuffer(token);
        if (!completion.getToken().trim().endsWith(":")) {
            completionText.append(TWO_DOT);
        }
        completionText.append(OPEN_BRACKET);
        completionText.append(this.getParameters(completion));
        completionText.append(CLOSE_BRACKET);
        data.setCompletion(completionText.toString().toCharArray());
        data.extraInfo = completion.isStatic();
        list.add(data);
    }

    private String getParameters(JstFieldOrMethodCompletion completion) {
        IJstType type = completion.getOwnerType();
        IJstMethod constructor = type.getConstructor();
        StringBuffer buffer = new StringBuffer();
        if (constructor != null && constructor.getParamNames() != null) {
            List strings = constructor.getArgs();
            int i = 0;
            while (i < strings.size()) {
                JstArg s = (JstArg)strings.get(i);
                buffer.append(s.getName());
                if (i < strings.size() - 1) {
                    buffer.append(COMMA);
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    private String getSuperFunctionCall(String funcName, String returnType, String[] paramNames) {
        StringWriter superCall = new StringWriter();
        if (!"void".equals(returnType)) {
            superCall.append("return ");
        }
        superCall.append("this.base.");
        superCall.append(funcName);
        superCall.append("(");
        int i = 0;
        while (i < paramNames.length) {
            if (i > 0) {
                superCall.append(", ");
            }
            superCall.append(paramNames[i]);
            ++i;
        }
        superCall.append(");");
        return superCall.toString();
    }

    private String generateMethodComment(String funcName, String returnType, String[] paramNames, String[] paramTypes, int flags) {
        StringBuffer comment = new StringBuffer("//>");
        if ((flags & 0x80) != 0) {
            comment.append(" public");
        } else if ((flags & 0x40) != 0) {
            comment.append(" protected");
        }
        if ((flags & 8) != 0) {
            comment.append(" final");
        }
        if ((flags & 1) != 0) {
            comment.append(" abstract");
        }
        comment.append(" ");
        comment.append(returnType);
        comment.append(" ");
        comment.append(funcName);
        comment.append("(");
        if (paramTypes != null && paramNames != null && paramNames.length == paramTypes.length) {
            this.appendParameterSignature(comment, paramTypes, paramNames);
        }
        comment.append(')');
        comment.append('\r');
        comment.append('\n');
        return comment.toString();
    }

    @Override
    public Class getCompletionClass() {
        return JstFieldOrMethodCompletion.class;
    }

    protected void getMethods(MethodRequestor requestor, IType type) {
        if (type == null || requestor == null) {
            return;
        }
        try {
            IType superType;
            IMethod[] methods;
            IMethod[] iMethodArray = methods = type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                requestor.acceptMethod(method);
                ++n2;
            }
            String[] superClassNames = type.getSuperClasses();
            if (superClassNames != null && superClassNames.length > 0 && (superType = CodeassistUtils.findResourceType((ISourceModule)type.getParent(), superClassNames[0])) != null) {
                this.getMethods(requestor, superType);
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
    }

    protected StringBuffer appendParameterSignature(StringBuffer buffer, String[] parameterTypes, String[] parameterNames) {
        if (parameterNames != null) {
            int i = 0;
            while (i < parameterNames.length) {
                if (i > 0) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                buffer.append(parameterTypes[i]).append(' ').append(parameterNames[i]);
                ++i;
            }
        }
        return buffer;
    }

    protected void getSuperMethodsToOverwrite(MethodRequestor requestor, ISourceModule module) {
        IType type = CodeassistUtils.getType(module, null);
        try {
            String[] superInterfaceNames;
            String[] superClassNames = type.getSuperClasses();
            if (superClassNames != null && superClassNames.length > 0) {
                type = CodeassistUtils.findResourceType((ISourceModule)type.getParent(), superClassNames[0]);
                this.getMethods(requestor, type);
            }
            if (type instanceof IJSType && (superInterfaceNames = ((IJSType)type).getSuperInterfaceNames()) != null) {
                String[] stringArray = superInterfaceNames;
                int n = superInterfaceNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    IType interfaceType = CodeassistUtils.findResourceType((ISourceModule)type.getParent(), name);
                    if (interfaceType != null) {
                        type = interfaceType;
                        this.getMethods(requestor, type);
                    }
                    ++n2;
                }
            }
        }
        catch (ModelException e1) {
            DLTKCore.error((String)e1.toString(), (Throwable)e1);
        }
    }

    protected void requestMethods(MethodRequestor requestor, ISourceModule module) {
        IType type = CodeassistUtils.getType(module, null);
        this.getMethods(requestor, type);
    }

    protected void setParameters(IMethod method, CompletionProposal data) {
        try {
            String[] paramNames = method.getParameters();
            char[][] params = this.createParameters(paramNames);
            data.setParameterNames(params);
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
    }

    private String[] trimTokens(String[] tokens) {
        ArrayList<String> newTokens = new ArrayList<String>();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if ((string = string.trim()).length() > 0) {
                newTokens.add(string);
            }
            ++n2;
        }
        return newTokens.toArray(new String[newTokens.size()]);
    }

    public class MethodCompletionExtraInfo {
        public String[] parameterTypes;
        public String returnType = "$";
        public String inType = "$";

        public MethodCompletionExtraInfo(String[] parameterTypes, String returnType, String inType) {
            this.parameterTypes = parameterTypes;
            this.returnType = returnType;
            this.inType = inType;
        }
    }

    protected class MethodRequestor {
        private List<IMethod> methods = new ArrayList<IMethod>();
        private String namePrefix = "";
        private boolean isExactMatch = false;

        public MethodRequestor(String namePrefix, boolean isExactMatch) {
            if (namePrefix != null) {
                this.namePrefix = namePrefix;
                this.isExactMatch = isExactMatch;
            }
        }

        public void acceptMethod(IMethod method) {
            boolean nameMatch;
            int flags = 0;
            boolean isConstructor = false;
            try {
                flags = method.getFlags();
                isConstructor = method.isConstructor();
            }
            catch (ModelException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
            }
            boolean bl = nameMatch = this.isExactMatch ? method.getElementName().equals(this.namePrefix) : method.getElementName().startsWith(this.namePrefix);
            if (!this.methods.contains(method) && nameMatch && (flags & 0x20) == 0 && this.acceptStatic(flags) && (flags & 8) == 0 && !isConstructor) {
                this.methods.add(method);
            }
        }

        protected boolean acceptStatic(int flags) {
            return (flags & 0x100) == 0;
        }

        public List<IMethod> getMethods() {
            return this.methods;
        }
    }
}

