/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.codeassist.keywords;

import java.util.List;
import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.dltk.mod.core.CompletionProposal;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.codeassist.keywords.CompletionContext;
import org.eclipse.vjet.eclipse.codeassist.keywords.MethodCompletionHandler;

public class StaticMemberAccessHandler
extends MethodCompletionHandler {
    private IJstType jstType;
    private String typeName;

    @Override
    protected MethodCompletionHandler.TypeMembersRequestor createTypeMemberRequestor(JstCompletion completion, String token, IType type) {
        CompletionContext.setStaticContext(true);
        MethodCompletionHandler.TypeMembersRequestor requestor = new MethodCompletionHandler.TypeMembersRequestor(token, false, type, completion){

            @Override
            protected boolean accept(IMember member, int flags) {
                boolean accept;
                String name = member.getDeclaringType().getElementName();
                boolean bl = accept = super.accept(member, flags) && (StaticMemberAccessHandler.this.getTypeName().equals(name) || name.equals("Global"));
                return accept && (this.isStatic(flags) || member.getElementName().equalsIgnoreCase("instanceOf"));
            }
        };
        return requestor;
    }

    @Override
    protected void addLocalVarProposals(IMethod method, String token, List<CompletionProposal> list, int position) {
    }

    public IJstType getJstType() {
        return this.jstType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setJstType(IJstType jstType) {
        this.jstType = jstType;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    protected IType getType(ISourceModule module) {
        IType type = null;
        if (this.jstType != null) {
            String nullPackagePrefix = "null.";
            String typeName = this.jstType.getName();
            if (typeName.startsWith(nullPackagePrefix)) {
                typeName = typeName.substring(nullPackagePrefix.length());
            }
            if ((type = CodeassistUtils.findResourceType(module, typeName)) == null) {
                type = super.getType(module);
            }
        } else {
            type = super.getType(module);
        }
        return type;
    }
}

