/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.vjet.dsf.jst.IJstParseController;
import org.eclipse.vjet.dsf.jstojava.controller.JstParseController;
import org.eclipse.vjet.dsf.jstojava.resolver.FunctionParamsMetaRegistry;
import org.eclipse.vjet.dsf.jstojava.resolver.OTypeResolverRegistry;
import org.eclipse.vjet.dsf.jstojava.resolver.ThisObjScopeResolverRegistry;
import org.eclipse.vjet.dsf.jstojava.resolver.TypeConstructorRegistry;
import org.eclipse.vjet.dsf.jstojava.resolver.TypeResolverRegistry;
import org.eclipse.vjet.eclipse.core.PiggyBackClassPathUtil;
import org.eclipse.vjet.eclipse.core.builder.TypeSpaceBuilder;
import org.eclipse.vjet.eclipse.core.parser.VjoParserToJstAndIType;
import org.eclipse.vjet.eclipse.core.ts.EclipseTypeSpaceLoader;
import org.eclipse.vjet.eclipse.core.ts.JstLibResolver;
import org.eclipse.vjet.eclipse.core.ts.TypeSpaceLoadJob;
import org.eclipse.vjet.eclipse.core.typeconstruct.FunctionParamMappingExtensionRegistry;
import org.eclipse.vjet.eclipse.core.typeconstruct.FunctionParamResolverExtension;
import org.eclipse.vjet.eclipse.core.typeconstruct.FunctionReturnTypeResolverExtension;
import org.eclipse.vjet.eclipse.core.typeconstruct.FunctionReturnTypeResolverExtensionRegistry;
import org.eclipse.vjet.eclipse.core.typeconstruct.OTypeResolverExtension;
import org.eclipse.vjet.eclipse.core.typeconstruct.OTypeResolverExtensionRegistry;
import org.eclipse.vjet.eclipse.core.typeconstruct.ThisScopeResolverExtension;
import org.eclipse.vjet.eclipse.core.typeconstruct.ThisScopeResolverExtensionRegistry;
import org.eclipse.vjet.eclipse.core.typeconstruct.TypeConstructResolverExtension;
import org.eclipse.vjet.eclipse.core.typeconstruct.TypeConstructResolverExtensionRegistry;
import org.eclipse.vjet.eclipse.core.validation.DefaultValidator;
import org.eclipse.vjet.eclipse.internal.formatter.DefaultCodeFormatterConstants;
import org.eclipse.vjet.vjo.lib.IResourceResolver;
import org.eclipse.vjet.vjo.lib.LibManager;
import org.eclipse.vjet.vjo.lib.ResourceHelper;
import org.eclipse.vjet.vjo.tool.typespace.ITypeSpaceLoader;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;
import org.osgi.framework.BundleContext;

public class VjetPlugin
extends Plugin {
    private static VjetPlugin plugin;
    public static final String PLUGIN_ID = "org.eclipse.vjet.eclipse.core";
    public static final String VJO_SUBFIX = ".js";
    public static final String VJETVALIDATION = "VJETVALIDATION";
    private TypeSpaceMgr m_typeSpaceMgr = TypeSpaceMgr.getInstance();
    public static final String SDK_CONTAINER = "org.eclipse.vjet.eclipse.core.SDK_CONTAINER";
    public static final String ID_DEFAULT_SDK = "DEFUALT_SDK";
    public static final String JS_DEFAULT_SDK = "org.eclipse.vjet.eclipse.core.JSNATIVE_CONTAINER";
    public static final String JS_DEFAULT_SDK_LABEL = "JS Native Types";
    public static final String DES_VJET_SDK = "VJET SDK";
    public static final String JSNATIVESDK_ID = "org.eclipse.vjet.eclipse.core.JSNATIVE_CONTAINER";
    public static final String BROWSERSDK_LABEL = "Browser SDK";
    public static final String BROWSERSDK_ID = "org.eclipse.vjet.eclipse.core.BROWSER_CONTAINER";
    public static final String VJOLIB_ID = "org.eclipse.vjet.eclipse.core.VJO_CONTAINER";
    public static final String VJETTL_ID = "org.eclipse.vjet.eclipse.core.VJETTL";
    public static final String VJOLIB_LABEL = "VJO LIB";
    public static final String BUILDER_ID = "org.eclipse.vjet.eclipse.core.builder";
    public static final boolean DEBUG;
    public static final boolean DEBUG_SCRIPT_BUILDER;
    public static final boolean TRACE_SCRIPT_BUILDER;
    public static final boolean TRACE_TYPESPACE;
    public static final boolean TRACE_PARSER;
    public static final String INSERT = "insert";
    public static final String DO_NOT_INSERT = "do not insert";
    public static final String SPACE = "space";
    public static final String TAB = "tab";
    public static final String COMPILER_SOURCE = "org.eclipse.vjet.eclipse.core.compiler.source";
    public static final String COMPILER_COMPLIANCE = "org.eclipse.vjet.eclipse.core.compiler.compliance";
    public static final String COMPILER_LOCAL_VARIABLE_ATTR = "org.eclipse.vjet.eclipse.core.compiler.debug.localVariable";
    public static final String COMPILER_LINE_NUMBER_ATTR = "org.eclipse.vjet.eclipse.core.compiler.debug.lineNumber";
    public static final String COMPILER_SOURCE_FILE_ATTR = "org.eclipse.vjet.eclipse.core.compiler.debug.sourceFile";
    public static final String COMPILER_CODEGEN_UNUSED_LOCAL = "org.eclipse.vjet.eclipse.core.compiler.codegen.unusedLocal";
    public static final String COMPILER_CODEGEN_TARGET_PLATFORM = "org.eclipse.vjet.eclipse.core.compiler.codegen.targetPlatform";
    public static final String COMPILER_CODEGEN_INLINE_JSR_BYTECODE = "org.eclipse.vjet.eclipse.core.compiler.codegen.inlineJsrBytecode";
    public static final String COMPILER_DOC_COMMENT_SUPPORT = "org.eclipse.vjet.eclipse.core.compiler.doc.comment.support";
    public static final String COMPILER_PB_ASSERT_IDENTIFIER = "org.eclipse.vjet.eclipse.core.compiler.problem.assertIdentifier";
    public static final String ABORT = "abort";
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String IGNORE = "ignore";
    public static final String VERSION_1_1 = "1.1";
    public static final String VERSION_1_2 = "1.2";
    public static final String VERSION_1_3 = "1.3";
    public static final String VERSION_1_4 = "1.4";
    public static final String VERSION_1_5 = "1.5";
    public static final String VERSION_1_6 = "1.6";
    public static final String VERSION_1_7 = "1.7";
    private TypeSpaceLoadJob m_loadJob = new TypeSpaceLoadJob();
    private EclipseTypeSpaceLoader loader = new EclipseTypeSpaceLoader();

    static {
        DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.mod.core/debug"));
        DEBUG_SCRIPT_BUILDER = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.vjet.eclipse.core/debugScriptBuilder"));
        TRACE_SCRIPT_BUILDER = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.vjet.eclipse.core/traceScriptBuilder"));
        TRACE_TYPESPACE = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.vjet.eclipse.core/typespace"));
        TRACE_PARSER = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.vjet.eclipse.core/traceParser"));
    }

    public static VjetPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ResourceHelper jstLibResolver = JstLibResolver.getInstance().setSdkEnvironment(PiggyBackClassPathUtil.getSdkEnvironment());
        LibManager.getInstance().setResourceResolver((IResourceResolver)jstLibResolver);
        this.m_typeSpaceMgr.setTypeLoader((ITypeSpaceLoader)this.loader);
        JstParseController controller = VjoParserToJstAndIType.getJstParseController();
        this.m_typeSpaceMgr.init((IJstParseController)controller);
        TypeSpaceBuilder.addGroupEventListeners(this.m_typeSpaceMgr.getController().getJstTypeSpaceMgr());
        if (TRACE_TYPESPACE) {
            this.addTraceGroupEventListeners();
        }
        VjetPlugin.setPluginInstance(this);
        DefaultValidator.getValidator();
        this.m_loadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                VjetPlugin.this.loader.setStarted(true);
            }
        });
        this.initTypeCostructorRegistry();
        this.initFunctionParamsRegistry();
        this.initThisObjScopeResolverRegistry();
        this.initFunctionReturnTypeRegistry();
        this.initOTypeRegistry();
        this.m_loadJob.schedule();
    }

    private void initTypeCostructorRegistry() {
        TypeConstructorRegistry registry = TypeConstructorRegistry.getInstance();
        TypeConstructResolverExtensionRegistry extensionRegistry = new TypeConstructResolverExtensionRegistry();
        Collection<TypeConstructResolverExtension> extensions = extensionRegistry.getResolverExtensions();
        for (TypeConstructResolverExtension extension : extensions) {
            try {
                registry.addResolver(extension.getKey(), extension.createResolver());
            }
            catch (CoreException e) {
                VjetPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Error intializing the " + extension.toString() + " resolver.", (Throwable)e));
            }
        }
    }

    private void initFunctionParamsRegistry() {
        FunctionParamsMetaRegistry registry = FunctionParamsMetaRegistry.getInstance();
        FunctionParamMappingExtensionRegistry extensionRegistry = new FunctionParamMappingExtensionRegistry();
        Collection<FunctionParamResolverExtension> extensions = extensionRegistry.getResolverExtensions();
        for (FunctionParamResolverExtension extension : extensions) {
            try {
                registry.addMapping(extension.createResolver());
            }
            catch (CoreException e) {
                VjetPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Error intializing the " + extension.toString() + " resolver.", (Throwable)e));
            }
        }
    }

    private void initThisObjScopeResolverRegistry() {
        ThisObjScopeResolverRegistry registry = ThisObjScopeResolverRegistry.getInstance();
        ThisScopeResolverExtensionRegistry extensionRegistry = new ThisScopeResolverExtensionRegistry();
        Collection<ThisScopeResolverExtension> extensions = extensionRegistry.getResolverExtensions();
        for (ThisScopeResolverExtension extension : extensions) {
            try {
                registry.addResolver(extension.getKey(), extension.createResolver());
            }
            catch (CoreException e) {
                VjetPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Error intializing the " + extension.toString() + " resolver.", (Throwable)e));
            }
        }
    }

    private void initFunctionReturnTypeRegistry() {
        TypeResolverRegistry registry = TypeResolverRegistry.getInstance();
        FunctionReturnTypeResolverExtensionRegistry extensionRegistry = new FunctionReturnTypeResolverExtensionRegistry();
        Collection<FunctionReturnTypeResolverExtension> extensions = extensionRegistry.getResolverExtensions();
        for (FunctionReturnTypeResolverExtension extension : extensions) {
            try {
                registry.addResolver(extension.getKey(), extension.createResolver());
            }
            catch (CoreException e) {
                VjetPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Error intializing the functionreturntype " + extension.toString() + " resolver.", (Throwable)e));
            }
        }
    }

    private void initOTypeRegistry() {
        OTypeResolverRegistry registry = OTypeResolverRegistry.getInstance();
        OTypeResolverExtensionRegistry extensionRegistry = new OTypeResolverExtensionRegistry();
        Collection<OTypeResolverExtension> extensions = extensionRegistry.getResolverExtensions();
        for (OTypeResolverExtension extension : extensions) {
            try {
                registry.addResolver(extension.getKey(), extension.createResolver());
            }
            catch (CoreException e) {
                VjetPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Error intializing the otypedef " + extension.toString() + " resolver.", (Throwable)e));
            }
        }
    }

    private void addTraceGroupEventListeners() {
        TypeSpaceBuilder.addGroupTraceEventListeners(this.m_typeSpaceMgr.getController().getJstTypeSpaceMgr());
    }

    private static void setPluginInstance(VjetPlugin pluginPar) {
        plugin = pluginPar;
    }

    public void stop(BundleContext context) throws Exception {
        VjetPlugin.setPluginInstance(null);
        super.stop(context);
        this.loader.setStarted(false);
    }

    public static void error(String message) {
        VjetPlugin.error(message, 4);
    }

    public static void error(String message, int status) {
        plugin.getLog().log((IStatus)new Status(status, PLUGIN_ID, 0, message, null));
    }

    public static void error(String message, Throwable t) {
        VjetPlugin.error(message, t, 4);
    }

    public static void error(String message, Throwable t, int status) {
        plugin.getLog().log((IStatus)new Status(status, PLUGIN_ID, 0, message, t));
    }

    public static Map getOptions() {
        return DefaultCodeFormatterConstants.getJavaConventionsSettings();
    }
}

