/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.search;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.eclipse.core.search.IVjoOccurrenceSearcher;
import org.eclipse.vjet.eclipse.core.search.VjoFieldSearcher;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.eclipse.core.search.VjoMethodSearcher;
import org.eclipse.vjet.eclipse.core.search.VjoTypeSearcher;

public final class VjoSearchOccurrenceEngine {
    private static final int FIELD = 0;
    private static final int METHOD = 1;
    private static final int TYPE = 2;
    private static Map<Integer, IVjoOccurrenceSearcher> s_map = new HashMap<Integer, IVjoOccurrenceSearcher>(3);

    static {
        s_map.put(0, new VjoFieldSearcher());
        s_map.put(1, new VjoMethodSearcher());
        s_map.put(2, new VjoTypeSearcher());
    }

    private VjoSearchOccurrenceEngine() {
    }

    public static List<VjoMatch> findOccurrence(IJstNode node, IJstNode scope) {
        IVjoOccurrenceSearcher searcher = VjoSearchOccurrenceEngine.getSearcher(node);
        if (searcher == null) {
            return Collections.emptyList();
        }
        return searcher.findOccurrence(node, scope);
    }

    private static IVjoOccurrenceSearcher getSearcher(IJstNode node) {
        int searchType = -1;
        if (VjoSearchOccurrenceEngine.isField(node)) {
            searchType = 0;
        } else if (VjoSearchOccurrenceEngine.isMethod(node)) {
            searchType = 1;
        } else if (VjoSearchOccurrenceEngine.isType(node)) {
            searchType = 2;
        }
        return VjoSearchOccurrenceEngine.getSearcher(searchType);
    }

    private static IVjoOccurrenceSearcher getSearcher(int searchType) {
        return s_map.get(searchType);
    }

    private static boolean isField(IJstNode node) {
        return node instanceof JstVars || node instanceof JstArg || node instanceof IJstProperty;
    }

    private static boolean isMethod(IJstNode node) {
        return node instanceof IJstMethod;
    }

    private static boolean isType(IJstNode node) {
        return node instanceof IJstType;
    }
}

