/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.search;

import java.util.List;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.search.SearchPattern;
import org.eclipse.dltk.mod.internal.core.search.matching.TypeReferencePattern;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.traversal.IJstVisitor;
import org.eclipse.vjet.dsf.jst.traversal.JstDepthFirstTraversal;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.search.AbstractVjoElementSearcher;
import org.eclipse.vjet.eclipse.core.search.SearchQueryParameters;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.eclipse.core.search.VjoTypeReferencesVisitor;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;

public class VjoTypeReferencesSearcher
extends AbstractVjoElementSearcher {
    @Override
    public Class<? extends SearchPattern> getSearchPatternClass() {
        return TypeReferencePattern.class;
    }

    @Override
    protected void searchDeclarations(SearchQueryParameters params, List<VjoMatch> result) {
    }

    @Override
    protected void searchReferences(SearchQueryParameters params, List<VjoMatch> result) {
        IType type = (IType)params.getElement();
        System.out.println("Searching for references of " + type.getElementName());
        IVjoSourceModule module = (IVjoSourceModule)type.getSourceModule();
        TypeName typeName = module.getTypeName();
        SourceTypeName typeName2 = new SourceTypeName(typeName.groupName(), type.getFullyQualifiedName("."));
        List dependents = this.mgr.getDirectDependents((TypeName)typeName2);
        for (IJstType dependentType : dependents) {
            this.findRefs(type, dependentType, result);
        }
        String groupName = type.getScriptProject().getElementName();
        String fullTypeName = type.getFullyQualifiedName(".").replace('/', '.');
        IJstType declaringType = this.mgr.findType(new TypeName(groupName, fullTypeName));
        this.findRefs(type, declaringType, result);
    }

    private void findRefs(IType mainType, IJstType dependentType, List<VjoMatch> result) {
        VjoTypeReferencesVisitor typeRefVisitor = new VjoTypeReferencesVisitor(mainType, dependentType, result);
        JstDepthFirstTraversal.accept((IJstNode)dependentType, (IJstVisitor)typeRefVisitor);
    }
}

