/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.ts;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.vjet.vjo.tool.typespace.TypeLoadMonitor;

public class EclipseTypeLoadMonitor
extends TypeLoadMonitor {
    private static final String LOADING_TYPE = "Loading type";
    private static final String PREPARATION_LIST_OF_TYPES = "Preparation of the list of types";
    private IProgressMonitor m_monitor;
    private int m_count;
    private float lastPercent;

    public EclipseTypeLoadMonitor(IProgressMonitor monitor) {
        this.m_monitor = monitor;
    }

    public void loadTypeFinished() {
        this.m_monitor.worked(100);
        this.m_monitor.done();
        System.out.println("percent = 100");
    }

    public void loadTypeListFinished() {
        this.m_monitor.worked(100);
        this.m_monitor.done();
        System.out.println("percent = 100");
    }

    public void loadTypeListStarted(int typesCount) {
        this.m_monitor.beginTask(LOADING_TYPE, 100);
    }

    public void loadTypeStarted(String group, String file) {
        ++this.m_count;
        this.m_monitor.subTask(file);
        this.m_monitor.worked(this.m_count);
        this.setCanceled(this.m_monitor.isCanceled());
    }

    public void loadTypeStarted(float percent) {
        if (this.lastPercent != percent) {
            this.m_monitor.worked((int)(percent - this.lastPercent));
            this.lastPercent = percent;
        }
    }

    public void preparationTypeListFinished() {
        this.m_monitor.worked(5);
    }

    public void preparationTypeListStarted() {
        this.m_monitor.setTaskName(PREPARATION_LIST_OF_TYPES);
    }
}

